/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ssm.;
import software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask;
import software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTaskProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnMaintenanceWindowTask")
public class CfnMaintenanceWindowTask
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnMaintenanceWindowTask.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnMaintenanceWindowTask(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMaintenanceWindowTask(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnMaintenanceWindowTask(Construct scope, String id, CfnMaintenanceWindowTaskProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public String getMaxConcurrency() {
        return (String)this.jsiiGet("maxConcurrency", String.class);
    }

    public void setMaxConcurrency(String value) {
        this.jsiiSet("maxConcurrency", Objects.requireNonNull(value, "maxConcurrency is required"));
    }

    public String getMaxErrors() {
        return (String)this.jsiiGet("maxErrors", String.class);
    }

    public void setMaxErrors(String value) {
        this.jsiiSet("maxErrors", Objects.requireNonNull(value, "maxErrors is required"));
    }

    public Number getPriority() {
        return (Number)this.jsiiGet("priority", Number.class);
    }

    public void setPriority(Number value) {
        this.jsiiSet("priority", Objects.requireNonNull(value, "priority is required"));
    }

    public Object getTargets() {
        return this.jsiiGet("targets", Object.class);
    }

    public void setTargets(IResolvable value) {
        this.jsiiSet("targets", Objects.requireNonNull(value, "targets is required"));
    }

    public void setTargets(List<Object> value) {
        this.jsiiSet("targets", Objects.requireNonNull(value, "targets is required"));
    }

    public String getTaskArn() {
        return (String)this.jsiiGet("taskArn", String.class);
    }

    public void setTaskArn(String value) {
        this.jsiiSet("taskArn", Objects.requireNonNull(value, "taskArn is required"));
    }

    public Object getTaskParameters() {
        return this.jsiiGet("taskParameters", Object.class);
    }

    public void setTaskParameters(Object value) {
        this.jsiiSet("taskParameters", Objects.requireNonNull(value, "taskParameters is required"));
    }

    public String getTaskType() {
        return (String)this.jsiiGet("taskType", String.class);
    }

    public void setTaskType(String value) {
        this.jsiiSet("taskType", Objects.requireNonNull(value, "taskType is required"));
    }

    public String getWindowId() {
        return (String)this.jsiiGet("windowId", String.class);
    }

    public void setWindowId(String value) {
        this.jsiiSet("windowId", Objects.requireNonNull(value, "windowId is required"));
    }

    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(String value) {
        this.jsiiSet("description", value);
    }

    public Object getLoggingInfo() {
        return this.jsiiGet("loggingInfo", Object.class);
    }

    public void setLoggingInfo(IResolvable value) {
        this.jsiiSet("loggingInfo", value);
    }

    public void setLoggingInfo(LoggingInfoProperty value) {
        this.jsiiSet("loggingInfo", value);
    }

    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(String value) {
        this.jsiiSet("name", value);
    }

    public String getServiceRoleArn() {
        return (String)this.jsiiGet("serviceRoleArn", String.class);
    }

    public void setServiceRoleArn(String value) {
        this.jsiiSet("serviceRoleArn", value);
    }

    public Object getTaskInvocationParameters() {
        return this.jsiiGet("taskInvocationParameters", Object.class);
    }

    public void setTaskInvocationParameters(IResolvable value) {
        this.jsiiSet("taskInvocationParameters", value);
    }

    public void setTaskInvocationParameters(TaskInvocationParametersProperty value) {
        this.jsiiSet("taskInvocationParameters", value);
    }

    public static interface TaskInvocationParametersProperty
    extends JsiiSerializable {
        public Object getMaintenanceWindowAutomationParameters();

        public Object getMaintenanceWindowLambdaParameters();

        public Object getMaintenanceWindowRunCommandParameters();

        public Object getMaintenanceWindowStepFunctionsParameters();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object maintenanceWindowAutomationParameters;
            private Object maintenanceWindowLambdaParameters;
            private Object maintenanceWindowRunCommandParameters;
            private Object maintenanceWindowStepFunctionsParameters;

            public Builder maintenanceWindowAutomationParameters(IResolvable maintenanceWindowAutomationParameters) {
                this.maintenanceWindowAutomationParameters = maintenanceWindowAutomationParameters;
                return this;
            }

            public Builder maintenanceWindowAutomationParameters(MaintenanceWindowAutomationParametersProperty maintenanceWindowAutomationParameters) {
                this.maintenanceWindowAutomationParameters = maintenanceWindowAutomationParameters;
                return this;
            }

            public Builder maintenanceWindowLambdaParameters(IResolvable maintenanceWindowLambdaParameters) {
                this.maintenanceWindowLambdaParameters = maintenanceWindowLambdaParameters;
                return this;
            }

            public Builder maintenanceWindowLambdaParameters(MaintenanceWindowLambdaParametersProperty maintenanceWindowLambdaParameters) {
                this.maintenanceWindowLambdaParameters = maintenanceWindowLambdaParameters;
                return this;
            }

            public Builder maintenanceWindowRunCommandParameters(IResolvable maintenanceWindowRunCommandParameters) {
                this.maintenanceWindowRunCommandParameters = maintenanceWindowRunCommandParameters;
                return this;
            }

            public Builder maintenanceWindowRunCommandParameters(MaintenanceWindowRunCommandParametersProperty maintenanceWindowRunCommandParameters) {
                this.maintenanceWindowRunCommandParameters = maintenanceWindowRunCommandParameters;
                return this;
            }

            public Builder maintenanceWindowStepFunctionsParameters(IResolvable maintenanceWindowStepFunctionsParameters) {
                this.maintenanceWindowStepFunctionsParameters = maintenanceWindowStepFunctionsParameters;
                return this;
            }

            public Builder maintenanceWindowStepFunctionsParameters(MaintenanceWindowStepFunctionsParametersProperty maintenanceWindowStepFunctionsParameters) {
                this.maintenanceWindowStepFunctionsParameters = maintenanceWindowStepFunctionsParameters;
                return this;
            }

            public TaskInvocationParametersProperty build() {
                return new Jsii.Proxy(this.maintenanceWindowAutomationParameters, this.maintenanceWindowLambdaParameters, this.maintenanceWindowRunCommandParameters, this.maintenanceWindowStepFunctionsParameters, null);
            }
        }
    }

    public static interface TargetProperty
    extends JsiiSerializable {
        public String getKey();

        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private List<String> values;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public TargetProperty build() {
                return new Jsii.Proxy(this.key, this.values, null);
            }
        }
    }

    public static interface NotificationConfigProperty
    extends JsiiSerializable {
        public String getNotificationArn();

        public List<String> getNotificationEvents();

        public String getNotificationType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String notificationArn;
            private List<String> notificationEvents;
            private String notificationType;

            public Builder notificationArn(String notificationArn) {
                this.notificationArn = notificationArn;
                return this;
            }

            public Builder notificationEvents(List<String> notificationEvents) {
                this.notificationEvents = notificationEvents;
                return this;
            }

            public Builder notificationType(String notificationType) {
                this.notificationType = notificationType;
                return this;
            }

            public NotificationConfigProperty build() {
                return new Jsii.Proxy(this.notificationArn, this.notificationEvents, this.notificationType, null);
            }
        }
    }

    public static interface MaintenanceWindowStepFunctionsParametersProperty
    extends JsiiSerializable {
        public String getInput();

        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String input;
            private String name;

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public MaintenanceWindowStepFunctionsParametersProperty build() {
                return new Jsii.Proxy(this.input, this.name, null);
            }
        }
    }

    public static interface MaintenanceWindowRunCommandParametersProperty
    extends JsiiSerializable {
        public String getComment();

        public String getDocumentHash();

        public String getDocumentHashType();

        public Object getNotificationConfig();

        public String getOutputS3BucketName();

        public String getOutputS3KeyPrefix();

        public Object getParameters();

        public String getServiceRoleArn();

        public Number getTimeoutSeconds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String comment;
            private String documentHash;
            private String documentHashType;
            private Object notificationConfig;
            private String outputS3BucketName;
            private String outputS3KeyPrefix;
            private Object parameters;
            private String serviceRoleArn;
            private Number timeoutSeconds;

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Builder documentHash(String documentHash) {
                this.documentHash = documentHash;
                return this;
            }

            public Builder documentHashType(String documentHashType) {
                this.documentHashType = documentHashType;
                return this;
            }

            public Builder notificationConfig(IResolvable notificationConfig) {
                this.notificationConfig = notificationConfig;
                return this;
            }

            public Builder notificationConfig(NotificationConfigProperty notificationConfig) {
                this.notificationConfig = notificationConfig;
                return this;
            }

            public Builder outputS3BucketName(String outputS3BucketName) {
                this.outputS3BucketName = outputS3BucketName;
                return this;
            }

            public Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
                this.outputS3KeyPrefix = outputS3KeyPrefix;
                return this;
            }

            public Builder parameters(Object parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder serviceRoleArn(String serviceRoleArn) {
                this.serviceRoleArn = serviceRoleArn;
                return this;
            }

            public Builder timeoutSeconds(Number timeoutSeconds) {
                this.timeoutSeconds = timeoutSeconds;
                return this;
            }

            public MaintenanceWindowRunCommandParametersProperty build() {
                return new Jsii.Proxy(this.comment, this.documentHash, this.documentHashType, this.notificationConfig, this.outputS3BucketName, this.outputS3KeyPrefix, this.parameters, this.serviceRoleArn, this.timeoutSeconds, null);
            }
        }
    }

    public static interface MaintenanceWindowLambdaParametersProperty
    extends JsiiSerializable {
        public String getClientContext();

        public String getPayload();

        public String getQualifier();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String clientContext;
            private String payload;
            private String qualifier;

            public Builder clientContext(String clientContext) {
                this.clientContext = clientContext;
                return this;
            }

            public Builder payload(String payload) {
                this.payload = payload;
                return this;
            }

            public Builder qualifier(String qualifier) {
                this.qualifier = qualifier;
                return this;
            }

            public MaintenanceWindowLambdaParametersProperty build() {
                return new Jsii.Proxy(this.clientContext, this.payload, this.qualifier, null);
            }
        }
    }

    public static interface MaintenanceWindowAutomationParametersProperty
    extends JsiiSerializable {
        public String getDocumentVersion();

        public Object getParameters();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String documentVersion;
            private Object parameters;

            public Builder documentVersion(String documentVersion) {
                this.documentVersion = documentVersion;
                return this;
            }

            public Builder parameters(Object parameters) {
                this.parameters = parameters;
                return this;
            }

            public MaintenanceWindowAutomationParametersProperty build() {
                return new Jsii.Proxy(this.documentVersion, this.parameters, null);
            }
        }
    }

    public static interface LoggingInfoProperty
    extends JsiiSerializable {
        public String getRegion();

        public String getS3Bucket();

        public String getS3Prefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String region;
            private String s3Bucket;
            private String s3Prefix;

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder s3Bucket(String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            public Builder s3Prefix(String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            public LoggingInfoProperty build() {
                return new Jsii.Proxy(this.region, this.s3Bucket, this.s3Prefix, null);
            }
        }
    }
}

