/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.List;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask;
import software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTaskProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnMaintenanceWindowTaskProps
extends JsiiSerializable {
    public String getMaxConcurrency();

    public String getMaxErrors();

    public Number getPriority();

    public Object getTargets();

    public String getTaskArn();

    public String getTaskType();

    public String getWindowId();

    public String getDescription();

    public Object getLoggingInfo();

    public String getName();

    public String getServiceRoleArn();

    public Object getTaskInvocationParameters();

    public Object getTaskParameters();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String maxConcurrency;
        private String maxErrors;
        private Number priority;
        private Object targets;
        private String taskArn;
        private String taskType;
        private String windowId;
        private String description;
        private Object loggingInfo;
        private String name;
        private String serviceRoleArn;
        private Object taskInvocationParameters;
        private Object taskParameters;

        public Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public Builder priority(Number priority) {
            this.priority = priority;
            return this;
        }

        public Builder targets(IResolvable targets) {
            this.targets = targets;
            return this;
        }

        public Builder targets(List<Object> targets) {
            this.targets = targets;
            return this;
        }

        public Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        public Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder loggingInfo(IResolvable loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public Builder loggingInfo(CfnMaintenanceWindowTask.LoggingInfoProperty loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public Builder taskInvocationParameters(IResolvable taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public Builder taskInvocationParameters(CfnMaintenanceWindowTask.TaskInvocationParametersProperty taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public Builder taskParameters(Object taskParameters) {
            this.taskParameters = taskParameters;
            return this;
        }

        public CfnMaintenanceWindowTaskProps build() {
            return new Jsii.Proxy(this.maxConcurrency, this.maxErrors, this.priority, this.targets, this.taskArn, this.taskType, this.windowId, this.description, this.loggingInfo, this.name, this.serviceRoleArn, this.taskInvocationParameters, this.taskParameters, null);
        }
    }
}

