/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ssm.CfnPatchBaseline;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnPatchBaselineProps
extends JsiiSerializable {
    public String getName();

    public Object getApprovalRules();

    public List<String> getApprovedPatches();

    public String getApprovedPatchesComplianceLevel();

    public Object getApprovedPatchesEnableNonSecurity();

    public String getDescription();

    public Object getGlobalFilters();

    public String getOperatingSystem();

    public List<String> getPatchGroups();

    public List<String> getRejectedPatches();

    public String getRejectedPatchesAction();

    public Object getSources();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        @Nullable
        private Object _approvalRules;
        @Nullable
        private List<String> _approvedPatches;
        @Nullable
        private String _approvedPatchesComplianceLevel;
        @Nullable
        private Object _approvedPatchesEnableNonSecurity;
        @Nullable
        private String _description;
        @Nullable
        private Object _globalFilters;
        @Nullable
        private String _operatingSystem;
        @Nullable
        private List<String> _patchGroups;
        @Nullable
        private List<String> _rejectedPatches;
        @Nullable
        private String _rejectedPatchesAction;
        @Nullable
        private Object _sources;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withApprovalRules(@Nullable Token value) {
            this._approvalRules = value;
            return this;
        }

        public Builder withApprovalRules(@Nullable CfnPatchBaseline.RuleGroupProperty value) {
            this._approvalRules = value;
            return this;
        }

        public Builder withApprovedPatches(@Nullable List<String> value) {
            this._approvedPatches = value;
            return this;
        }

        public Builder withApprovedPatchesComplianceLevel(@Nullable String value) {
            this._approvedPatchesComplianceLevel = value;
            return this;
        }

        public Builder withApprovedPatchesEnableNonSecurity(@Nullable Boolean value) {
            this._approvedPatchesEnableNonSecurity = value;
            return this;
        }

        public Builder withApprovedPatchesEnableNonSecurity(@Nullable Token value) {
            this._approvedPatchesEnableNonSecurity = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withGlobalFilters(@Nullable Token value) {
            this._globalFilters = value;
            return this;
        }

        public Builder withGlobalFilters(@Nullable CfnPatchBaseline.PatchFilterGroupProperty value) {
            this._globalFilters = value;
            return this;
        }

        public Builder withOperatingSystem(@Nullable String value) {
            this._operatingSystem = value;
            return this;
        }

        public Builder withPatchGroups(@Nullable List<String> value) {
            this._patchGroups = value;
            return this;
        }

        public Builder withRejectedPatches(@Nullable List<String> value) {
            this._rejectedPatches = value;
            return this;
        }

        public Builder withRejectedPatchesAction(@Nullable String value) {
            this._rejectedPatchesAction = value;
            return this;
        }

        public Builder withSources(@Nullable Token value) {
            this._sources = value;
            return this;
        }

        public Builder withSources(@Nullable List<Object> value) {
            this._sources = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnPatchBaselineProps build() {
            return new CfnPatchBaselineProps(){
                private final String $name;
                @Nullable
                private final Object $approvalRules;
                @Nullable
                private final List<String> $approvedPatches;
                @Nullable
                private final String $approvedPatchesComplianceLevel;
                @Nullable
                private final Object $approvedPatchesEnableNonSecurity;
                @Nullable
                private final String $description;
                @Nullable
                private final Object $globalFilters;
                @Nullable
                private final String $operatingSystem;
                @Nullable
                private final List<String> $patchGroups;
                @Nullable
                private final List<String> $rejectedPatches;
                @Nullable
                private final String $rejectedPatchesAction;
                @Nullable
                private final Object $sources;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$approvalRules = _approvalRules;
                    this.$approvedPatches = _approvedPatches;
                    this.$approvedPatchesComplianceLevel = _approvedPatchesComplianceLevel;
                    this.$approvedPatchesEnableNonSecurity = _approvedPatchesEnableNonSecurity;
                    this.$description = _description;
                    this.$globalFilters = _globalFilters;
                    this.$operatingSystem = _operatingSystem;
                    this.$patchGroups = _patchGroups;
                    this.$rejectedPatches = _rejectedPatches;
                    this.$rejectedPatchesAction = _rejectedPatchesAction;
                    this.$sources = _sources;
                    this.$tags = _tags;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public Object getApprovalRules() {
                    return this.$approvalRules;
                }

                @Override
                public List<String> getApprovedPatches() {
                    return this.$approvedPatches;
                }

                @Override
                public String getApprovedPatchesComplianceLevel() {
                    return this.$approvedPatchesComplianceLevel;
                }

                @Override
                public Object getApprovedPatchesEnableNonSecurity() {
                    return this.$approvedPatchesEnableNonSecurity;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Object getGlobalFilters() {
                    return this.$globalFilters;
                }

                @Override
                public String getOperatingSystem() {
                    return this.$operatingSystem;
                }

                @Override
                public List<String> getPatchGroups() {
                    return this.$patchGroups;
                }

                @Override
                public List<String> getRejectedPatches() {
                    return this.$rejectedPatches;
                }

                @Override
                public String getRejectedPatchesAction() {
                    return this.$rejectedPatchesAction;
                }

                @Override
                public Object getSources() {
                    return this.$sources;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    if (this.getApprovalRules() != null) {
                        obj.set("approvalRules", om.valueToTree(this.getApprovalRules()));
                    }
                    if (this.getApprovedPatches() != null) {
                        obj.set("approvedPatches", om.valueToTree(this.getApprovedPatches()));
                    }
                    if (this.getApprovedPatchesComplianceLevel() != null) {
                        obj.set("approvedPatchesComplianceLevel", om.valueToTree((Object)this.getApprovedPatchesComplianceLevel()));
                    }
                    if (this.getApprovedPatchesEnableNonSecurity() != null) {
                        obj.set("approvedPatchesEnableNonSecurity", om.valueToTree(this.getApprovedPatchesEnableNonSecurity()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getGlobalFilters() != null) {
                        obj.set("globalFilters", om.valueToTree(this.getGlobalFilters()));
                    }
                    if (this.getOperatingSystem() != null) {
                        obj.set("operatingSystem", om.valueToTree((Object)this.getOperatingSystem()));
                    }
                    if (this.getPatchGroups() != null) {
                        obj.set("patchGroups", om.valueToTree(this.getPatchGroups()));
                    }
                    if (this.getRejectedPatches() != null) {
                        obj.set("rejectedPatches", om.valueToTree(this.getRejectedPatches()));
                    }
                    if (this.getRejectedPatchesAction() != null) {
                        obj.set("rejectedPatchesAction", om.valueToTree((Object)this.getRejectedPatchesAction()));
                    }
                    if (this.getSources() != null) {
                        obj.set("sources", om.valueToTree(this.getSources()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

