/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ssm.ParameterOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StringParameterProps
extends JsiiSerializable,
ParameterOptions {
    public String getStringValue();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _stringValue;
        @Nullable
        private String _allowedPattern;
        @Nullable
        private String _description;
        @Nullable
        private String _name;

        public Builder withStringValue(String value) {
            this._stringValue = Objects.requireNonNull(value, "stringValue is required");
            return this;
        }

        public Builder withAllowedPattern(@Nullable String value) {
            this._allowedPattern = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public StringParameterProps build() {
            return new StringParameterProps(){
                private final String $stringValue;
                @Nullable
                private final String $allowedPattern;
                @Nullable
                private final String $description;
                @Nullable
                private final String $name;
                {
                    this.$stringValue = Objects.requireNonNull(_stringValue, "stringValue is required");
                    this.$allowedPattern = _allowedPattern;
                    this.$description = _description;
                    this.$name = _name;
                }

                @Override
                public String getStringValue() {
                    return this.$stringValue;
                }

                @Override
                public String getAllowedPattern() {
                    return this.$allowedPattern;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("stringValue", om.valueToTree((Object)this.getStringValue()));
                    obj.set("allowedPattern", om.valueToTree((Object)this.getAllowedPattern()));
                    obj.set("description", om.valueToTree((Object)this.getDescription()));
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    return obj;
                }
            };
        }
    }
}

