/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sqs;

import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.sqs.DeadLetterQueue;
import software.amazon.awscdk.services.sqs.QueueEncryption;
import software.amazon.awscdk.services.sqs.QueueProps;
import software.amazon.jsii.JsiiSerializable;

public interface QueueProps
extends JsiiSerializable {
    public Boolean getContentBasedDeduplication();

    public Duration getDataKeyReuse();

    public DeadLetterQueue getDeadLetterQueue();

    public Duration getDeliveryDelay();

    public QueueEncryption getEncryption();

    public IKey getEncryptionMasterKey();

    public Boolean getFifo();

    public Number getMaxMessageSizeBytes();

    public String getQueueName();

    public Duration getReceiveMessageWaitTime();

    public Duration getRetentionPeriod();

    public Duration getVisibilityTimeout();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean contentBasedDeduplication;
        private Duration dataKeyReuse;
        private DeadLetterQueue deadLetterQueue;
        private Duration deliveryDelay;
        private QueueEncryption encryption;
        private IKey encryptionMasterKey;
        private Boolean fifo;
        private Number maxMessageSizeBytes;
        private String queueName;
        private Duration receiveMessageWaitTime;
        private Duration retentionPeriod;
        private Duration visibilityTimeout;

        public Builder contentBasedDeduplication(Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        public Builder dataKeyReuse(Duration dataKeyReuse) {
            this.dataKeyReuse = dataKeyReuse;
            return this;
        }

        public Builder deadLetterQueue(DeadLetterQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        public Builder deliveryDelay(Duration deliveryDelay) {
            this.deliveryDelay = deliveryDelay;
            return this;
        }

        public Builder encryption(QueueEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder encryptionMasterKey(IKey encryptionMasterKey) {
            this.encryptionMasterKey = encryptionMasterKey;
            return this;
        }

        public Builder fifo(Boolean fifo) {
            this.fifo = fifo;
            return this;
        }

        public Builder maxMessageSizeBytes(Number maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            return this;
        }

        public Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder receiveMessageWaitTime(Duration receiveMessageWaitTime) {
            this.receiveMessageWaitTime = receiveMessageWaitTime;
            return this;
        }

        public Builder retentionPeriod(Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public Builder visibilityTimeout(Duration visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public QueueProps build() {
            return new Jsii.Proxy(this.contentBasedDeduplication, this.dataKeyReuse, this.deadLetterQueue, this.deliveryDelay, this.encryption, this.encryptionMasterKey, this.fifo, this.maxMessageSizeBytes, this.queueName, this.receiveMessageWaitTime, this.retentionPeriod, this.visibilityTimeout, null);
        }
    }
}

