/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sqs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.kms.IEncryptionKey;
import software.amazon.awscdk.services.sqs.DeadLetterQueue;
import software.amazon.awscdk.services.sqs.QueueEncryption;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface QueueProps
extends JsiiSerializable {
    public Boolean getContentBasedDeduplication();

    public Number getDataKeyReuseSec();

    public DeadLetterQueue getDeadLetterQueue();

    public Number getDeliveryDelaySec();

    public QueueEncryption getEncryption();

    public IEncryptionKey getEncryptionMasterKey();

    public Boolean getFifo();

    public Number getMaxMessageSizeBytes();

    public String getQueueName();

    public Number getReceiveMessageWaitTimeSec();

    public Number getRetentionPeriodSec();

    public Number getVisibilityTimeoutSec();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Boolean _contentBasedDeduplication;
        @Nullable
        private Number _dataKeyReuseSec;
        @Nullable
        private DeadLetterQueue _deadLetterQueue;
        @Nullable
        private Number _deliveryDelaySec;
        @Nullable
        private QueueEncryption _encryption;
        @Nullable
        private IEncryptionKey _encryptionMasterKey;
        @Nullable
        private Boolean _fifo;
        @Nullable
        private Number _maxMessageSizeBytes;
        @Nullable
        private String _queueName;
        @Nullable
        private Number _receiveMessageWaitTimeSec;
        @Nullable
        private Number _retentionPeriodSec;
        @Nullable
        private Number _visibilityTimeoutSec;

        public Builder withContentBasedDeduplication(@Nullable Boolean value) {
            this._contentBasedDeduplication = value;
            return this;
        }

        public Builder withDataKeyReuseSec(@Nullable Number value) {
            this._dataKeyReuseSec = value;
            return this;
        }

        public Builder withDeadLetterQueue(@Nullable DeadLetterQueue value) {
            this._deadLetterQueue = value;
            return this;
        }

        public Builder withDeliveryDelaySec(@Nullable Number value) {
            this._deliveryDelaySec = value;
            return this;
        }

        public Builder withEncryption(@Nullable QueueEncryption value) {
            this._encryption = value;
            return this;
        }

        public Builder withEncryptionMasterKey(@Nullable IEncryptionKey value) {
            this._encryptionMasterKey = value;
            return this;
        }

        public Builder withFifo(@Nullable Boolean value) {
            this._fifo = value;
            return this;
        }

        public Builder withMaxMessageSizeBytes(@Nullable Number value) {
            this._maxMessageSizeBytes = value;
            return this;
        }

        public Builder withQueueName(@Nullable String value) {
            this._queueName = value;
            return this;
        }

        public Builder withReceiveMessageWaitTimeSec(@Nullable Number value) {
            this._receiveMessageWaitTimeSec = value;
            return this;
        }

        public Builder withRetentionPeriodSec(@Nullable Number value) {
            this._retentionPeriodSec = value;
            return this;
        }

        public Builder withVisibilityTimeoutSec(@Nullable Number value) {
            this._visibilityTimeoutSec = value;
            return this;
        }

        public QueueProps build() {
            return new QueueProps(){
                @Nullable
                private final Boolean $contentBasedDeduplication;
                @Nullable
                private final Number $dataKeyReuseSec;
                @Nullable
                private final DeadLetterQueue $deadLetterQueue;
                @Nullable
                private final Number $deliveryDelaySec;
                @Nullable
                private final QueueEncryption $encryption;
                @Nullable
                private final IEncryptionKey $encryptionMasterKey;
                @Nullable
                private final Boolean $fifo;
                @Nullable
                private final Number $maxMessageSizeBytes;
                @Nullable
                private final String $queueName;
                @Nullable
                private final Number $receiveMessageWaitTimeSec;
                @Nullable
                private final Number $retentionPeriodSec;
                @Nullable
                private final Number $visibilityTimeoutSec;
                {
                    this.$contentBasedDeduplication = _contentBasedDeduplication;
                    this.$dataKeyReuseSec = _dataKeyReuseSec;
                    this.$deadLetterQueue = _deadLetterQueue;
                    this.$deliveryDelaySec = _deliveryDelaySec;
                    this.$encryption = _encryption;
                    this.$encryptionMasterKey = _encryptionMasterKey;
                    this.$fifo = _fifo;
                    this.$maxMessageSizeBytes = _maxMessageSizeBytes;
                    this.$queueName = _queueName;
                    this.$receiveMessageWaitTimeSec = _receiveMessageWaitTimeSec;
                    this.$retentionPeriodSec = _retentionPeriodSec;
                    this.$visibilityTimeoutSec = _visibilityTimeoutSec;
                }

                @Override
                public Boolean getContentBasedDeduplication() {
                    return this.$contentBasedDeduplication;
                }

                @Override
                public Number getDataKeyReuseSec() {
                    return this.$dataKeyReuseSec;
                }

                @Override
                public DeadLetterQueue getDeadLetterQueue() {
                    return this.$deadLetterQueue;
                }

                @Override
                public Number getDeliveryDelaySec() {
                    return this.$deliveryDelaySec;
                }

                @Override
                public QueueEncryption getEncryption() {
                    return this.$encryption;
                }

                @Override
                public IEncryptionKey getEncryptionMasterKey() {
                    return this.$encryptionMasterKey;
                }

                @Override
                public Boolean getFifo() {
                    return this.$fifo;
                }

                @Override
                public Number getMaxMessageSizeBytes() {
                    return this.$maxMessageSizeBytes;
                }

                @Override
                public String getQueueName() {
                    return this.$queueName;
                }

                @Override
                public Number getReceiveMessageWaitTimeSec() {
                    return this.$receiveMessageWaitTimeSec;
                }

                @Override
                public Number getRetentionPeriodSec() {
                    return this.$retentionPeriodSec;
                }

                @Override
                public Number getVisibilityTimeoutSec() {
                    return this.$visibilityTimeoutSec;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("contentBasedDeduplication", om.valueToTree((Object)this.getContentBasedDeduplication()));
                    obj.set("dataKeyReuseSec", om.valueToTree((Object)this.getDataKeyReuseSec()));
                    obj.set("deadLetterQueue", om.valueToTree((Object)this.getDeadLetterQueue()));
                    obj.set("deliveryDelaySec", om.valueToTree((Object)this.getDeliveryDelaySec()));
                    obj.set("encryption", om.valueToTree((Object)this.getEncryption()));
                    obj.set("encryptionMasterKey", om.valueToTree((Object)this.getEncryptionMasterKey()));
                    obj.set("fifo", om.valueToTree((Object)this.getFifo()));
                    obj.set("maxMessageSizeBytes", om.valueToTree((Object)this.getMaxMessageSizeBytes()));
                    obj.set("queueName", om.valueToTree((Object)this.getQueueName()));
                    obj.set("receiveMessageWaitTimeSec", om.valueToTree((Object)this.getReceiveMessageWaitTimeSec()));
                    obj.set("retentionPeriodSec", om.valueToTree((Object)this.getRetentionPeriodSec()));
                    obj.set("visibilityTimeoutSec", om.valueToTree((Object)this.getVisibilityTimeoutSec()));
                    return obj;
                }
            };
        }
    }
}

