/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.sns.SubscriptionFilter;
import software.amazon.awscdk.services.sns.SubscriptionOptions;
import software.amazon.awscdk.services.sns.SubscriptionProtocol;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TopicSubscriptionConfig
extends JsiiSerializable,
SubscriptionOptions {
    public String getSubscriberId();

    public Construct getSubscriberScope();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _subscriberId;
        @Nullable
        private Construct _subscriberScope;
        private String _endpoint;
        private SubscriptionProtocol _protocol;
        @Nullable
        private Map<String, SubscriptionFilter> _filterPolicy;
        @Nullable
        private Boolean _rawMessageDelivery;

        public Builder withSubscriberId(String value) {
            this._subscriberId = Objects.requireNonNull(value, "subscriberId is required");
            return this;
        }

        public Builder withSubscriberScope(@Nullable Construct value) {
            this._subscriberScope = value;
            return this;
        }

        public Builder withEndpoint(String value) {
            this._endpoint = Objects.requireNonNull(value, "endpoint is required");
            return this;
        }

        public Builder withProtocol(SubscriptionProtocol value) {
            this._protocol = Objects.requireNonNull(value, "protocol is required");
            return this;
        }

        public Builder withFilterPolicy(@Nullable Map<String, SubscriptionFilter> value) {
            this._filterPolicy = value;
            return this;
        }

        public Builder withRawMessageDelivery(@Nullable Boolean value) {
            this._rawMessageDelivery = value;
            return this;
        }

        public TopicSubscriptionConfig build() {
            return new TopicSubscriptionConfig(){
                private final String $subscriberId;
                @Nullable
                private final Construct $subscriberScope;
                private final String $endpoint;
                private final SubscriptionProtocol $protocol;
                @Nullable
                private final Map<String, SubscriptionFilter> $filterPolicy;
                @Nullable
                private final Boolean $rawMessageDelivery;
                {
                    this.$subscriberId = Objects.requireNonNull(_subscriberId, "subscriberId is required");
                    this.$subscriberScope = _subscriberScope;
                    this.$endpoint = Objects.requireNonNull(_endpoint, "endpoint is required");
                    this.$protocol = Objects.requireNonNull(_protocol, "protocol is required");
                    this.$filterPolicy = _filterPolicy;
                    this.$rawMessageDelivery = _rawMessageDelivery;
                }

                @Override
                public String getSubscriberId() {
                    return this.$subscriberId;
                }

                @Override
                public Construct getSubscriberScope() {
                    return this.$subscriberScope;
                }

                @Override
                public String getEndpoint() {
                    return this.$endpoint;
                }

                @Override
                public SubscriptionProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public Map<String, SubscriptionFilter> getFilterPolicy() {
                    return this.$filterPolicy;
                }

                @Override
                public Boolean getRawMessageDelivery() {
                    return this.$rawMessageDelivery;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("subscriberId", om.valueToTree((Object)this.getSubscriberId()));
                    if (this.getSubscriberScope() != null) {
                        obj.set("subscriberScope", om.valueToTree((Object)this.getSubscriberScope()));
                    }
                    obj.set("endpoint", om.valueToTree((Object)this.getEndpoint()));
                    obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    if (this.getFilterPolicy() != null) {
                        obj.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
                    }
                    if (this.getRawMessageDelivery() != null) {
                        obj.set("rawMessageDelivery", om.valueToTree((Object)this.getRawMessageDelivery()));
                    }
                    return obj;
                }
            };
        }
    }
}

