/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.sns.SubscriptionProtocol;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SubscriptionProps
extends JsiiSerializable {
    public String getEndpoint();

    public SubscriptionProtocol getProtocol();

    public ITopic getTopic();

    public Boolean getRawMessageDelivery();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _endpoint;
        private SubscriptionProtocol _protocol;
        private ITopic _topic;
        @Nullable
        private Boolean _rawMessageDelivery;

        public Builder withEndpoint(String value) {
            this._endpoint = Objects.requireNonNull(value, "endpoint is required");
            return this;
        }

        public Builder withProtocol(SubscriptionProtocol value) {
            this._protocol = Objects.requireNonNull(value, "protocol is required");
            return this;
        }

        public Builder withTopic(ITopic value) {
            this._topic = Objects.requireNonNull(value, "topic is required");
            return this;
        }

        public Builder withRawMessageDelivery(@Nullable Boolean value) {
            this._rawMessageDelivery = value;
            return this;
        }

        public SubscriptionProps build() {
            return new SubscriptionProps(){
                private final String $endpoint;
                private final SubscriptionProtocol $protocol;
                private final ITopic $topic;
                @Nullable
                private final Boolean $rawMessageDelivery;
                {
                    this.$endpoint = Objects.requireNonNull(_endpoint, "endpoint is required");
                    this.$protocol = Objects.requireNonNull(_protocol, "protocol is required");
                    this.$topic = Objects.requireNonNull(_topic, "topic is required");
                    this.$rawMessageDelivery = _rawMessageDelivery;
                }

                @Override
                public String getEndpoint() {
                    return this.$endpoint;
                }

                @Override
                public SubscriptionProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public ITopic getTopic() {
                    return this.$topic;
                }

                @Override
                public Boolean getRawMessageDelivery() {
                    return this.$rawMessageDelivery;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("endpoint", om.valueToTree((Object)this.getEndpoint()));
                    obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    obj.set("topic", om.valueToTree((Object)this.getTopic()));
                    if (this.getRawMessageDelivery() != null) {
                        obj.set("rawMessageDelivery", om.valueToTree((Object)this.getRawMessageDelivery()));
                    }
                    return obj;
                }
            };
        }
    }
}

