/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.ses.ReceiptRuleS3ActionProps;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.JsiiSerializable;

public interface ReceiptRuleS3ActionProps
extends JsiiSerializable {
    public IBucket getBucket();

    public IKey getKmsKey();

    public String getObjectKeyPrefix();

    public ITopic getTopic();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket bucket;
        private IKey kmsKey;
        private String objectKeyPrefix;
        private ITopic topic;

        public Builder bucket(IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public Builder objectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
            return this;
        }

        public Builder topic(ITopic topic) {
            this.topic = topic;
            return this;
        }

        public ReceiptRuleS3ActionProps build() {
            return new Jsii.Proxy(this.bucket, this.kmsKey, this.objectKeyPrefix, this.topic, null);
        }
    }
}

