/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ReceiptRuleS3ActionProps
extends JsiiSerializable {
    public IBucket getBucket();

    public IKey getKmsKey();

    public String getObjectKeyPrefix();

    public ITopic getTopic();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _bucket;
        @Nullable
        private IKey _kmsKey;
        @Nullable
        private String _objectKeyPrefix;
        @Nullable
        private ITopic _topic;

        public Builder withBucket(IBucket value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withKmsKey(@Nullable IKey value) {
            this._kmsKey = value;
            return this;
        }

        public Builder withObjectKeyPrefix(@Nullable String value) {
            this._objectKeyPrefix = value;
            return this;
        }

        public Builder withTopic(@Nullable ITopic value) {
            this._topic = value;
            return this;
        }

        public ReceiptRuleS3ActionProps build() {
            return new ReceiptRuleS3ActionProps(){
                private final IBucket $bucket;
                @Nullable
                private final IKey $kmsKey;
                @Nullable
                private final String $objectKeyPrefix;
                @Nullable
                private final ITopic $topic;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$kmsKey = _kmsKey;
                    this.$objectKeyPrefix = _objectKeyPrefix;
                    this.$topic = _topic;
                }

                @Override
                public IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public IKey getKmsKey() {
                    return this.$kmsKey;
                }

                @Override
                public String getObjectKeyPrefix() {
                    return this.$objectKeyPrefix;
                }

                @Override
                public ITopic getTopic() {
                    return this.$topic;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("bucket", om.valueToTree((Object)this.getBucket()));
                    if (this.getKmsKey() != null) {
                        obj.set("kmsKey", om.valueToTree((Object)this.getKmsKey()));
                    }
                    if (this.getObjectKeyPrefix() != null) {
                        obj.set("objectKeyPrefix", om.valueToTree((Object)this.getObjectKeyPrefix()));
                    }
                    if (this.getTopic() != null) {
                        obj.set("topic", om.valueToTree((Object)this.getTopic()));
                    }
                    return obj;
                }
            };
        }
    }
}

