/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.servicediscovery;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.servicediscovery.DnsRecordType;
import software.amazon.awscdk.services.servicediscovery.DnsServiceProps;
import software.amazon.awscdk.services.servicediscovery.HealthCheckConfig;
import software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig;
import software.amazon.awscdk.services.servicediscovery.INamespace;
import software.amazon.awscdk.services.servicediscovery.RoutingPolicy;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ServiceProps
extends JsiiSerializable,
DnsServiceProps {
    public INamespace getNamespace();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private INamespace _namespace;
        @Nullable
        private DnsRecordType _dnsRecordType;
        @Nullable
        private Number _dnsTtlSec;
        @Nullable
        private Boolean _loadBalancer;
        @Nullable
        private RoutingPolicy _routingPolicy;
        @Nullable
        private HealthCheckCustomConfig _customHealthCheck;
        @Nullable
        private String _description;
        @Nullable
        private HealthCheckConfig _healthCheck;
        @Nullable
        private String _name;

        public Builder withNamespace(INamespace value) {
            this._namespace = Objects.requireNonNull(value, "namespace is required");
            return this;
        }

        public Builder withDnsRecordType(@Nullable DnsRecordType value) {
            this._dnsRecordType = value;
            return this;
        }

        public Builder withDnsTtlSec(@Nullable Number value) {
            this._dnsTtlSec = value;
            return this;
        }

        public Builder withLoadBalancer(@Nullable Boolean value) {
            this._loadBalancer = value;
            return this;
        }

        public Builder withRoutingPolicy(@Nullable RoutingPolicy value) {
            this._routingPolicy = value;
            return this;
        }

        public Builder withCustomHealthCheck(@Nullable HealthCheckCustomConfig value) {
            this._customHealthCheck = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheckConfig value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public ServiceProps build() {
            return new ServiceProps(){
                private final INamespace $namespace;
                @Nullable
                private final DnsRecordType $dnsRecordType;
                @Nullable
                private final Number $dnsTtlSec;
                @Nullable
                private final Boolean $loadBalancer;
                @Nullable
                private final RoutingPolicy $routingPolicy;
                @Nullable
                private final HealthCheckCustomConfig $customHealthCheck;
                @Nullable
                private final String $description;
                @Nullable
                private final HealthCheckConfig $healthCheck;
                @Nullable
                private final String $name;
                {
                    this.$namespace = Objects.requireNonNull(_namespace, "namespace is required");
                    this.$dnsRecordType = _dnsRecordType;
                    this.$dnsTtlSec = _dnsTtlSec;
                    this.$loadBalancer = _loadBalancer;
                    this.$routingPolicy = _routingPolicy;
                    this.$customHealthCheck = _customHealthCheck;
                    this.$description = _description;
                    this.$healthCheck = _healthCheck;
                    this.$name = _name;
                }

                @Override
                public INamespace getNamespace() {
                    return this.$namespace;
                }

                @Override
                public DnsRecordType getDnsRecordType() {
                    return this.$dnsRecordType;
                }

                @Override
                public Number getDnsTtlSec() {
                    return this.$dnsTtlSec;
                }

                @Override
                public Boolean getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public RoutingPolicy getRoutingPolicy() {
                    return this.$routingPolicy;
                }

                @Override
                public HealthCheckCustomConfig getCustomHealthCheck() {
                    return this.$customHealthCheck;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public HealthCheckConfig getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("namespace", om.valueToTree((Object)this.getNamespace()));
                    obj.set("dnsRecordType", om.valueToTree((Object)this.getDnsRecordType()));
                    obj.set("dnsTtlSec", om.valueToTree((Object)this.getDnsTtlSec()));
                    obj.set("loadBalancer", om.valueToTree((Object)this.getLoadBalancer()));
                    obj.set("routingPolicy", om.valueToTree((Object)this.getRoutingPolicy()));
                    obj.set("customHealthCheck", om.valueToTree((Object)this.getCustomHealthCheck()));
                    obj.set("description", om.valueToTree((Object)this.getDescription()));
                    obj.set("healthCheck", om.valueToTree((Object)this.getHealthCheck()));
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    return obj;
                }
            };
        }
    }
}

