/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.servicediscovery;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import software.amazon.awscdk.services.servicediscovery.DnsRecordType;
import software.amazon.awscdk.services.servicediscovery.RoutingPolicy;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ServiceAttributes
extends JsiiSerializable {
    public DnsRecordType getDnsRecordType();

    public RoutingPolicy getRoutingPolicy();

    public String getServiceArn();

    public String getServiceId();

    public String getServiceName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DnsRecordType _dnsRecordType;
        private RoutingPolicy _routingPolicy;
        private String _serviceArn;
        private String _serviceId;
        private String _serviceName;

        public Builder withDnsRecordType(DnsRecordType value) {
            this._dnsRecordType = Objects.requireNonNull(value, "dnsRecordType is required");
            return this;
        }

        public Builder withRoutingPolicy(RoutingPolicy value) {
            this._routingPolicy = Objects.requireNonNull(value, "routingPolicy is required");
            return this;
        }

        public Builder withServiceArn(String value) {
            this._serviceArn = Objects.requireNonNull(value, "serviceArn is required");
            return this;
        }

        public Builder withServiceId(String value) {
            this._serviceId = Objects.requireNonNull(value, "serviceId is required");
            return this;
        }

        public Builder withServiceName(String value) {
            this._serviceName = Objects.requireNonNull(value, "serviceName is required");
            return this;
        }

        public ServiceAttributes build() {
            return new ServiceAttributes(){
                private final DnsRecordType $dnsRecordType;
                private final RoutingPolicy $routingPolicy;
                private final String $serviceArn;
                private final String $serviceId;
                private final String $serviceName;
                {
                    this.$dnsRecordType = Objects.requireNonNull(_dnsRecordType, "dnsRecordType is required");
                    this.$routingPolicy = Objects.requireNonNull(_routingPolicy, "routingPolicy is required");
                    this.$serviceArn = Objects.requireNonNull(_serviceArn, "serviceArn is required");
                    this.$serviceId = Objects.requireNonNull(_serviceId, "serviceId is required");
                    this.$serviceName = Objects.requireNonNull(_serviceName, "serviceName is required");
                }

                @Override
                public DnsRecordType getDnsRecordType() {
                    return this.$dnsRecordType;
                }

                @Override
                public RoutingPolicy getRoutingPolicy() {
                    return this.$routingPolicy;
                }

                @Override
                public String getServiceArn() {
                    return this.$serviceArn;
                }

                @Override
                public String getServiceId() {
                    return this.$serviceId;
                }

                @Override
                public String getServiceName() {
                    return this.$serviceName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("dnsRecordType", om.valueToTree((Object)this.getDnsRecordType()));
                    obj.set("routingPolicy", om.valueToTree((Object)this.getRoutingPolicy()));
                    obj.set("serviceArn", om.valueToTree((Object)this.getServiceArn()));
                    obj.set("serviceId", om.valueToTree((Object)this.getServiceId()));
                    obj.set("serviceName", om.valueToTree((Object)this.getServiceName()));
                    return obj;
                }
            };
        }
    }
}

