/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.secretsmanager;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.core.SecretValue;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.secretsmanager.;
import software.amazon.awscdk.services.secretsmanager.AttachedSecretOptions;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget;
import software.amazon.awscdk.services.secretsmanager.RotationSchedule;
import software.amazon.awscdk.services.secretsmanager.RotationScheduleOptions;
import software.amazon.awscdk.services.secretsmanager.SecretAttributes;
import software.amazon.awscdk.services.secretsmanager.SecretProps;
import software.amazon.awscdk.services.secretsmanager.SecretStringGenerator;
import software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-secretsmanager.Secret")
public class Secret
extends Resource
implements ISecret {
    protected Secret(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Secret(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Secret(@NotNull Construct scope, @NotNull String id, @Nullable SecretProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Secret(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static ISecret fromSecretArn(@NotNull Construct scope, @NotNull String id, @NotNull String secretArn) {
        return (ISecret)JsiiObject.jsiiStaticCall(Secret.class, (String)"fromSecretArn", ISecret.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(secretArn, "secretArn is required")});
    }

    @NotNull
    public static ISecret fromSecretAttributes(@NotNull Construct scope, @NotNull String id, @NotNull SecretAttributes attrs) {
        return (ISecret)JsiiObject.jsiiStaticCall(Secret.class, (String)"fromSecretAttributes", ISecret.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public RotationSchedule addRotationSchedule(@NotNull String id, @NotNull RotationScheduleOptions options) {
        return (RotationSchedule)((Object)this.jsiiCall("addRotationSchedule", RotationSchedule.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")}));
    }

    @Deprecated
    @NotNull
    public SecretTargetAttachment addTargetAttachment(@NotNull String id, @NotNull AttachedSecretOptions options) {
        return (SecretTargetAttachment)this.jsiiCall("addTargetAttachment", SecretTargetAttachment.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)this.jsiiCall("addToResourcePolicy", AddToResourcePolicyResult.class, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @NotNull
    public ISecret attach(@NotNull ISecretAttachmentTarget target) {
        return (ISecret)this.jsiiCall("attach", ISecret.class, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @Override
    public void denyAccountRootDelete() {
        this.jsiiCall("denyAccountRootDelete", NativeType.VOID, new Object[0]);
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee, @Nullable List<String> versionStages) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required"), versionStages});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public SecretValue secretValueFromJson(@NotNull String jsonField) {
        return (SecretValue)this.jsiiCall("secretValueFromJson", SecretValue.class, new Object[]{Objects.requireNonNull(jsonField, "jsonField is required")});
    }

    @NotNull
    protected Boolean getAutoCreatePolicy() {
        return (Boolean)this.jsiiGet("autoCreatePolicy", Boolean.class);
    }

    @Override
    @NotNull
    public String getSecretArn() {
        return (String)this.jsiiGet("secretArn", String.class);
    }

    @Override
    @NotNull
    public SecretValue getSecretValue() {
        return (SecretValue)this.jsiiGet("secretValue", SecretValue.class);
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)this.jsiiGet("encryptionKey", IKey.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private SecretProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder generateSecretString(SecretStringGenerator generateSecretString) {
            this.props().generateSecretString(generateSecretString);
            return this;
        }

        public Builder secretName(String secretName) {
            this.props().secretName(secretName);
            return this;
        }

        public Secret build() {
            return new Secret(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private SecretProps.Builder props() {
            if (this.props == null) {
                this.props = new SecretProps.Builder();
            }
            return this.props;
        }
    }
}

