/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.secretsmanager;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface RotationScheduleOptions
extends JsiiSerializable {
    public IFunction getRotationLambda();

    public Duration getAutomaticallyAfter();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IFunction _rotationLambda;
        @Nullable
        private Duration _automaticallyAfter;

        public Builder withRotationLambda(IFunction value) {
            this._rotationLambda = Objects.requireNonNull(value, "rotationLambda is required");
            return this;
        }

        public Builder withAutomaticallyAfter(@Nullable Duration value) {
            this._automaticallyAfter = value;
            return this;
        }

        public RotationScheduleOptions build() {
            return new RotationScheduleOptions(){
                private final IFunction $rotationLambda;
                @Nullable
                private final Duration $automaticallyAfter;
                {
                    this.$rotationLambda = Objects.requireNonNull(_rotationLambda, "rotationLambda is required");
                    this.$automaticallyAfter = _automaticallyAfter;
                }

                @Override
                public IFunction getRotationLambda() {
                    return this.$rotationLambda;
                }

                @Override
                public Duration getAutomaticallyAfter() {
                    return this.$automaticallyAfter;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("rotationLambda", om.valueToTree((Object)this.getRotationLambda()));
                    if (this.getAutomaticallyAfter() != null) {
                        obj.set("automaticallyAfter", om.valueToTree((Object)this.getAutomaticallyAfter()));
                    }
                    return obj;
                }
            };
        }
    }
}

