/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sam.;
import software.amazon.awscdk.services.sam.CfnApplication;
import software.amazon.awscdk.services.sam.CfnApplicationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnApplication")
public class CfnApplication
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplication.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnApplication.class, (String)"REQUIRED_TRANSFORM", String.class);

    protected CfnApplication(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplication(Construct scope, String id, CfnApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public Object getLocation() {
        return this.jsiiGet("location", Object.class);
    }

    public void setLocation(String value) {
        this.jsiiSet("location", Objects.requireNonNull(value, "location is required"));
    }

    public void setLocation(ApplicationLocationProperty value) {
        this.jsiiSet("location", Objects.requireNonNull(value, "location is required"));
    }

    public void setLocation(IResolvable value) {
        this.jsiiSet("location", Objects.requireNonNull(value, "location is required"));
    }

    public List<String> getNotificationArns() {
        return Optional.ofNullable((List)this.jsiiGet("notificationArns", List.class)).map(Collections::unmodifiableList).orElse(null);
    }

    public void setNotificationArns(List<String> value) {
        this.jsiiSet("notificationArns", value);
    }

    public Object getParameters() {
        return this.jsiiGet("parameters", Object.class);
    }

    public void setParameters(IResolvable value) {
        this.jsiiSet("parameters", value);
    }

    public void setParameters(Map<String, String> value) {
        this.jsiiSet("parameters", value);
    }

    public Number getTimeoutInMinutes() {
        return (Number)this.jsiiGet("timeoutInMinutes", Number.class);
    }

    public void setTimeoutInMinutes(Number value) {
        this.jsiiSet("timeoutInMinutes", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationProps.Builder();
        }

        public Builder location(String location) {
            this.props.location(location);
            return this;
        }

        public Builder location(ApplicationLocationProperty location) {
            this.props.location(location);
            return this;
        }

        public Builder location(IResolvable location) {
            this.props.location(location);
            return this;
        }

        public Builder notificationArns(List<String> notificationArns) {
            this.props.notificationArns(notificationArns);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeoutInMinutes(Number timeoutInMinutes) {
            this.props.timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        public CfnApplication build() {
            return new CfnApplication(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnApplication.ApplicationLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationLocationProperty
    extends JsiiSerializable {
        public String getApplicationId();

        public String getSemanticVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String applicationId;
            private String semanticVersion;

            public Builder applicationId(String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            public Builder semanticVersion(String semanticVersion) {
                this.semanticVersion = semanticVersion;
                return this;
            }

            public ApplicationLocationProperty build() {
                return new Jsii.Proxy(this.applicationId, this.semanticVersion, null);
            }
        }
    }
}

