/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sam.$Module;
import software.amazon.awscdk.services.sam.CfnStateMachine;
import software.amazon.awscdk.services.sam.CfnStateMachineProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine")
public class CfnStateMachine
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStateMachine.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnStateMachine.class, (String)"REQUIRED_TRANSFORM", (NativeType)NativeType.forClass(String.class));

    protected CfnStateMachine(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStateMachine(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStateMachine(@NotNull Construct scope, @NotNull String id, @Nullable CfnStateMachineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnStateMachine(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public Object getDefinition() {
        return Kernel.get((Object)((Object)this), (String)"definition", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinition(@NotNull Object value) {
        Kernel.set((Object)((Object)this), (String)"definition", (Object)Objects.requireNonNull(value, "definition is required"));
    }

    @Nullable
    public Object getDefinitionSubstitutions() {
        return Kernel.get((Object)((Object)this), (String)"definitionSubstitutions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinitionSubstitutions(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"definitionSubstitutions", (Object)value);
    }

    public void setDefinitionSubstitutions(@Nullable Map<String, String> value) {
        Kernel.set((Object)((Object)this), (String)"definitionSubstitutions", value);
    }

    @Nullable
    public Object getDefinitionUri() {
        return Kernel.get((Object)((Object)this), (String)"definitionUri", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinitionUri(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"definitionUri", (Object)value);
    }

    public void setDefinitionUri(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"definitionUri", (Object)value);
    }

    public void setDefinitionUri(@Nullable S3LocationProperty value) {
        Kernel.set((Object)((Object)this), (String)"definitionUri", (Object)value);
    }

    @Nullable
    public Object getEvents() {
        return Kernel.get((Object)((Object)this), (String)"events", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEvents(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"events", (Object)value);
    }

    public void setEvents(@Nullable Map<String, Object> value) {
        Kernel.set((Object)((Object)this), (String)"events", value);
    }

    @Nullable
    public Object getLogging() {
        return Kernel.get((Object)((Object)this), (String)"logging", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLogging(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"logging", (Object)value);
    }

    public void setLogging(@Nullable LoggingConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"logging", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)value);
    }

    @Nullable
    public String getPermissionsBoundaries() {
        return (String)Kernel.get((Object)((Object)this), (String)"permissionsBoundaries", (NativeType)NativeType.forClass(String.class));
    }

    public void setPermissionsBoundaries(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"permissionsBoundaries", (Object)value);
    }

    @Nullable
    public Object getPolicies() {
        return Kernel.get((Object)((Object)this), (String)"policies", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPolicies(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"policies", (Object)value);
    }

    public void setPolicies(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"policies", (Object)value);
    }

    public void setPolicies(@Nullable IAMPolicyDocumentProperty value) {
        Kernel.set((Object)((Object)this), (String)"policies", (Object)value);
    }

    public void setPolicies(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"policies", value);
    }

    @Nullable
    public String getRole() {
        return (String)Kernel.get((Object)((Object)this), (String)"role", (NativeType)NativeType.forClass(String.class));
    }

    public void setRole(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"role", (Object)value);
    }

    @Nullable
    public Object getTracing() {
        return Kernel.get((Object)((Object)this), (String)"tracing", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTracing(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"tracing", (Object)value);
    }

    public void setTracing(@Nullable TracingConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"tracing", (Object)value);
    }

    @Nullable
    public String getType() {
        return (String)Kernel.get((Object)((Object)this), (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"type", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnStateMachine> {
        private final Construct scope;
        private final String id;
        private CfnStateMachineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder definition(Object definition) {
            this.props().definition(definition);
            return this;
        }

        public Builder definitionSubstitutions(IResolvable definitionSubstitutions) {
            this.props().definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        public Builder definitionSubstitutions(Map<String, String> definitionSubstitutions) {
            this.props().definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        public Builder definitionUri(String definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }

        public Builder definitionUri(IResolvable definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }

        public Builder definitionUri(S3LocationProperty definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }

        public Builder events(IResolvable events) {
            this.props().events(events);
            return this;
        }

        public Builder events(Map<String, ? extends Object> events) {
            this.props().events(events);
            return this;
        }

        public Builder logging(IResolvable logging) {
            this.props().logging(logging);
            return this;
        }

        public Builder logging(LoggingConfigurationProperty logging) {
            this.props().logging(logging);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder permissionsBoundaries(String permissionsBoundaries) {
            this.props().permissionsBoundaries(permissionsBoundaries);
            return this;
        }

        public Builder policies(String policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder policies(IResolvable policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder policies(IAMPolicyDocumentProperty policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder policies(List<? extends Object> policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder role(String role) {
            this.props().role(role);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder tracing(IResolvable tracing) {
            this.props().tracing(tracing);
            return this;
        }

        public Builder tracing(TracingConfigurationProperty tracing) {
            this.props().tracing(tracing);
            return this;
        }

        public Builder type(String type) {
            this.props().type(type);
            return this;
        }

        public CfnStateMachine build() {
            return new CfnStateMachine(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnStateMachineProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnStateMachineProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.TracingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TracingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TracingConfigurationProperty> {
            private Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public TracingConfigurationProperty build() {
                return new Jsii.Proxy(this.enabled);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.StateMachineSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StateMachineSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getStateMachineName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StateMachineSAMPTProperty> {
            private String stateMachineName;

            public Builder stateMachineName(String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            public StateMachineSAMPTProperty build() {
                return new Jsii.Proxy(this.stateMachineName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.ScheduleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getSchedule();

        @Nullable
        default public String getInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleEventProperty> {
            private String schedule;
            private String input;

            public Builder schedule(String schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public ScheduleEventProperty build() {
                return new Jsii.Proxy(this.schedule, this.input);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.SAMPolicyTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SAMPolicyTemplateProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLambdaInvokePolicy() {
            return null;
        }

        @Nullable
        default public Object getStepFunctionsExecutionPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SAMPolicyTemplateProperty> {
            private Object lambdaInvokePolicy;
            private Object stepFunctionsExecutionPolicy;

            public Builder lambdaInvokePolicy(IResolvable lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            public Builder lambdaInvokePolicy(FunctionSAMPTProperty lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            public Builder stepFunctionsExecutionPolicy(IResolvable stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            public Builder stepFunctionsExecutionPolicy(StateMachineSAMPTProperty stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            public SAMPolicyTemplateProperty build() {
                return new Jsii.Proxy(this.lambdaInvokePolicy, this.stepFunctionsExecutionPolicy);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public Number getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            private String bucket;
            private String key;
            private Number version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, this.version);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDestinations();

        @NotNull
        public Object getIncludeExecutionData();

        @NotNull
        public String getLevel();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            private Object destinations;
            private Object includeExecutionData;
            private String level;

            public Builder destinations(IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            public Builder destinations(List<? extends Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            public Builder includeExecutionData(Boolean includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            public Builder includeExecutionData(IResolvable includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new Jsii.Proxy(this.destinations, this.includeExecutionData, this.level);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.LogDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogDestinationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCloudWatchLogsLogGroup();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogDestinationProperty> {
            private Object cloudWatchLogsLogGroup;

            public Builder cloudWatchLogsLogGroup(IResolvable cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            public Builder cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            public LogDestinationProperty build() {
                return new Jsii.Proxy(this.cloudWatchLogsLogGroup);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.IAMPolicyDocumentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IAMPolicyDocumentProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatement();
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.FunctionSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getFunctionName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunctionSAMPTProperty> {
            private String functionName;

            public Builder functionName(String functionName) {
                this.functionName = functionName;
                return this;
            }

            public FunctionSAMPTProperty build() {
                return new Jsii.Proxy(this.functionName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.EventSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventSourceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getProperties();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventSourceProperty> {
            private Object properties;
            private String type;

            public Builder properties(IResolvable properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(ApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(CloudWatchEventEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(EventBridgeRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(ScheduleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public EventSourceProperty build() {
                return new Jsii.Proxy(this.properties, this.type);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.EventBridgeRuleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventBridgeRuleEventProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPattern();

        @Nullable
        default public String getEventBusName() {
            return null;
        }

        @Nullable
        default public String getInput() {
            return null;
        }

        @Nullable
        default public String getInputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventBridgeRuleEventProperty> {
            private Object pattern;
            private String eventBusName;
            private String input;
            private String inputPath;

            public Builder pattern(Object pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder eventBusName(String eventBusName) {
                this.eventBusName = eventBusName;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder inputPath(String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            public EventBridgeRuleEventProperty build() {
                return new Jsii.Proxy(this.pattern, this.eventBusName, this.input, this.inputPath);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.CloudWatchLogsLogGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsLogGroupProperty
    extends JsiiSerializable {
        @NotNull
        public String getLogGroupArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsLogGroupProperty> {
            private String logGroupArn;

            public Builder logGroupArn(String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            public CloudWatchLogsLogGroupProperty build() {
                return new Jsii.Proxy(this.logGroupArn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.CloudWatchEventEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchEventEventProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPattern();

        @Nullable
        default public String getEventBusName() {
            return null;
        }

        @Nullable
        default public String getInput() {
            return null;
        }

        @Nullable
        default public String getInputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchEventEventProperty> {
            private Object pattern;
            private String eventBusName;
            private String input;
            private String inputPath;

            public Builder pattern(Object pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder eventBusName(String eventBusName) {
                this.eventBusName = eventBusName;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder inputPath(String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            public CloudWatchEventEventProperty build() {
                return new Jsii.Proxy(this.pattern, this.eventBusName, this.input, this.inputPath);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnStateMachine.ApiEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApiEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getMethod();

        @NotNull
        public String getPath();

        @Nullable
        default public String getRestApiId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApiEventProperty> {
            private String method;
            private String path;
            private String restApiId;

            public Builder method(String method) {
                this.method = method;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder restApiId(String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            public ApiEventProperty build() {
                return new Jsii.Proxy(this.method, this.path, this.restApiId);
            }
        }
    }
}

