/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sagemaker.;
import software.amazon.awscdk.services.sagemaker.CfnEndpointConfig;
import software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnEndpointConfig")
public class CfnEndpointConfig
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEndpointConfig.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnEndpointConfig(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpointConfig(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEndpointConfig(@NotNull Construct scope, @NotNull String id, @NotNull CfnEndpointConfigProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrEndpointConfigName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrEndpointConfigName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public Object getProductionVariants() {
        return Kernel.get((Object)((Object)this), (String)"productionVariants", (NativeType)NativeType.forClass(Object.class));
    }

    public void setProductionVariants(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"productionVariants", (Object)Objects.requireNonNull(value, "productionVariants is required"));
    }

    public void setProductionVariants(@NotNull List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"productionVariants", Objects.requireNonNull(value, "productionVariants is required"));
    }

    @Nullable
    public Object getDataCaptureConfig() {
        return Kernel.get((Object)((Object)this), (String)"dataCaptureConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataCaptureConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"dataCaptureConfig", (Object)value);
    }

    public void setDataCaptureConfig(@Nullable DataCaptureConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"dataCaptureConfig", (Object)value);
    }

    @Nullable
    public String getEndpointConfigName() {
        return (String)Kernel.get((Object)((Object)this), (String)"endpointConfigName", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpointConfigName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"endpointConfigName", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)((Object)this), (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"kmsKeyId", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEndpointConfig> {
        private final Construct scope;
        private final String id;
        private final CfnEndpointConfigProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEndpointConfigProps.Builder();
        }

        public Builder productionVariants(IResolvable productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }

        public Builder productionVariants(List<? extends Object> productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }

        public Builder dataCaptureConfig(IResolvable dataCaptureConfig) {
            this.props.dataCaptureConfig(dataCaptureConfig);
            return this;
        }

        public Builder dataCaptureConfig(DataCaptureConfigProperty dataCaptureConfig) {
            this.props.dataCaptureConfig(dataCaptureConfig);
            return this;
        }

        public Builder endpointConfigName(String endpointConfigName) {
            this.props.endpointConfigName(endpointConfigName);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnEndpointConfig build() {
            return new CfnEndpointConfig(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnEndpointConfig.ProductionVariantProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProductionVariantProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInitialInstanceCount();

        @NotNull
        public Number getInitialVariantWeight();

        @NotNull
        public String getInstanceType();

        @NotNull
        public String getModelName();

        @NotNull
        public String getVariantName();

        @Nullable
        default public String getAcceleratorType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProductionVariantProperty> {
            private Number initialInstanceCount;
            private Number initialVariantWeight;
            private String instanceType;
            private String modelName;
            private String variantName;
            private String acceleratorType;

            public Builder initialInstanceCount(Number initialInstanceCount) {
                this.initialInstanceCount = initialInstanceCount;
                return this;
            }

            public Builder initialVariantWeight(Number initialVariantWeight) {
                this.initialVariantWeight = initialVariantWeight;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder modelName(String modelName) {
                this.modelName = modelName;
                return this;
            }

            public Builder variantName(String variantName) {
                this.variantName = variantName;
                return this;
            }

            public Builder acceleratorType(String acceleratorType) {
                this.acceleratorType = acceleratorType;
                return this;
            }

            public ProductionVariantProperty build() {
                return new Jsii.Proxy(this.initialInstanceCount, this.initialVariantWeight, this.instanceType, this.modelName, this.variantName, this.acceleratorType);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnEndpointConfig.DataCaptureConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataCaptureConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCaptureOptions();

        @NotNull
        public String getDestinationS3Uri();

        @NotNull
        public Number getInitialSamplingPercentage();

        @Nullable
        default public Object getCaptureContentTypeHeader() {
            return null;
        }

        @Nullable
        default public Object getEnableCapture() {
            return null;
        }

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataCaptureConfigProperty> {
            private Object captureOptions;
            private String destinationS3Uri;
            private Number initialSamplingPercentage;
            private Object captureContentTypeHeader;
            private Object enableCapture;
            private String kmsKeyId;

            public Builder captureOptions(IResolvable captureOptions) {
                this.captureOptions = captureOptions;
                return this;
            }

            public Builder captureOptions(List<? extends Object> captureOptions) {
                this.captureOptions = captureOptions;
                return this;
            }

            public Builder destinationS3Uri(String destinationS3Uri) {
                this.destinationS3Uri = destinationS3Uri;
                return this;
            }

            public Builder initialSamplingPercentage(Number initialSamplingPercentage) {
                this.initialSamplingPercentage = initialSamplingPercentage;
                return this;
            }

            public Builder captureContentTypeHeader(IResolvable captureContentTypeHeader) {
                this.captureContentTypeHeader = captureContentTypeHeader;
                return this;
            }

            public Builder captureContentTypeHeader(CaptureContentTypeHeaderProperty captureContentTypeHeader) {
                this.captureContentTypeHeader = captureContentTypeHeader;
                return this;
            }

            public Builder enableCapture(Boolean enableCapture) {
                this.enableCapture = enableCapture;
                return this;
            }

            public Builder enableCapture(IResolvable enableCapture) {
                this.enableCapture = enableCapture;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public DataCaptureConfigProperty build() {
                return new Jsii.Proxy(this.captureOptions, this.destinationS3Uri, this.initialSamplingPercentage, this.captureContentTypeHeader, this.enableCapture, this.kmsKeyId);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptureOptionProperty
    extends JsiiSerializable {
        @NotNull
        public String getCaptureMode();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptureOptionProperty> {
            private String captureMode;

            public Builder captureMode(String captureMode) {
                this.captureMode = captureMode;
                return this;
            }

            public CaptureOptionProperty build() {
                return new Jsii.Proxy(this.captureMode);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptureContentTypeHeaderProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCsvContentTypes() {
            return null;
        }

        @Nullable
        default public List<String> getJsonContentTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptureContentTypeHeaderProperty> {
            private List<String> csvContentTypes;
            private List<String> jsonContentTypes;

            public Builder csvContentTypes(List<String> csvContentTypes) {
                this.csvContentTypes = csvContentTypes;
                return this;
            }

            public Builder jsonContentTypes(List<String> jsonContentTypes) {
                this.jsonContentTypes = jsonContentTypes;
                return this;
            }

            public CaptureContentTypeHeaderProperty build() {
                return new Jsii.Proxy(this.csvContentTypes, this.jsonContentTypes);
            }
        }
    }
}

