/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.services.sagemaker.CfnModel;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnModelProps
extends JsiiSerializable {
    public String getExecutionRoleArn();

    public Object getContainers();

    public String getModelName();

    public Object getPrimaryContainer();

    public List<CfnTag> getTags();

    public Object getVpcConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _executionRoleArn;
        @Nullable
        private Object _containers;
        @Nullable
        private String _modelName;
        @Nullable
        private Object _primaryContainer;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private Object _vpcConfig;

        public Builder withExecutionRoleArn(String value) {
            this._executionRoleArn = Objects.requireNonNull(value, "executionRoleArn is required");
            return this;
        }

        public Builder withContainers(@Nullable IResolvable value) {
            this._containers = value;
            return this;
        }

        public Builder withContainers(@Nullable List<Object> value) {
            this._containers = value;
            return this;
        }

        public Builder withModelName(@Nullable String value) {
            this._modelName = value;
            return this;
        }

        public Builder withPrimaryContainer(@Nullable IResolvable value) {
            this._primaryContainer = value;
            return this;
        }

        public Builder withPrimaryContainer(@Nullable CfnModel.ContainerDefinitionProperty value) {
            this._primaryContainer = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withVpcConfig(@Nullable IResolvable value) {
            this._vpcConfig = value;
            return this;
        }

        public Builder withVpcConfig(@Nullable CfnModel.VpcConfigProperty value) {
            this._vpcConfig = value;
            return this;
        }

        public CfnModelProps build() {
            return new CfnModelProps(){
                private final String $executionRoleArn;
                @Nullable
                private final Object $containers;
                @Nullable
                private final String $modelName;
                @Nullable
                private final Object $primaryContainer;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final Object $vpcConfig;
                {
                    this.$executionRoleArn = Objects.requireNonNull(_executionRoleArn, "executionRoleArn is required");
                    this.$containers = _containers;
                    this.$modelName = _modelName;
                    this.$primaryContainer = _primaryContainer;
                    this.$tags = _tags;
                    this.$vpcConfig = _vpcConfig;
                }

                @Override
                public String getExecutionRoleArn() {
                    return this.$executionRoleArn;
                }

                @Override
                public Object getContainers() {
                    return this.$containers;
                }

                @Override
                public String getModelName() {
                    return this.$modelName;
                }

                @Override
                public Object getPrimaryContainer() {
                    return this.$primaryContainer;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public Object getVpcConfig() {
                    return this.$vpcConfig;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("executionRoleArn", om.valueToTree((Object)this.getExecutionRoleArn()));
                    if (this.getContainers() != null) {
                        obj.set("containers", om.valueToTree(this.getContainers()));
                    }
                    if (this.getModelName() != null) {
                        obj.set("modelName", om.valueToTree((Object)this.getModelName()));
                    }
                    if (this.getPrimaryContainer() != null) {
                        obj.set("primaryContainer", om.valueToTree(this.getPrimaryContainer()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getVpcConfig() != null) {
                        obj.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
                    }
                    return obj;
                }
            };
        }
    }
}

