/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.List;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.$Module;
import software.amazon.awscdk.services.s3.BlockPublicAccess;
import software.amazon.awscdk.services.s3.BucketAccessControl;
import software.amazon.awscdk.services.s3.BucketEncryption;
import software.amazon.awscdk.services.s3.BucketMetrics;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.CorsRule;
import software.amazon.awscdk.services.s3.LifecycleRule;
import software.amazon.awscdk.services.s3.RedirectTarget;
import software.amazon.awscdk.services.s3.RoutingRule;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-s3.BucketProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface BucketProps
extends JsiiSerializable {
    default public BucketAccessControl getAccessControl() {
        return null;
    }

    default public BlockPublicAccess getBlockPublicAccess() {
        return null;
    }

    default public String getBucketName() {
        return null;
    }

    default public List<CorsRule> getCors() {
        return null;
    }

    default public BucketEncryption getEncryption() {
        return null;
    }

    default public IKey getEncryptionKey() {
        return null;
    }

    default public List<LifecycleRule> getLifecycleRules() {
        return null;
    }

    default public List<BucketMetrics> getMetrics() {
        return null;
    }

    default public Boolean getPublicReadAccess() {
        return null;
    }

    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    default public Boolean getVersioned() {
        return null;
    }

    default public String getWebsiteErrorDocument() {
        return null;
    }

    default public String getWebsiteIndexDocument() {
        return null;
    }

    default public RedirectTarget getWebsiteRedirect() {
        return null;
    }

    default public List<RoutingRule> getWebsiteRoutingRules() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BucketAccessControl accessControl;
        private BlockPublicAccess blockPublicAccess;
        private String bucketName;
        private List<CorsRule> cors;
        private BucketEncryption encryption;
        private IKey encryptionKey;
        private List<LifecycleRule> lifecycleRules;
        private List<BucketMetrics> metrics;
        private Boolean publicReadAccess;
        private RemovalPolicy removalPolicy;
        private Boolean versioned;
        private String websiteErrorDocument;
        private String websiteIndexDocument;
        private RedirectTarget websiteRedirect;
        private List<RoutingRule> websiteRoutingRules;

        public Builder accessControl(BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        public Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder cors(List<CorsRule> cors) {
            this.cors = cors;
            return this;
        }

        public Builder encryption(BucketEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder lifecycleRules(List<LifecycleRule> lifecycleRules) {
            this.lifecycleRules = lifecycleRules;
            return this;
        }

        public Builder metrics(List<BucketMetrics> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder publicReadAccess(Boolean publicReadAccess) {
            this.publicReadAccess = publicReadAccess;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder versioned(Boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        public Builder websiteErrorDocument(String websiteErrorDocument) {
            this.websiteErrorDocument = websiteErrorDocument;
            return this;
        }

        public Builder websiteIndexDocument(String websiteIndexDocument) {
            this.websiteIndexDocument = websiteIndexDocument;
            return this;
        }

        public Builder websiteRedirect(RedirectTarget websiteRedirect) {
            this.websiteRedirect = websiteRedirect;
            return this;
        }

        public Builder websiteRoutingRules(List<RoutingRule> websiteRoutingRules) {
            this.websiteRoutingRules = websiteRoutingRules;
            return this;
        }

        public BucketProps build() {
            return new Jsii.Proxy(this.accessControl, this.blockPublicAccess, this.bucketName, this.cors, this.encryption, this.encryptionKey, this.lifecycleRules, this.metrics, this.publicReadAccess, this.removalPolicy, this.versioned, this.websiteErrorDocument, this.websiteIndexDocument, this.websiteRedirect, this.websiteRoutingRules, null);
        }
    }
}

