/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.cloudformation;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.CloudFormationToken;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.BucketArn;
import software.amazon.awscdk.services.s3.BucketDomainName;
import software.amazon.awscdk.services.s3.BucketDualStackDomainName;
import software.amazon.awscdk.services.s3.BucketName;
import software.amazon.awscdk.services.s3.BucketWebsiteUrl;
import software.amazon.awscdk.services.s3.cloudformation.BucketResourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.cloudformation.BucketResource")
public class BucketResource
extends Resource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(BucketResource.class, (String)"resourceTypeName", String.class);

    protected BucketResource(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public BucketResource(Construct parent, String name, @Nullable BucketResourceProps properties) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))), Stream.of(properties)).toArray());
    }

    public BucketResource(Construct parent, String name) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))).toArray());
    }

    protected Map<String, Object> renderProperties() {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[0]);
    }

    public BucketArn getBucketArn() {
        return (BucketArn)((Object)this.jsiiGet("bucketArn", BucketArn.class));
    }

    public BucketDomainName getBucketDomainName() {
        return (BucketDomainName)((Object)this.jsiiGet("bucketDomainName", BucketDomainName.class));
    }

    public BucketDualStackDomainName getBucketDualStackDomainName() {
        return (BucketDualStackDomainName)((Object)this.jsiiGet("bucketDualStackDomainName", BucketDualStackDomainName.class));
    }

    public BucketWebsiteUrl getBucketWebsiteUrl() {
        return (BucketWebsiteUrl)((Object)this.jsiiGet("bucketWebsiteUrl", BucketWebsiteUrl.class));
    }

    public BucketName getRef() {
        return (BucketName)((Object)this.jsiiGet("ref", BucketName.class));
    }

    public static interface WebsiteConfigurationProperty
    extends JsiiSerializable {
        public Object getErrorDocument();

        public void setErrorDocument(String var1);

        public void setErrorDocument(CloudFormationToken var1);

        public Object getIndexDocument();

        public void setIndexDocument(String var1);

        public void setIndexDocument(CloudFormationToken var1);

        public Object getRedirectAllRequestsTo();

        public void setRedirectAllRequestsTo(CloudFormationToken var1);

        public void setRedirectAllRequestsTo(RedirectAllRequestsToProperty var1);

        public Object getRoutingRules();

        public void setRoutingRules(CloudFormationToken var1);

        public void setRoutingRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _errorDocument;
            @Nullable
            private Object _indexDocument;
            @Nullable
            private Object _redirectAllRequestsTo;
            @Nullable
            private Object _routingRules;

            public Builder withErrorDocument(@Nullable String value) {
                this._errorDocument = value;
                return this;
            }

            public Builder withErrorDocument(@Nullable CloudFormationToken value) {
                this._errorDocument = value;
                return this;
            }

            public Builder withIndexDocument(@Nullable String value) {
                this._indexDocument = value;
                return this;
            }

            public Builder withIndexDocument(@Nullable CloudFormationToken value) {
                this._indexDocument = value;
                return this;
            }

            public Builder withRedirectAllRequestsTo(@Nullable CloudFormationToken value) {
                this._redirectAllRequestsTo = value;
                return this;
            }

            public Builder withRedirectAllRequestsTo(@Nullable RedirectAllRequestsToProperty value) {
                this._redirectAllRequestsTo = value;
                return this;
            }

            public Builder withRoutingRules(@Nullable CloudFormationToken value) {
                this._routingRules = value;
                return this;
            }

            public Builder withRoutingRules(@Nullable List<Object> value) {
                this._routingRules = value;
                return this;
            }

            public WebsiteConfigurationProperty build() {
                return new WebsiteConfigurationProperty(){
                    @Nullable
                    private Object $errorDocument;
                    @Nullable
                    private Object $indexDocument;
                    @Nullable
                    private Object $redirectAllRequestsTo;
                    @Nullable
                    private Object $routingRules;
                    {
                        this.$errorDocument = _errorDocument;
                        this.$indexDocument = _indexDocument;
                        this.$redirectAllRequestsTo = _redirectAllRequestsTo;
                        this.$routingRules = _routingRules;
                    }

                    @Override
                    public Object getErrorDocument() {
                        return this.$errorDocument;
                    }

                    @Override
                    public void setErrorDocument(@Nullable String value) {
                        this.$errorDocument = value;
                    }

                    @Override
                    public void setErrorDocument(@Nullable CloudFormationToken value) {
                        this.$errorDocument = value;
                    }

                    @Override
                    public Object getIndexDocument() {
                        return this.$indexDocument;
                    }

                    @Override
                    public void setIndexDocument(@Nullable String value) {
                        this.$indexDocument = value;
                    }

                    @Override
                    public void setIndexDocument(@Nullable CloudFormationToken value) {
                        this.$indexDocument = value;
                    }

                    @Override
                    public Object getRedirectAllRequestsTo() {
                        return this.$redirectAllRequestsTo;
                    }

                    @Override
                    public void setRedirectAllRequestsTo(@Nullable CloudFormationToken value) {
                        this.$redirectAllRequestsTo = value;
                    }

                    @Override
                    public void setRedirectAllRequestsTo(@Nullable RedirectAllRequestsToProperty value) {
                        this.$redirectAllRequestsTo = value;
                    }

                    @Override
                    public Object getRoutingRules() {
                        return this.$routingRules;
                    }

                    @Override
                    public void setRoutingRules(@Nullable CloudFormationToken value) {
                        this.$routingRules = value;
                    }

                    @Override
                    public void setRoutingRules(@Nullable List<Object> value) {
                        this.$routingRules = value;
                    }
                };
            }
        }
    }

    public static interface VersioningConfigurationProperty
    extends JsiiSerializable {
        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _status;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withStatus(CloudFormationToken value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public VersioningConfigurationProperty build() {
                return new VersioningConfigurationProperty(){
                    private Object $status;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                    }

                    @Override
                    public Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(CloudFormationToken value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }
                };
            }
        }
    }

    public static interface TransitionProperty
    extends JsiiSerializable {
        public Object getStorageClass();

        public void setStorageClass(String var1);

        public void setStorageClass(CloudFormationToken var1);

        public Object getTransitionDate();

        public void setTransitionDate(Instant var1);

        public void setTransitionDate(CloudFormationToken var1);

        public Object getTransitionInDays();

        public void setTransitionInDays(Number var1);

        public void setTransitionInDays(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _storageClass;
            @Nullable
            private Object _transitionDate;
            @Nullable
            private Object _transitionInDays;

            public Builder withStorageClass(String value) {
                this._storageClass = Objects.requireNonNull(value, "storageClass is required");
                return this;
            }

            public Builder withStorageClass(CloudFormationToken value) {
                this._storageClass = Objects.requireNonNull(value, "storageClass is required");
                return this;
            }

            public Builder withTransitionDate(@Nullable Instant value) {
                this._transitionDate = value;
                return this;
            }

            public Builder withTransitionDate(@Nullable CloudFormationToken value) {
                this._transitionDate = value;
                return this;
            }

            public Builder withTransitionInDays(@Nullable Number value) {
                this._transitionInDays = value;
                return this;
            }

            public Builder withTransitionInDays(@Nullable CloudFormationToken value) {
                this._transitionInDays = value;
                return this;
            }

            public TransitionProperty build() {
                return new TransitionProperty(){
                    private Object $storageClass;
                    @Nullable
                    private Object $transitionDate;
                    @Nullable
                    private Object $transitionInDays;
                    {
                        this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                        this.$transitionDate = _transitionDate;
                        this.$transitionInDays = _transitionInDays;
                    }

                    @Override
                    public Object getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(String value) {
                        this.$storageClass = Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public void setStorageClass(CloudFormationToken value) {
                        this.$storageClass = Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public Object getTransitionDate() {
                        return this.$transitionDate;
                    }

                    @Override
                    public void setTransitionDate(@Nullable Instant value) {
                        this.$transitionDate = value;
                    }

                    @Override
                    public void setTransitionDate(@Nullable CloudFormationToken value) {
                        this.$transitionDate = value;
                    }

                    @Override
                    public Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    @Override
                    public void setTransitionInDays(@Nullable Number value) {
                        this.$transitionInDays = value;
                    }

                    @Override
                    public void setTransitionInDays(@Nullable CloudFormationToken value) {
                        this.$transitionInDays = value;
                    }
                };
            }
        }
    }

    public static interface TopicConfigurationProperty
    extends JsiiSerializable {
        public Object getEvent();

        public void setEvent(String var1);

        public void setEvent(CloudFormationToken var1);

        public Object getTopic();

        public void setTopic(String var1);

        public void setTopic(CloudFormationToken var1);

        public Object getFilter();

        public void setFilter(CloudFormationToken var1);

        public void setFilter(NotificationFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _event;
            private Object _topic;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withEvent(CloudFormationToken value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withTopic(String value) {
                this._topic = Objects.requireNonNull(value, "topic is required");
                return this;
            }

            public Builder withTopic(CloudFormationToken value) {
                this._topic = Objects.requireNonNull(value, "topic is required");
                return this;
            }

            public Builder withFilter(@Nullable CloudFormationToken value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public TopicConfigurationProperty build() {
                return new TopicConfigurationProperty(){
                    private Object $event;
                    private Object $topic;
                    @Nullable
                    private Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$topic = Objects.requireNonNull(_topic, "topic is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public Object getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(String value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public void setEvent(CloudFormationToken value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public Object getTopic() {
                        return this.$topic;
                    }

                    @Override
                    public void setTopic(String value) {
                        this.$topic = Objects.requireNonNull(value, "topic is required");
                    }

                    @Override
                    public void setTopic(CloudFormationToken value) {
                        this.$topic = Objects.requireNonNull(value, "topic is required");
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@Nullable CloudFormationToken value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@Nullable NotificationFilterProperty value) {
                        this.$filter = value;
                    }
                };
            }
        }
    }

    public static interface TagFilterProperty
    extends JsiiSerializable {
        public Object getKey();

        public void setKey(String var1);

        public void setKey(CloudFormationToken var1);

        public Object getValue();

        public void setValue(String var1);

        public void setValue(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _key;
            private Object _value;

            public Builder withKey(String value) {
                this._key = Objects.requireNonNull(value, "key is required");
                return this;
            }

            public Builder withKey(CloudFormationToken value) {
                this._key = Objects.requireNonNull(value, "key is required");
                return this;
            }

            public Builder withValue(String value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public Builder withValue(CloudFormationToken value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public TagFilterProperty build() {
                return new TagFilterProperty(){
                    private Object $key;
                    private Object $value;
                    {
                        this.$key = Objects.requireNonNull(_key, "key is required");
                        this.$value = Objects.requireNonNull(_value, "value is required");
                    }

                    @Override
                    public Object getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(String value) {
                        this.$key = Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public void setKey(CloudFormationToken value) {
                        this.$key = Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(String value) {
                        this.$value = Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public void setValue(CloudFormationToken value) {
                        this.$value = Objects.requireNonNull(value, "value is required");
                    }
                };
            }
        }
    }

    public static interface StorageClassAnalysisProperty
    extends JsiiSerializable {
        public Object getDataExport();

        public void setDataExport(CloudFormationToken var1);

        public void setDataExport(DataExportProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _dataExport;

            public Builder withDataExport(@Nullable CloudFormationToken value) {
                this._dataExport = value;
                return this;
            }

            public Builder withDataExport(@Nullable DataExportProperty value) {
                this._dataExport = value;
                return this;
            }

            public StorageClassAnalysisProperty build() {
                return new StorageClassAnalysisProperty(){
                    @Nullable
                    private Object $dataExport;
                    {
                        this.$dataExport = _dataExport;
                    }

                    @Override
                    public Object getDataExport() {
                        return this.$dataExport;
                    }

                    @Override
                    public void setDataExport(@Nullable CloudFormationToken value) {
                        this.$dataExport = value;
                    }

                    @Override
                    public void setDataExport(@Nullable DataExportProperty value) {
                        this.$dataExport = value;
                    }
                };
            }
        }
    }

    public static interface SseKmsEncryptedObjectsProperty
    extends JsiiSerializable {
        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _status;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withStatus(CloudFormationToken value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public SseKmsEncryptedObjectsProperty build() {
                return new SseKmsEncryptedObjectsProperty(){
                    private Object $status;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                    }

                    @Override
                    public Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(CloudFormationToken value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }
                };
            }
        }
    }

    public static interface SourceSelectionCriteriaProperty
    extends JsiiSerializable {
        public Object getSseKmsEncryptedObjects();

        public void setSseKmsEncryptedObjects(CloudFormationToken var1);

        public void setSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _sseKmsEncryptedObjects;

            public Builder withSseKmsEncryptedObjects(CloudFormationToken value) {
                this._sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            public Builder withSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty value) {
                this._sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            public SourceSelectionCriteriaProperty build() {
                return new SourceSelectionCriteriaProperty(){
                    private Object $sseKmsEncryptedObjects;
                    {
                        this.$sseKmsEncryptedObjects = Objects.requireNonNull(_sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");
                    }

                    @Override
                    public Object getSseKmsEncryptedObjects() {
                        return this.$sseKmsEncryptedObjects;
                    }

                    @Override
                    public void setSseKmsEncryptedObjects(CloudFormationToken value) {
                        this.$sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                    }

                    @Override
                    public void setSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty value) {
                        this.$sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                    }
                };
            }
        }
    }

    public static interface ServerSideEncryptionRuleProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionByDefault();

        public void setServerSideEncryptionByDefault(CloudFormationToken var1);

        public void setServerSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _serverSideEncryptionByDefault;

            public Builder withServerSideEncryptionByDefault(@Nullable CloudFormationToken value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            public Builder withServerSideEncryptionByDefault(@Nullable ServerSideEncryptionByDefaultProperty value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            public ServerSideEncryptionRuleProperty build() {
                return new ServerSideEncryptionRuleProperty(){
                    @Nullable
                    private Object $serverSideEncryptionByDefault;
                    {
                        this.$serverSideEncryptionByDefault = _serverSideEncryptionByDefault;
                    }

                    @Override
                    public Object getServerSideEncryptionByDefault() {
                        return this.$serverSideEncryptionByDefault;
                    }

                    @Override
                    public void setServerSideEncryptionByDefault(@Nullable CloudFormationToken value) {
                        this.$serverSideEncryptionByDefault = value;
                    }

                    @Override
                    public void setServerSideEncryptionByDefault(@Nullable ServerSideEncryptionByDefaultProperty value) {
                        this.$serverSideEncryptionByDefault = value;
                    }
                };
            }
        }
    }

    public static interface ServerSideEncryptionByDefaultProperty
    extends JsiiSerializable {
        public Object getSseAlgorithm();

        public void setSseAlgorithm(String var1);

        public void setSseAlgorithm(CloudFormationToken var1);

        public Object getKmsMasterKeyId();

        public void setKmsMasterKeyId(String var1);

        public void setKmsMasterKeyId(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _sseAlgorithm;
            @Nullable
            private Object _kmsMasterKeyId;

            public Builder withSseAlgorithm(String value) {
                this._sseAlgorithm = Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }

            public Builder withSseAlgorithm(CloudFormationToken value) {
                this._sseAlgorithm = Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }

            public Builder withKmsMasterKeyId(@Nullable String value) {
                this._kmsMasterKeyId = value;
                return this;
            }

            public Builder withKmsMasterKeyId(@Nullable CloudFormationToken value) {
                this._kmsMasterKeyId = value;
                return this;
            }

            public ServerSideEncryptionByDefaultProperty build() {
                return new ServerSideEncryptionByDefaultProperty(){
                    private Object $sseAlgorithm;
                    @Nullable
                    private Object $kmsMasterKeyId;
                    {
                        this.$sseAlgorithm = Objects.requireNonNull(_sseAlgorithm, "sseAlgorithm is required");
                        this.$kmsMasterKeyId = _kmsMasterKeyId;
                    }

                    @Override
                    public Object getSseAlgorithm() {
                        return this.$sseAlgorithm;
                    }

                    @Override
                    public void setSseAlgorithm(String value) {
                        this.$sseAlgorithm = Objects.requireNonNull(value, "sseAlgorithm is required");
                    }

                    @Override
                    public void setSseAlgorithm(CloudFormationToken value) {
                        this.$sseAlgorithm = Objects.requireNonNull(value, "sseAlgorithm is required");
                    }

                    @Override
                    public Object getKmsMasterKeyId() {
                        return this.$kmsMasterKeyId;
                    }

                    @Override
                    public void setKmsMasterKeyId(@Nullable String value) {
                        this.$kmsMasterKeyId = value;
                    }

                    @Override
                    public void setKmsMasterKeyId(@Nullable CloudFormationToken value) {
                        this.$kmsMasterKeyId = value;
                    }
                };
            }
        }
    }

    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        public Object getRules();

        public void setRules(CloudFormationToken var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _rules;

            public Builder withRules(CloudFormationToken value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public S3KeyFilterProperty build() {
                return new S3KeyFilterProperty(){
                    private Object $rules;
                    {
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(CloudFormationToken value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(List<Object> value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }
                };
            }
        }
    }

    public static interface RuleProperty
    extends JsiiSerializable {
        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(CloudFormationToken var1);

        public Object getAbortIncompleteMultipartUpload();

        public void setAbortIncompleteMultipartUpload(CloudFormationToken var1);

        public void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty var1);

        public Object getExpirationDate();

        public void setExpirationDate(Instant var1);

        public void setExpirationDate(CloudFormationToken var1);

        public Object getExpirationInDays();

        public void setExpirationInDays(Number var1);

        public void setExpirationInDays(CloudFormationToken var1);

        public Object getId();

        public void setId(String var1);

        public void setId(CloudFormationToken var1);

        public Object getNoncurrentVersionExpirationInDays();

        public void setNoncurrentVersionExpirationInDays(Number var1);

        public void setNoncurrentVersionExpirationInDays(CloudFormationToken var1);

        public Object getNoncurrentVersionTransition();

        public void setNoncurrentVersionTransition(CloudFormationToken var1);

        public void setNoncurrentVersionTransition(NoncurrentVersionTransitionProperty var1);

        public Object getNoncurrentVersionTransitions();

        public void setNoncurrentVersionTransitions(CloudFormationToken var1);

        public void setNoncurrentVersionTransitions(List<Object> var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(CloudFormationToken var1);

        public Object getTagFilters();

        public void setTagFilters(CloudFormationToken var1);

        public void setTagFilters(List<Object> var1);

        public Object getTransition();

        public void setTransition(CloudFormationToken var1);

        public void setTransition(TransitionProperty var1);

        public Object getTransitions();

        public void setTransitions(CloudFormationToken var1);

        public void setTransitions(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _status;
            @Nullable
            private Object _abortIncompleteMultipartUpload;
            @Nullable
            private Object _expirationDate;
            @Nullable
            private Object _expirationInDays;
            @Nullable
            private Object _id;
            @Nullable
            private Object _noncurrentVersionExpirationInDays;
            @Nullable
            private Object _noncurrentVersionTransition;
            @Nullable
            private Object _noncurrentVersionTransitions;
            @Nullable
            private Object _prefix;
            @Nullable
            private Object _tagFilters;
            @Nullable
            private Object _transition;
            @Nullable
            private Object _transitions;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withStatus(CloudFormationToken value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withAbortIncompleteMultipartUpload(@Nullable CloudFormationToken value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }

            public Builder withAbortIncompleteMultipartUpload(@Nullable AbortIncompleteMultipartUploadProperty value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }

            public Builder withExpirationDate(@Nullable Instant value) {
                this._expirationDate = value;
                return this;
            }

            public Builder withExpirationDate(@Nullable CloudFormationToken value) {
                this._expirationDate = value;
                return this;
            }

            public Builder withExpirationInDays(@Nullable Number value) {
                this._expirationInDays = value;
                return this;
            }

            public Builder withExpirationInDays(@Nullable CloudFormationToken value) {
                this._expirationInDays = value;
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withId(@Nullable CloudFormationToken value) {
                this._id = value;
                return this;
            }

            public Builder withNoncurrentVersionExpirationInDays(@Nullable Number value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }

            public Builder withNoncurrentVersionExpirationInDays(@Nullable CloudFormationToken value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }

            public Builder withNoncurrentVersionTransition(@Nullable CloudFormationToken value) {
                this._noncurrentVersionTransition = value;
                return this;
            }

            public Builder withNoncurrentVersionTransition(@Nullable NoncurrentVersionTransitionProperty value) {
                this._noncurrentVersionTransition = value;
                return this;
            }

            public Builder withNoncurrentVersionTransitions(@Nullable CloudFormationToken value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }

            public Builder withNoncurrentVersionTransitions(@Nullable List<Object> value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withPrefix(@Nullable CloudFormationToken value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable CloudFormationToken value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTransition(@Nullable CloudFormationToken value) {
                this._transition = value;
                return this;
            }

            public Builder withTransition(@Nullable TransitionProperty value) {
                this._transition = value;
                return this;
            }

            public Builder withTransitions(@Nullable CloudFormationToken value) {
                this._transitions = value;
                return this;
            }

            public Builder withTransitions(@Nullable List<Object> value) {
                this._transitions = value;
                return this;
            }

            public RuleProperty build() {
                return new RuleProperty(){
                    private Object $status;
                    @Nullable
                    private Object $abortIncompleteMultipartUpload;
                    @Nullable
                    private Object $expirationDate;
                    @Nullable
                    private Object $expirationInDays;
                    @Nullable
                    private Object $id;
                    @Nullable
                    private Object $noncurrentVersionExpirationInDays;
                    @Nullable
                    private Object $noncurrentVersionTransition;
                    @Nullable
                    private Object $noncurrentVersionTransitions;
                    @Nullable
                    private Object $prefix;
                    @Nullable
                    private Object $tagFilters;
                    @Nullable
                    private Object $transition;
                    @Nullable
                    private Object $transitions;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                        this.$abortIncompleteMultipartUpload = _abortIncompleteMultipartUpload;
                        this.$expirationDate = _expirationDate;
                        this.$expirationInDays = _expirationInDays;
                        this.$id = _id;
                        this.$noncurrentVersionExpirationInDays = _noncurrentVersionExpirationInDays;
                        this.$noncurrentVersionTransition = _noncurrentVersionTransition;
                        this.$noncurrentVersionTransitions = _noncurrentVersionTransitions;
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                        this.$transition = _transition;
                        this.$transitions = _transitions;
                    }

                    @Override
                    public Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(CloudFormationToken value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public Object getAbortIncompleteMultipartUpload() {
                        return this.$abortIncompleteMultipartUpload;
                    }

                    @Override
                    public void setAbortIncompleteMultipartUpload(@Nullable CloudFormationToken value) {
                        this.$abortIncompleteMultipartUpload = value;
                    }

                    @Override
                    public void setAbortIncompleteMultipartUpload(@Nullable AbortIncompleteMultipartUploadProperty value) {
                        this.$abortIncompleteMultipartUpload = value;
                    }

                    @Override
                    public Object getExpirationDate() {
                        return this.$expirationDate;
                    }

                    @Override
                    public void setExpirationDate(@Nullable Instant value) {
                        this.$expirationDate = value;
                    }

                    @Override
                    public void setExpirationDate(@Nullable CloudFormationToken value) {
                        this.$expirationDate = value;
                    }

                    @Override
                    public Object getExpirationInDays() {
                        return this.$expirationInDays;
                    }

                    @Override
                    public void setExpirationInDays(@Nullable Number value) {
                        this.$expirationInDays = value;
                    }

                    @Override
                    public void setExpirationInDays(@Nullable CloudFormationToken value) {
                        this.$expirationInDays = value;
                    }

                    @Override
                    public Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@Nullable String value) {
                        this.$id = value;
                    }

                    @Override
                    public void setId(@Nullable CloudFormationToken value) {
                        this.$id = value;
                    }

                    @Override
                    public Object getNoncurrentVersionExpirationInDays() {
                        return this.$noncurrentVersionExpirationInDays;
                    }

                    @Override
                    public void setNoncurrentVersionExpirationInDays(@Nullable Number value) {
                        this.$noncurrentVersionExpirationInDays = value;
                    }

                    @Override
                    public void setNoncurrentVersionExpirationInDays(@Nullable CloudFormationToken value) {
                        this.$noncurrentVersionExpirationInDays = value;
                    }

                    @Override
                    public Object getNoncurrentVersionTransition() {
                        return this.$noncurrentVersionTransition;
                    }

                    @Override
                    public void setNoncurrentVersionTransition(@Nullable CloudFormationToken value) {
                        this.$noncurrentVersionTransition = value;
                    }

                    @Override
                    public void setNoncurrentVersionTransition(@Nullable NoncurrentVersionTransitionProperty value) {
                        this.$noncurrentVersionTransition = value;
                    }

                    @Override
                    public Object getNoncurrentVersionTransitions() {
                        return this.$noncurrentVersionTransitions;
                    }

                    @Override
                    public void setNoncurrentVersionTransitions(@Nullable CloudFormationToken value) {
                        this.$noncurrentVersionTransitions = value;
                    }

                    @Override
                    public void setNoncurrentVersionTransitions(@Nullable List<Object> value) {
                        this.$noncurrentVersionTransitions = value;
                    }

                    @Override
                    public Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@Nullable CloudFormationToken value) {
                        this.$prefix = value;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@Nullable CloudFormationToken value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@Nullable List<Object> value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public Object getTransition() {
                        return this.$transition;
                    }

                    @Override
                    public void setTransition(@Nullable CloudFormationToken value) {
                        this.$transition = value;
                    }

                    @Override
                    public void setTransition(@Nullable TransitionProperty value) {
                        this.$transition = value;
                    }

                    @Override
                    public Object getTransitions() {
                        return this.$transitions;
                    }

                    @Override
                    public void setTransitions(@Nullable CloudFormationToken value) {
                        this.$transitions = value;
                    }

                    @Override
                    public void setTransitions(@Nullable List<Object> value) {
                        this.$transitions = value;
                    }
                };
            }
        }
    }

    public static interface RoutingRuleProperty
    extends JsiiSerializable {
        public Object getRedirectRule();

        public void setRedirectRule(CloudFormationToken var1);

        public void setRedirectRule(RedirectRuleProperty var1);

        public Object getRoutingRuleCondition();

        public void setRoutingRuleCondition(CloudFormationToken var1);

        public void setRoutingRuleCondition(RoutingRuleConditionProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _redirectRule;
            @Nullable
            private Object _routingRuleCondition;

            public Builder withRedirectRule(CloudFormationToken value) {
                this._redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }

            public Builder withRedirectRule(RedirectRuleProperty value) {
                this._redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }

            public Builder withRoutingRuleCondition(@Nullable CloudFormationToken value) {
                this._routingRuleCondition = value;
                return this;
            }

            public Builder withRoutingRuleCondition(@Nullable RoutingRuleConditionProperty value) {
                this._routingRuleCondition = value;
                return this;
            }

            public RoutingRuleProperty build() {
                return new RoutingRuleProperty(){
                    private Object $redirectRule;
                    @Nullable
                    private Object $routingRuleCondition;
                    {
                        this.$redirectRule = Objects.requireNonNull(_redirectRule, "redirectRule is required");
                        this.$routingRuleCondition = _routingRuleCondition;
                    }

                    @Override
                    public Object getRedirectRule() {
                        return this.$redirectRule;
                    }

                    @Override
                    public void setRedirectRule(CloudFormationToken value) {
                        this.$redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                    }

                    @Override
                    public void setRedirectRule(RedirectRuleProperty value) {
                        this.$redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                    }

                    @Override
                    public Object getRoutingRuleCondition() {
                        return this.$routingRuleCondition;
                    }

                    @Override
                    public void setRoutingRuleCondition(@Nullable CloudFormationToken value) {
                        this.$routingRuleCondition = value;
                    }

                    @Override
                    public void setRoutingRuleCondition(@Nullable RoutingRuleConditionProperty value) {
                        this.$routingRuleCondition = value;
                    }
                };
            }
        }
    }

    public static interface RoutingRuleConditionProperty
    extends JsiiSerializable {
        public Object getHttpErrorCodeReturnedEquals();

        public void setHttpErrorCodeReturnedEquals(String var1);

        public void setHttpErrorCodeReturnedEquals(CloudFormationToken var1);

        public Object getKeyPrefixEquals();

        public void setKeyPrefixEquals(String var1);

        public void setKeyPrefixEquals(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _httpErrorCodeReturnedEquals;
            @Nullable
            private Object _keyPrefixEquals;

            public Builder withHttpErrorCodeReturnedEquals(@Nullable String value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }

            public Builder withHttpErrorCodeReturnedEquals(@Nullable CloudFormationToken value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }

            public Builder withKeyPrefixEquals(@Nullable String value) {
                this._keyPrefixEquals = value;
                return this;
            }

            public Builder withKeyPrefixEquals(@Nullable CloudFormationToken value) {
                this._keyPrefixEquals = value;
                return this;
            }

            public RoutingRuleConditionProperty build() {
                return new RoutingRuleConditionProperty(){
                    @Nullable
                    private Object $httpErrorCodeReturnedEquals;
                    @Nullable
                    private Object $keyPrefixEquals;
                    {
                        this.$httpErrorCodeReturnedEquals = _httpErrorCodeReturnedEquals;
                        this.$keyPrefixEquals = _keyPrefixEquals;
                    }

                    @Override
                    public Object getHttpErrorCodeReturnedEquals() {
                        return this.$httpErrorCodeReturnedEquals;
                    }

                    @Override
                    public void setHttpErrorCodeReturnedEquals(@Nullable String value) {
                        this.$httpErrorCodeReturnedEquals = value;
                    }

                    @Override
                    public void setHttpErrorCodeReturnedEquals(@Nullable CloudFormationToken value) {
                        this.$httpErrorCodeReturnedEquals = value;
                    }

                    @Override
                    public Object getKeyPrefixEquals() {
                        return this.$keyPrefixEquals;
                    }

                    @Override
                    public void setKeyPrefixEquals(@Nullable String value) {
                        this.$keyPrefixEquals = value;
                    }

                    @Override
                    public void setKeyPrefixEquals(@Nullable CloudFormationToken value) {
                        this.$keyPrefixEquals = value;
                    }
                };
            }
        }
    }

    public static interface ReplicationRuleProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(CloudFormationToken var1);

        public void setDestination(ReplicationDestinationProperty var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(CloudFormationToken var1);

        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(CloudFormationToken var1);

        public Object getId();

        public void setId(String var1);

        public void setId(CloudFormationToken var1);

        public Object getSourceSelectionCriteria();

        public void setSourceSelectionCriteria(CloudFormationToken var1);

        public void setSourceSelectionCriteria(SourceSelectionCriteriaProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private Object _prefix;
            private Object _status;
            @Nullable
            private Object _id;
            @Nullable
            private Object _sourceSelectionCriteria;

            public Builder withDestination(CloudFormationToken value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(ReplicationDestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withPrefix(String value) {
                this._prefix = Objects.requireNonNull(value, "prefix is required");
                return this;
            }

            public Builder withPrefix(CloudFormationToken value) {
                this._prefix = Objects.requireNonNull(value, "prefix is required");
                return this;
            }

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withStatus(CloudFormationToken value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withId(@Nullable CloudFormationToken value) {
                this._id = value;
                return this;
            }

            public Builder withSourceSelectionCriteria(@Nullable CloudFormationToken value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            public Builder withSourceSelectionCriteria(@Nullable SourceSelectionCriteriaProperty value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            public ReplicationRuleProperty build() {
                return new ReplicationRuleProperty(){
                    private Object $destination;
                    private Object $prefix;
                    private Object $status;
                    @Nullable
                    private Object $id;
                    @Nullable
                    private Object $sourceSelectionCriteria;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$prefix = Objects.requireNonNull(_prefix, "prefix is required");
                        this.$status = Objects.requireNonNull(_status, "status is required");
                        this.$id = _id;
                        this.$sourceSelectionCriteria = _sourceSelectionCriteria;
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(CloudFormationToken value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(ReplicationDestinationProperty value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(String value) {
                        this.$prefix = Objects.requireNonNull(value, "prefix is required");
                    }

                    @Override
                    public void setPrefix(CloudFormationToken value) {
                        this.$prefix = Objects.requireNonNull(value, "prefix is required");
                    }

                    @Override
                    public Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(CloudFormationToken value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@Nullable String value) {
                        this.$id = value;
                    }

                    @Override
                    public void setId(@Nullable CloudFormationToken value) {
                        this.$id = value;
                    }

                    @Override
                    public Object getSourceSelectionCriteria() {
                        return this.$sourceSelectionCriteria;
                    }

                    @Override
                    public void setSourceSelectionCriteria(@Nullable CloudFormationToken value) {
                        this.$sourceSelectionCriteria = value;
                    }

                    @Override
                    public void setSourceSelectionCriteria(@Nullable SourceSelectionCriteriaProperty value) {
                        this.$sourceSelectionCriteria = value;
                    }
                };
            }
        }
    }

    public static interface ReplicationDestinationProperty
    extends JsiiSerializable {
        public Object getBucket();

        public void setBucket(String var1);

        public void setBucket(CloudFormationToken var1);

        public Object getAccessControlTranslation();

        public void setAccessControlTranslation(CloudFormationToken var1);

        public void setAccessControlTranslation(AccessControlTranslationProperty var1);

        public Object getAccount();

        public void setAccount(String var1);

        public void setAccount(CloudFormationToken var1);

        public Object getEncryptionConfiguration();

        public void setEncryptionConfiguration(CloudFormationToken var1);

        public void setEncryptionConfiguration(EncryptionConfigurationProperty var1);

        public Object getStorageClass();

        public void setStorageClass(String var1);

        public void setStorageClass(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _bucket;
            @Nullable
            private Object _accessControlTranslation;
            @Nullable
            private Object _account;
            @Nullable
            private Object _encryptionConfiguration;
            @Nullable
            private Object _storageClass;

            public Builder withBucket(String value) {
                this._bucket = Objects.requireNonNull(value, "bucket is required");
                return this;
            }

            public Builder withBucket(CloudFormationToken value) {
                this._bucket = Objects.requireNonNull(value, "bucket is required");
                return this;
            }

            public Builder withAccessControlTranslation(@Nullable CloudFormationToken value) {
                this._accessControlTranslation = value;
                return this;
            }

            public Builder withAccessControlTranslation(@Nullable AccessControlTranslationProperty value) {
                this._accessControlTranslation = value;
                return this;
            }

            public Builder withAccount(@Nullable String value) {
                this._account = value;
                return this;
            }

            public Builder withAccount(@Nullable CloudFormationToken value) {
                this._account = value;
                return this;
            }

            public Builder withEncryptionConfiguration(@Nullable CloudFormationToken value) {
                this._encryptionConfiguration = value;
                return this;
            }

            public Builder withEncryptionConfiguration(@Nullable EncryptionConfigurationProperty value) {
                this._encryptionConfiguration = value;
                return this;
            }

            public Builder withStorageClass(@Nullable String value) {
                this._storageClass = value;
                return this;
            }

            public Builder withStorageClass(@Nullable CloudFormationToken value) {
                this._storageClass = value;
                return this;
            }

            public ReplicationDestinationProperty build() {
                return new ReplicationDestinationProperty(){
                    private Object $bucket;
                    @Nullable
                    private Object $accessControlTranslation;
                    @Nullable
                    private Object $account;
                    @Nullable
                    private Object $encryptionConfiguration;
                    @Nullable
                    private Object $storageClass;
                    {
                        this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                        this.$accessControlTranslation = _accessControlTranslation;
                        this.$account = _account;
                        this.$encryptionConfiguration = _encryptionConfiguration;
                        this.$storageClass = _storageClass;
                    }

                    @Override
                    public Object getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public void setBucket(String value) {
                        this.$bucket = Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public void setBucket(CloudFormationToken value) {
                        this.$bucket = Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public Object getAccessControlTranslation() {
                        return this.$accessControlTranslation;
                    }

                    @Override
                    public void setAccessControlTranslation(@Nullable CloudFormationToken value) {
                        this.$accessControlTranslation = value;
                    }

                    @Override
                    public void setAccessControlTranslation(@Nullable AccessControlTranslationProperty value) {
                        this.$accessControlTranslation = value;
                    }

                    @Override
                    public Object getAccount() {
                        return this.$account;
                    }

                    @Override
                    public void setAccount(@Nullable String value) {
                        this.$account = value;
                    }

                    @Override
                    public void setAccount(@Nullable CloudFormationToken value) {
                        this.$account = value;
                    }

                    @Override
                    public Object getEncryptionConfiguration() {
                        return this.$encryptionConfiguration;
                    }

                    @Override
                    public void setEncryptionConfiguration(@Nullable CloudFormationToken value) {
                        this.$encryptionConfiguration = value;
                    }

                    @Override
                    public void setEncryptionConfiguration(@Nullable EncryptionConfigurationProperty value) {
                        this.$encryptionConfiguration = value;
                    }

                    @Override
                    public Object getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(@Nullable String value) {
                        this.$storageClass = value;
                    }

                    @Override
                    public void setStorageClass(@Nullable CloudFormationToken value) {
                        this.$storageClass = value;
                    }
                };
            }
        }
    }

    public static interface ReplicationConfigurationProperty
    extends JsiiSerializable {
        public Object getRole();

        public void setRole(String var1);

        public void setRole(CloudFormationToken var1);

        public Object getRules();

        public void setRules(CloudFormationToken var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _role;
            private Object _rules;

            public Builder withRole(String value) {
                this._role = Objects.requireNonNull(value, "role is required");
                return this;
            }

            public Builder withRole(CloudFormationToken value) {
                this._role = Objects.requireNonNull(value, "role is required");
                return this;
            }

            public Builder withRules(CloudFormationToken value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public ReplicationConfigurationProperty build() {
                return new ReplicationConfigurationProperty(){
                    private Object $role;
                    private Object $rules;
                    {
                        this.$role = Objects.requireNonNull(_role, "role is required");
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public Object getRole() {
                        return this.$role;
                    }

                    @Override
                    public void setRole(String value) {
                        this.$role = Objects.requireNonNull(value, "role is required");
                    }

                    @Override
                    public void setRole(CloudFormationToken value) {
                        this.$role = Objects.requireNonNull(value, "role is required");
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(CloudFormationToken value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(List<Object> value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }
                };
            }
        }
    }

    public static interface RedirectRuleProperty
    extends JsiiSerializable {
        public Object getHostName();

        public void setHostName(String var1);

        public void setHostName(CloudFormationToken var1);

        public Object getHttpRedirectCode();

        public void setHttpRedirectCode(String var1);

        public void setHttpRedirectCode(CloudFormationToken var1);

        public Object getProtocol();

        public void setProtocol(String var1);

        public void setProtocol(CloudFormationToken var1);

        public Object getReplaceKeyPrefixWith();

        public void setReplaceKeyPrefixWith(String var1);

        public void setReplaceKeyPrefixWith(CloudFormationToken var1);

        public Object getReplaceKeyWith();

        public void setReplaceKeyWith(String var1);

        public void setReplaceKeyWith(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _hostName;
            @Nullable
            private Object _httpRedirectCode;
            @Nullable
            private Object _protocol;
            @Nullable
            private Object _replaceKeyPrefixWith;
            @Nullable
            private Object _replaceKeyWith;

            public Builder withHostName(@Nullable String value) {
                this._hostName = value;
                return this;
            }

            public Builder withHostName(@Nullable CloudFormationToken value) {
                this._hostName = value;
                return this;
            }

            public Builder withHttpRedirectCode(@Nullable String value) {
                this._httpRedirectCode = value;
                return this;
            }

            public Builder withHttpRedirectCode(@Nullable CloudFormationToken value) {
                this._httpRedirectCode = value;
                return this;
            }

            public Builder withProtocol(@Nullable String value) {
                this._protocol = value;
                return this;
            }

            public Builder withProtocol(@Nullable CloudFormationToken value) {
                this._protocol = value;
                return this;
            }

            public Builder withReplaceKeyPrefixWith(@Nullable String value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }

            public Builder withReplaceKeyPrefixWith(@Nullable CloudFormationToken value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }

            public Builder withReplaceKeyWith(@Nullable String value) {
                this._replaceKeyWith = value;
                return this;
            }

            public Builder withReplaceKeyWith(@Nullable CloudFormationToken value) {
                this._replaceKeyWith = value;
                return this;
            }

            public RedirectRuleProperty build() {
                return new RedirectRuleProperty(){
                    @Nullable
                    private Object $hostName;
                    @Nullable
                    private Object $httpRedirectCode;
                    @Nullable
                    private Object $protocol;
                    @Nullable
                    private Object $replaceKeyPrefixWith;
                    @Nullable
                    private Object $replaceKeyWith;
                    {
                        this.$hostName = _hostName;
                        this.$httpRedirectCode = _httpRedirectCode;
                        this.$protocol = _protocol;
                        this.$replaceKeyPrefixWith = _replaceKeyPrefixWith;
                        this.$replaceKeyWith = _replaceKeyWith;
                    }

                    @Override
                    public Object getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public void setHostName(@Nullable String value) {
                        this.$hostName = value;
                    }

                    @Override
                    public void setHostName(@Nullable CloudFormationToken value) {
                        this.$hostName = value;
                    }

                    @Override
                    public Object getHttpRedirectCode() {
                        return this.$httpRedirectCode;
                    }

                    @Override
                    public void setHttpRedirectCode(@Nullable String value) {
                        this.$httpRedirectCode = value;
                    }

                    @Override
                    public void setHttpRedirectCode(@Nullable CloudFormationToken value) {
                        this.$httpRedirectCode = value;
                    }

                    @Override
                    public Object getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@Nullable String value) {
                        this.$protocol = value;
                    }

                    @Override
                    public void setProtocol(@Nullable CloudFormationToken value) {
                        this.$protocol = value;
                    }

                    @Override
                    public Object getReplaceKeyPrefixWith() {
                        return this.$replaceKeyPrefixWith;
                    }

                    @Override
                    public void setReplaceKeyPrefixWith(@Nullable String value) {
                        this.$replaceKeyPrefixWith = value;
                    }

                    @Override
                    public void setReplaceKeyPrefixWith(@Nullable CloudFormationToken value) {
                        this.$replaceKeyPrefixWith = value;
                    }

                    @Override
                    public Object getReplaceKeyWith() {
                        return this.$replaceKeyWith;
                    }

                    @Override
                    public void setReplaceKeyWith(@Nullable String value) {
                        this.$replaceKeyWith = value;
                    }

                    @Override
                    public void setReplaceKeyWith(@Nullable CloudFormationToken value) {
                        this.$replaceKeyWith = value;
                    }
                };
            }
        }
    }

    public static interface RedirectAllRequestsToProperty
    extends JsiiSerializable {
        public Object getHostName();

        public void setHostName(String var1);

        public void setHostName(CloudFormationToken var1);

        public Object getProtocol();

        public void setProtocol(String var1);

        public void setProtocol(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _hostName;
            @Nullable
            private Object _protocol;

            public Builder withHostName(String value) {
                this._hostName = Objects.requireNonNull(value, "hostName is required");
                return this;
            }

            public Builder withHostName(CloudFormationToken value) {
                this._hostName = Objects.requireNonNull(value, "hostName is required");
                return this;
            }

            public Builder withProtocol(@Nullable String value) {
                this._protocol = value;
                return this;
            }

            public Builder withProtocol(@Nullable CloudFormationToken value) {
                this._protocol = value;
                return this;
            }

            public RedirectAllRequestsToProperty build() {
                return new RedirectAllRequestsToProperty(){
                    private Object $hostName;
                    @Nullable
                    private Object $protocol;
                    {
                        this.$hostName = Objects.requireNonNull(_hostName, "hostName is required");
                        this.$protocol = _protocol;
                    }

                    @Override
                    public Object getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public void setHostName(String value) {
                        this.$hostName = Objects.requireNonNull(value, "hostName is required");
                    }

                    @Override
                    public void setHostName(CloudFormationToken value) {
                        this.$hostName = Objects.requireNonNull(value, "hostName is required");
                    }

                    @Override
                    public Object getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@Nullable String value) {
                        this.$protocol = value;
                    }

                    @Override
                    public void setProtocol(@Nullable CloudFormationToken value) {
                        this.$protocol = value;
                    }
                };
            }
        }
    }

    public static interface QueueConfigurationProperty
    extends JsiiSerializable {
        public Object getEvent();

        public void setEvent(String var1);

        public void setEvent(CloudFormationToken var1);

        public Object getQueue();

        public void setQueue(String var1);

        public void setQueue(CloudFormationToken var1);

        public Object getFilter();

        public void setFilter(CloudFormationToken var1);

        public void setFilter(NotificationFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _event;
            private Object _queue;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withEvent(CloudFormationToken value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withQueue(String value) {
                this._queue = Objects.requireNonNull(value, "queue is required");
                return this;
            }

            public Builder withQueue(CloudFormationToken value) {
                this._queue = Objects.requireNonNull(value, "queue is required");
                return this;
            }

            public Builder withFilter(@Nullable CloudFormationToken value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public QueueConfigurationProperty build() {
                return new QueueConfigurationProperty(){
                    private Object $event;
                    private Object $queue;
                    @Nullable
                    private Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$queue = Objects.requireNonNull(_queue, "queue is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public Object getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(String value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public void setEvent(CloudFormationToken value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public Object getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public void setQueue(String value) {
                        this.$queue = Objects.requireNonNull(value, "queue is required");
                    }

                    @Override
                    public void setQueue(CloudFormationToken value) {
                        this.$queue = Objects.requireNonNull(value, "queue is required");
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@Nullable CloudFormationToken value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@Nullable NotificationFilterProperty value) {
                        this.$filter = value;
                    }
                };
            }
        }
    }

    public static interface NotificationFilterProperty
    extends JsiiSerializable {
        public Object getS3Key();

        public void setS3Key(CloudFormationToken var1);

        public void setS3Key(S3KeyFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _s3Key;

            public Builder withS3Key(CloudFormationToken value) {
                this._s3Key = Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            public Builder withS3Key(S3KeyFilterProperty value) {
                this._s3Key = Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            public NotificationFilterProperty build() {
                return new NotificationFilterProperty(){
                    private Object $s3Key;
                    {
                        this.$s3Key = Objects.requireNonNull(_s3Key, "s3Key is required");
                    }

                    @Override
                    public Object getS3Key() {
                        return this.$s3Key;
                    }

                    @Override
                    public void setS3Key(CloudFormationToken value) {
                        this.$s3Key = Objects.requireNonNull(value, "s3Key is required");
                    }

                    @Override
                    public void setS3Key(S3KeyFilterProperty value) {
                        this.$s3Key = Objects.requireNonNull(value, "s3Key is required");
                    }
                };
            }
        }
    }

    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        public Object getLambdaConfigurations();

        public void setLambdaConfigurations(CloudFormationToken var1);

        public void setLambdaConfigurations(List<Object> var1);

        public Object getQueueConfigurations();

        public void setQueueConfigurations(CloudFormationToken var1);

        public void setQueueConfigurations(List<Object> var1);

        public Object getTopicConfigurations();

        public void setTopicConfigurations(CloudFormationToken var1);

        public void setTopicConfigurations(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _lambdaConfigurations;
            @Nullable
            private Object _queueConfigurations;
            @Nullable
            private Object _topicConfigurations;

            public Builder withLambdaConfigurations(@Nullable CloudFormationToken value) {
                this._lambdaConfigurations = value;
                return this;
            }

            public Builder withLambdaConfigurations(@Nullable List<Object> value) {
                this._lambdaConfigurations = value;
                return this;
            }

            public Builder withQueueConfigurations(@Nullable CloudFormationToken value) {
                this._queueConfigurations = value;
                return this;
            }

            public Builder withQueueConfigurations(@Nullable List<Object> value) {
                this._queueConfigurations = value;
                return this;
            }

            public Builder withTopicConfigurations(@Nullable CloudFormationToken value) {
                this._topicConfigurations = value;
                return this;
            }

            public Builder withTopicConfigurations(@Nullable List<Object> value) {
                this._topicConfigurations = value;
                return this;
            }

            public NotificationConfigurationProperty build() {
                return new NotificationConfigurationProperty(){
                    @Nullable
                    private Object $lambdaConfigurations;
                    @Nullable
                    private Object $queueConfigurations;
                    @Nullable
                    private Object $topicConfigurations;
                    {
                        this.$lambdaConfigurations = _lambdaConfigurations;
                        this.$queueConfigurations = _queueConfigurations;
                        this.$topicConfigurations = _topicConfigurations;
                    }

                    @Override
                    public Object getLambdaConfigurations() {
                        return this.$lambdaConfigurations;
                    }

                    @Override
                    public void setLambdaConfigurations(@Nullable CloudFormationToken value) {
                        this.$lambdaConfigurations = value;
                    }

                    @Override
                    public void setLambdaConfigurations(@Nullable List<Object> value) {
                        this.$lambdaConfigurations = value;
                    }

                    @Override
                    public Object getQueueConfigurations() {
                        return this.$queueConfigurations;
                    }

                    @Override
                    public void setQueueConfigurations(@Nullable CloudFormationToken value) {
                        this.$queueConfigurations = value;
                    }

                    @Override
                    public void setQueueConfigurations(@Nullable List<Object> value) {
                        this.$queueConfigurations = value;
                    }

                    @Override
                    public Object getTopicConfigurations() {
                        return this.$topicConfigurations;
                    }

                    @Override
                    public void setTopicConfigurations(@Nullable CloudFormationToken value) {
                        this.$topicConfigurations = value;
                    }

                    @Override
                    public void setTopicConfigurations(@Nullable List<Object> value) {
                        this.$topicConfigurations = value;
                    }
                };
            }
        }
    }

    public static interface NoncurrentVersionTransitionProperty
    extends JsiiSerializable {
        public Object getStorageClass();

        public void setStorageClass(String var1);

        public void setStorageClass(CloudFormationToken var1);

        public Object getTransitionInDays();

        public void setTransitionInDays(Number var1);

        public void setTransitionInDays(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _storageClass;
            private Object _transitionInDays;

            public Builder withStorageClass(String value) {
                this._storageClass = Objects.requireNonNull(value, "storageClass is required");
                return this;
            }

            public Builder withStorageClass(CloudFormationToken value) {
                this._storageClass = Objects.requireNonNull(value, "storageClass is required");
                return this;
            }

            public Builder withTransitionInDays(Number value) {
                this._transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            public Builder withTransitionInDays(CloudFormationToken value) {
                this._transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            public NoncurrentVersionTransitionProperty build() {
                return new NoncurrentVersionTransitionProperty(){
                    private Object $storageClass;
                    private Object $transitionInDays;
                    {
                        this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                        this.$transitionInDays = Objects.requireNonNull(_transitionInDays, "transitionInDays is required");
                    }

                    @Override
                    public Object getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(String value) {
                        this.$storageClass = Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public void setStorageClass(CloudFormationToken value) {
                        this.$storageClass = Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    @Override
                    public void setTransitionInDays(Number value) {
                        this.$transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                    }

                    @Override
                    public void setTransitionInDays(CloudFormationToken value) {
                        this.$transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                    }
                };
            }
        }
    }

    public static interface MetricsConfigurationProperty
    extends JsiiSerializable {
        public Object getId();

        public void setId(String var1);

        public void setId(CloudFormationToken var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(CloudFormationToken var1);

        public Object getTagFilters();

        public void setTagFilters(CloudFormationToken var1);

        public void setTagFilters(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _id;
            @Nullable
            private Object _prefix;
            @Nullable
            private Object _tagFilters;

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withId(CloudFormationToken value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withPrefix(@Nullable CloudFormationToken value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable CloudFormationToken value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public MetricsConfigurationProperty build() {
                return new MetricsConfigurationProperty(){
                    private Object $id;
                    @Nullable
                    private Object $prefix;
                    @Nullable
                    private Object $tagFilters;
                    {
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                    }

                    @Override
                    public Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(String value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public void setId(CloudFormationToken value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@Nullable CloudFormationToken value) {
                        this.$prefix = value;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@Nullable CloudFormationToken value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@Nullable List<Object> value) {
                        this.$tagFilters = value;
                    }
                };
            }
        }
    }

    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        public Object getDestinationBucketName();

        public void setDestinationBucketName(String var1);

        public void setDestinationBucketName(CloudFormationToken var1);

        public Object getLogFilePrefix();

        public void setLogFilePrefix(String var1);

        public void setLogFilePrefix(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _destinationBucketName;
            @Nullable
            private Object _logFilePrefix;

            public Builder withDestinationBucketName(@Nullable String value) {
                this._destinationBucketName = value;
                return this;
            }

            public Builder withDestinationBucketName(@Nullable CloudFormationToken value) {
                this._destinationBucketName = value;
                return this;
            }

            public Builder withLogFilePrefix(@Nullable String value) {
                this._logFilePrefix = value;
                return this;
            }

            public Builder withLogFilePrefix(@Nullable CloudFormationToken value) {
                this._logFilePrefix = value;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new LoggingConfigurationProperty(){
                    @Nullable
                    private Object $destinationBucketName;
                    @Nullable
                    private Object $logFilePrefix;
                    {
                        this.$destinationBucketName = _destinationBucketName;
                        this.$logFilePrefix = _logFilePrefix;
                    }

                    @Override
                    public Object getDestinationBucketName() {
                        return this.$destinationBucketName;
                    }

                    @Override
                    public void setDestinationBucketName(@Nullable String value) {
                        this.$destinationBucketName = value;
                    }

                    @Override
                    public void setDestinationBucketName(@Nullable CloudFormationToken value) {
                        this.$destinationBucketName = value;
                    }

                    @Override
                    public Object getLogFilePrefix() {
                        return this.$logFilePrefix;
                    }

                    @Override
                    public void setLogFilePrefix(@Nullable String value) {
                        this.$logFilePrefix = value;
                    }

                    @Override
                    public void setLogFilePrefix(@Nullable CloudFormationToken value) {
                        this.$logFilePrefix = value;
                    }
                };
            }
        }
    }

    public static interface LifecycleConfigurationProperty
    extends JsiiSerializable {
        public Object getRules();

        public void setRules(CloudFormationToken var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _rules;

            public Builder withRules(CloudFormationToken value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public LifecycleConfigurationProperty build() {
                return new LifecycleConfigurationProperty(){
                    private Object $rules;
                    {
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(CloudFormationToken value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(List<Object> value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }
                };
            }
        }
    }

    public static interface LambdaConfigurationProperty
    extends JsiiSerializable {
        public Object getEvent();

        public void setEvent(String var1);

        public void setEvent(CloudFormationToken var1);

        public Object getFunction();

        public void setFunction(String var1);

        public void setFunction(CloudFormationToken var1);

        public Object getFilter();

        public void setFilter(CloudFormationToken var1);

        public void setFilter(NotificationFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _event;
            private Object _function;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withEvent(CloudFormationToken value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withFunction(String value) {
                this._function = Objects.requireNonNull(value, "function is required");
                return this;
            }

            public Builder withFunction(CloudFormationToken value) {
                this._function = Objects.requireNonNull(value, "function is required");
                return this;
            }

            public Builder withFilter(@Nullable CloudFormationToken value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public LambdaConfigurationProperty build() {
                return new LambdaConfigurationProperty(){
                    private Object $event;
                    private Object $function;
                    @Nullable
                    private Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$function = Objects.requireNonNull(_function, "function is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public Object getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(String value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public void setEvent(CloudFormationToken value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public Object getFunction() {
                        return this.$function;
                    }

                    @Override
                    public void setFunction(String value) {
                        this.$function = Objects.requireNonNull(value, "function is required");
                    }

                    @Override
                    public void setFunction(CloudFormationToken value) {
                        this.$function = Objects.requireNonNull(value, "function is required");
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@Nullable CloudFormationToken value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@Nullable NotificationFilterProperty value) {
                        this.$filter = value;
                    }
                };
            }
        }
    }

    public static interface InventoryConfigurationProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(CloudFormationToken var1);

        public void setDestination(DestinationProperty var1);

        public Object getEnabled();

        public void setEnabled(Boolean var1);

        public void setEnabled(CloudFormationToken var1);

        public Object getId();

        public void setId(String var1);

        public void setId(CloudFormationToken var1);

        public Object getIncludedObjectVersions();

        public void setIncludedObjectVersions(String var1);

        public void setIncludedObjectVersions(CloudFormationToken var1);

        public Object getScheduleFrequency();

        public void setScheduleFrequency(String var1);

        public void setScheduleFrequency(CloudFormationToken var1);

        public Object getOptionalFields();

        public void setOptionalFields(CloudFormationToken var1);

        public void setOptionalFields(List<Object> var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private Object _enabled;
            private Object _id;
            private Object _includedObjectVersions;
            private Object _scheduleFrequency;
            @Nullable
            private Object _optionalFields;
            @Nullable
            private Object _prefix;

            public Builder withDestination(CloudFormationToken value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(DestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withEnabled(Boolean value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withEnabled(CloudFormationToken value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withId(CloudFormationToken value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withIncludedObjectVersions(String value) {
                this._includedObjectVersions = Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }

            public Builder withIncludedObjectVersions(CloudFormationToken value) {
                this._includedObjectVersions = Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }

            public Builder withScheduleFrequency(String value) {
                this._scheduleFrequency = Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }

            public Builder withScheduleFrequency(CloudFormationToken value) {
                this._scheduleFrequency = Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }

            public Builder withOptionalFields(@Nullable CloudFormationToken value) {
                this._optionalFields = value;
                return this;
            }

            public Builder withOptionalFields(@Nullable List<Object> value) {
                this._optionalFields = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withPrefix(@Nullable CloudFormationToken value) {
                this._prefix = value;
                return this;
            }

            public InventoryConfigurationProperty build() {
                return new InventoryConfigurationProperty(){
                    private Object $destination;
                    private Object $enabled;
                    private Object $id;
                    private Object $includedObjectVersions;
                    private Object $scheduleFrequency;
                    @Nullable
                    private Object $optionalFields;
                    @Nullable
                    private Object $prefix;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$enabled = Objects.requireNonNull(_enabled, "enabled is required");
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$includedObjectVersions = Objects.requireNonNull(_includedObjectVersions, "includedObjectVersions is required");
                        this.$scheduleFrequency = Objects.requireNonNull(_scheduleFrequency, "scheduleFrequency is required");
                        this.$optionalFields = _optionalFields;
                        this.$prefix = _prefix;
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(CloudFormationToken value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(DestinationProperty value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(Boolean value) {
                        this.$enabled = Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public void setEnabled(CloudFormationToken value) {
                        this.$enabled = Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(String value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public void setId(CloudFormationToken value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public Object getIncludedObjectVersions() {
                        return this.$includedObjectVersions;
                    }

                    @Override
                    public void setIncludedObjectVersions(String value) {
                        this.$includedObjectVersions = Objects.requireNonNull(value, "includedObjectVersions is required");
                    }

                    @Override
                    public void setIncludedObjectVersions(CloudFormationToken value) {
                        this.$includedObjectVersions = Objects.requireNonNull(value, "includedObjectVersions is required");
                    }

                    @Override
                    public Object getScheduleFrequency() {
                        return this.$scheduleFrequency;
                    }

                    @Override
                    public void setScheduleFrequency(String value) {
                        this.$scheduleFrequency = Objects.requireNonNull(value, "scheduleFrequency is required");
                    }

                    @Override
                    public void setScheduleFrequency(CloudFormationToken value) {
                        this.$scheduleFrequency = Objects.requireNonNull(value, "scheduleFrequency is required");
                    }

                    @Override
                    public Object getOptionalFields() {
                        return this.$optionalFields;
                    }

                    @Override
                    public void setOptionalFields(@Nullable CloudFormationToken value) {
                        this.$optionalFields = value;
                    }

                    @Override
                    public void setOptionalFields(@Nullable List<Object> value) {
                        this.$optionalFields = value;
                    }

                    @Override
                    public Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@Nullable CloudFormationToken value) {
                        this.$prefix = value;
                    }
                };
            }
        }
    }

    public static interface FilterRuleProperty
    extends JsiiSerializable {
        public Object getName();

        public void setName(String var1);

        public void setName(CloudFormationToken var1);

        public Object getValue();

        public void setValue(String var1);

        public void setValue(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _name;
            private Object _value;

            public Builder withName(String value) {
                this._name = Objects.requireNonNull(value, "name is required");
                return this;
            }

            public Builder withName(CloudFormationToken value) {
                this._name = Objects.requireNonNull(value, "name is required");
                return this;
            }

            public Builder withValue(String value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public Builder withValue(CloudFormationToken value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public FilterRuleProperty build() {
                return new FilterRuleProperty(){
                    private Object $name;
                    private Object $value;
                    {
                        this.$name = Objects.requireNonNull(_name, "name is required");
                        this.$value = Objects.requireNonNull(_value, "value is required");
                    }

                    @Override
                    public Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(String value) {
                        this.$name = Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public void setName(CloudFormationToken value) {
                        this.$name = Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(String value) {
                        this.$value = Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public void setValue(CloudFormationToken value) {
                        this.$value = Objects.requireNonNull(value, "value is required");
                    }
                };
            }
        }
    }

    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        public Object getReplicaKmsKeyId();

        public void setReplicaKmsKeyId(String var1);

        public void setReplicaKmsKeyId(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _replicaKmsKeyId;

            public Builder withReplicaKmsKeyId(String value) {
                this._replicaKmsKeyId = Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }

            public Builder withReplicaKmsKeyId(CloudFormationToken value) {
                this._replicaKmsKeyId = Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new EncryptionConfigurationProperty(){
                    private Object $replicaKmsKeyId;
                    {
                        this.$replicaKmsKeyId = Objects.requireNonNull(_replicaKmsKeyId, "replicaKmsKeyId is required");
                    }

                    @Override
                    public Object getReplicaKmsKeyId() {
                        return this.$replicaKmsKeyId;
                    }

                    @Override
                    public void setReplicaKmsKeyId(String value) {
                        this.$replicaKmsKeyId = Objects.requireNonNull(value, "replicaKmsKeyId is required");
                    }

                    @Override
                    public void setReplicaKmsKeyId(CloudFormationToken value) {
                        this.$replicaKmsKeyId = Objects.requireNonNull(value, "replicaKmsKeyId is required");
                    }
                };
            }
        }
    }

    public static interface DestinationProperty
    extends JsiiSerializable {
        public Object getBucketArn();

        public void setBucketArn(String var1);

        public void setBucketArn(CloudFormationToken var1);

        public Object getFormat();

        public void setFormat(String var1);

        public void setFormat(CloudFormationToken var1);

        public Object getBucketAccountId();

        public void setBucketAccountId(String var1);

        public void setBucketAccountId(CloudFormationToken var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _bucketArn;
            private Object _format;
            @Nullable
            private Object _bucketAccountId;
            @Nullable
            private Object _prefix;

            public Builder withBucketArn(String value) {
                this._bucketArn = Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }

            public Builder withBucketArn(CloudFormationToken value) {
                this._bucketArn = Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }

            public Builder withFormat(String value) {
                this._format = Objects.requireNonNull(value, "format is required");
                return this;
            }

            public Builder withFormat(CloudFormationToken value) {
                this._format = Objects.requireNonNull(value, "format is required");
                return this;
            }

            public Builder withBucketAccountId(@Nullable String value) {
                this._bucketAccountId = value;
                return this;
            }

            public Builder withBucketAccountId(@Nullable CloudFormationToken value) {
                this._bucketAccountId = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withPrefix(@Nullable CloudFormationToken value) {
                this._prefix = value;
                return this;
            }

            public DestinationProperty build() {
                return new DestinationProperty(){
                    private Object $bucketArn;
                    private Object $format;
                    @Nullable
                    private Object $bucketAccountId;
                    @Nullable
                    private Object $prefix;
                    {
                        this.$bucketArn = Objects.requireNonNull(_bucketArn, "bucketArn is required");
                        this.$format = Objects.requireNonNull(_format, "format is required");
                        this.$bucketAccountId = _bucketAccountId;
                        this.$prefix = _prefix;
                    }

                    @Override
                    public Object getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public void setBucketArn(String value) {
                        this.$bucketArn = Objects.requireNonNull(value, "bucketArn is required");
                    }

                    @Override
                    public void setBucketArn(CloudFormationToken value) {
                        this.$bucketArn = Objects.requireNonNull(value, "bucketArn is required");
                    }

                    @Override
                    public Object getFormat() {
                        return this.$format;
                    }

                    @Override
                    public void setFormat(String value) {
                        this.$format = Objects.requireNonNull(value, "format is required");
                    }

                    @Override
                    public void setFormat(CloudFormationToken value) {
                        this.$format = Objects.requireNonNull(value, "format is required");
                    }

                    @Override
                    public Object getBucketAccountId() {
                        return this.$bucketAccountId;
                    }

                    @Override
                    public void setBucketAccountId(@Nullable String value) {
                        this.$bucketAccountId = value;
                    }

                    @Override
                    public void setBucketAccountId(@Nullable CloudFormationToken value) {
                        this.$bucketAccountId = value;
                    }

                    @Override
                    public Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@Nullable CloudFormationToken value) {
                        this.$prefix = value;
                    }
                };
            }
        }
    }

    public static interface DataExportProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(CloudFormationToken var1);

        public void setDestination(DestinationProperty var1);

        public Object getOutputSchemaVersion();

        public void setOutputSchemaVersion(String var1);

        public void setOutputSchemaVersion(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private Object _outputSchemaVersion;

            public Builder withDestination(CloudFormationToken value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(DestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withOutputSchemaVersion(String value) {
                this._outputSchemaVersion = Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }

            public Builder withOutputSchemaVersion(CloudFormationToken value) {
                this._outputSchemaVersion = Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }

            public DataExportProperty build() {
                return new DataExportProperty(){
                    private Object $destination;
                    private Object $outputSchemaVersion;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$outputSchemaVersion = Objects.requireNonNull(_outputSchemaVersion, "outputSchemaVersion is required");
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(CloudFormationToken value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(DestinationProperty value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public Object getOutputSchemaVersion() {
                        return this.$outputSchemaVersion;
                    }

                    @Override
                    public void setOutputSchemaVersion(String value) {
                        this.$outputSchemaVersion = Objects.requireNonNull(value, "outputSchemaVersion is required");
                    }

                    @Override
                    public void setOutputSchemaVersion(CloudFormationToken value) {
                        this.$outputSchemaVersion = Objects.requireNonNull(value, "outputSchemaVersion is required");
                    }
                };
            }
        }
    }

    public static interface CorsRuleProperty
    extends JsiiSerializable {
        public Object getAllowedMethods();

        public void setAllowedMethods(CloudFormationToken var1);

        public void setAllowedMethods(List<Object> var1);

        public Object getAllowedOrigins();

        public void setAllowedOrigins(CloudFormationToken var1);

        public void setAllowedOrigins(List<Object> var1);

        public Object getAllowedHeaders();

        public void setAllowedHeaders(CloudFormationToken var1);

        public void setAllowedHeaders(List<Object> var1);

        public Object getExposedHeaders();

        public void setExposedHeaders(CloudFormationToken var1);

        public void setExposedHeaders(List<Object> var1);

        public Object getId();

        public void setId(String var1);

        public void setId(CloudFormationToken var1);

        public Object getMaxAge();

        public void setMaxAge(Number var1);

        public void setMaxAge(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _allowedMethods;
            private Object _allowedOrigins;
            @Nullable
            private Object _allowedHeaders;
            @Nullable
            private Object _exposedHeaders;
            @Nullable
            private Object _id;
            @Nullable
            private Object _maxAge;

            public Builder withAllowedMethods(CloudFormationToken value) {
                this._allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }

            public Builder withAllowedMethods(List<Object> value) {
                this._allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }

            public Builder withAllowedOrigins(CloudFormationToken value) {
                this._allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }

            public Builder withAllowedOrigins(List<Object> value) {
                this._allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }

            public Builder withAllowedHeaders(@Nullable CloudFormationToken value) {
                this._allowedHeaders = value;
                return this;
            }

            public Builder withAllowedHeaders(@Nullable List<Object> value) {
                this._allowedHeaders = value;
                return this;
            }

            public Builder withExposedHeaders(@Nullable CloudFormationToken value) {
                this._exposedHeaders = value;
                return this;
            }

            public Builder withExposedHeaders(@Nullable List<Object> value) {
                this._exposedHeaders = value;
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withId(@Nullable CloudFormationToken value) {
                this._id = value;
                return this;
            }

            public Builder withMaxAge(@Nullable Number value) {
                this._maxAge = value;
                return this;
            }

            public Builder withMaxAge(@Nullable CloudFormationToken value) {
                this._maxAge = value;
                return this;
            }

            public CorsRuleProperty build() {
                return new CorsRuleProperty(){
                    private Object $allowedMethods;
                    private Object $allowedOrigins;
                    @Nullable
                    private Object $allowedHeaders;
                    @Nullable
                    private Object $exposedHeaders;
                    @Nullable
                    private Object $id;
                    @Nullable
                    private Object $maxAge;
                    {
                        this.$allowedMethods = Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                        this.$allowedOrigins = Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                        this.$allowedHeaders = _allowedHeaders;
                        this.$exposedHeaders = _exposedHeaders;
                        this.$id = _id;
                        this.$maxAge = _maxAge;
                    }

                    @Override
                    public Object getAllowedMethods() {
                        return this.$allowedMethods;
                    }

                    @Override
                    public void setAllowedMethods(CloudFormationToken value) {
                        this.$allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                    }

                    @Override
                    public void setAllowedMethods(List<Object> value) {
                        this.$allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                    }

                    @Override
                    public Object getAllowedOrigins() {
                        return this.$allowedOrigins;
                    }

                    @Override
                    public void setAllowedOrigins(CloudFormationToken value) {
                        this.$allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                    }

                    @Override
                    public void setAllowedOrigins(List<Object> value) {
                        this.$allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                    }

                    @Override
                    public Object getAllowedHeaders() {
                        return this.$allowedHeaders;
                    }

                    @Override
                    public void setAllowedHeaders(@Nullable CloudFormationToken value) {
                        this.$allowedHeaders = value;
                    }

                    @Override
                    public void setAllowedHeaders(@Nullable List<Object> value) {
                        this.$allowedHeaders = value;
                    }

                    @Override
                    public Object getExposedHeaders() {
                        return this.$exposedHeaders;
                    }

                    @Override
                    public void setExposedHeaders(@Nullable CloudFormationToken value) {
                        this.$exposedHeaders = value;
                    }

                    @Override
                    public void setExposedHeaders(@Nullable List<Object> value) {
                        this.$exposedHeaders = value;
                    }

                    @Override
                    public Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@Nullable String value) {
                        this.$id = value;
                    }

                    @Override
                    public void setId(@Nullable CloudFormationToken value) {
                        this.$id = value;
                    }

                    @Override
                    public Object getMaxAge() {
                        return this.$maxAge;
                    }

                    @Override
                    public void setMaxAge(@Nullable Number value) {
                        this.$maxAge = value;
                    }

                    @Override
                    public void setMaxAge(@Nullable CloudFormationToken value) {
                        this.$maxAge = value;
                    }
                };
            }
        }
    }

    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        public Object getCorsRules();

        public void setCorsRules(CloudFormationToken var1);

        public void setCorsRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _corsRules;

            public Builder withCorsRules(CloudFormationToken value) {
                this._corsRules = Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            public Builder withCorsRules(List<Object> value) {
                this._corsRules = Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            public CorsConfigurationProperty build() {
                return new CorsConfigurationProperty(){
                    private Object $corsRules;
                    {
                        this.$corsRules = Objects.requireNonNull(_corsRules, "corsRules is required");
                    }

                    @Override
                    public Object getCorsRules() {
                        return this.$corsRules;
                    }

                    @Override
                    public void setCorsRules(CloudFormationToken value) {
                        this.$corsRules = Objects.requireNonNull(value, "corsRules is required");
                    }

                    @Override
                    public void setCorsRules(List<Object> value) {
                        this.$corsRules = Objects.requireNonNull(value, "corsRules is required");
                    }
                };
            }
        }
    }

    public static interface BucketEncryptionProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionConfiguration();

        public void setServerSideEncryptionConfiguration(CloudFormationToken var1);

        public void setServerSideEncryptionConfiguration(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _serverSideEncryptionConfiguration;

            public Builder withServerSideEncryptionConfiguration(CloudFormationToken value) {
                this._serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            public Builder withServerSideEncryptionConfiguration(List<Object> value) {
                this._serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            public BucketEncryptionProperty build() {
                return new BucketEncryptionProperty(){
                    private Object $serverSideEncryptionConfiguration;
                    {
                        this.$serverSideEncryptionConfiguration = Objects.requireNonNull(_serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");
                    }

                    @Override
                    public Object getServerSideEncryptionConfiguration() {
                        return this.$serverSideEncryptionConfiguration;
                    }

                    @Override
                    public void setServerSideEncryptionConfiguration(CloudFormationToken value) {
                        this.$serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                    }

                    @Override
                    public void setServerSideEncryptionConfiguration(List<Object> value) {
                        this.$serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                    }
                };
            }
        }
    }

    public static interface AnalyticsConfigurationProperty
    extends JsiiSerializable {
        public Object getId();

        public void setId(String var1);

        public void setId(CloudFormationToken var1);

        public Object getStorageClassAnalysis();

        public void setStorageClassAnalysis(CloudFormationToken var1);

        public void setStorageClassAnalysis(StorageClassAnalysisProperty var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(CloudFormationToken var1);

        public Object getTagFilters();

        public void setTagFilters(CloudFormationToken var1);

        public void setTagFilters(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _id;
            private Object _storageClassAnalysis;
            @Nullable
            private Object _prefix;
            @Nullable
            private Object _tagFilters;

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withId(CloudFormationToken value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withStorageClassAnalysis(CloudFormationToken value) {
                this._storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }

            public Builder withStorageClassAnalysis(StorageClassAnalysisProperty value) {
                this._storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withPrefix(@Nullable CloudFormationToken value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable CloudFormationToken value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public AnalyticsConfigurationProperty build() {
                return new AnalyticsConfigurationProperty(){
                    private Object $id;
                    private Object $storageClassAnalysis;
                    @Nullable
                    private Object $prefix;
                    @Nullable
                    private Object $tagFilters;
                    {
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$storageClassAnalysis = Objects.requireNonNull(_storageClassAnalysis, "storageClassAnalysis is required");
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                    }

                    @Override
                    public Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(String value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public void setId(CloudFormationToken value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public Object getStorageClassAnalysis() {
                        return this.$storageClassAnalysis;
                    }

                    @Override
                    public void setStorageClassAnalysis(CloudFormationToken value) {
                        this.$storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                    }

                    @Override
                    public void setStorageClassAnalysis(StorageClassAnalysisProperty value) {
                        this.$storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                    }

                    @Override
                    public Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@Nullable CloudFormationToken value) {
                        this.$prefix = value;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@Nullable CloudFormationToken value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@Nullable List<Object> value) {
                        this.$tagFilters = value;
                    }
                };
            }
        }
    }

    public static interface AccessControlTranslationProperty
    extends JsiiSerializable {
        public Object getOwner();

        public void setOwner(String var1);

        public void setOwner(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _owner;

            public Builder withOwner(String value) {
                this._owner = Objects.requireNonNull(value, "owner is required");
                return this;
            }

            public Builder withOwner(CloudFormationToken value) {
                this._owner = Objects.requireNonNull(value, "owner is required");
                return this;
            }

            public AccessControlTranslationProperty build() {
                return new AccessControlTranslationProperty(){
                    private Object $owner;
                    {
                        this.$owner = Objects.requireNonNull(_owner, "owner is required");
                    }

                    @Override
                    public Object getOwner() {
                        return this.$owner;
                    }

                    @Override
                    public void setOwner(String value) {
                        this.$owner = Objects.requireNonNull(value, "owner is required");
                    }

                    @Override
                    public void setOwner(CloudFormationToken value) {
                        this.$owner = Objects.requireNonNull(value, "owner is required");
                    }
                };
            }
        }
    }

    public static interface AccelerateConfigurationProperty
    extends JsiiSerializable {
        public Object getAccelerationStatus();

        public void setAccelerationStatus(String var1);

        public void setAccelerationStatus(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _accelerationStatus;

            public Builder withAccelerationStatus(String value) {
                this._accelerationStatus = Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }

            public Builder withAccelerationStatus(CloudFormationToken value) {
                this._accelerationStatus = Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }

            public AccelerateConfigurationProperty build() {
                return new AccelerateConfigurationProperty(){
                    private Object $accelerationStatus;
                    {
                        this.$accelerationStatus = Objects.requireNonNull(_accelerationStatus, "accelerationStatus is required");
                    }

                    @Override
                    public Object getAccelerationStatus() {
                        return this.$accelerationStatus;
                    }

                    @Override
                    public void setAccelerationStatus(String value) {
                        this.$accelerationStatus = Objects.requireNonNull(value, "accelerationStatus is required");
                    }

                    @Override
                    public void setAccelerationStatus(CloudFormationToken value) {
                        this.$accelerationStatus = Objects.requireNonNull(value, "accelerationStatus is required");
                    }
                };
            }
        }
    }

    public static interface AbortIncompleteMultipartUploadProperty
    extends JsiiSerializable {
        public Object getDaysAfterInitiation();

        public void setDaysAfterInitiation(Number var1);

        public void setDaysAfterInitiation(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _daysAfterInitiation;

            public Builder withDaysAfterInitiation(Number value) {
                this._daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            public Builder withDaysAfterInitiation(CloudFormationToken value) {
                this._daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            public AbortIncompleteMultipartUploadProperty build() {
                return new AbortIncompleteMultipartUploadProperty(){
                    private Object $daysAfterInitiation;
                    {
                        this.$daysAfterInitiation = Objects.requireNonNull(_daysAfterInitiation, "daysAfterInitiation is required");
                    }

                    @Override
                    public Object getDaysAfterInitiation() {
                        return this.$daysAfterInitiation;
                    }

                    @Override
                    public void setDaysAfterInitiation(Number value) {
                        this.$daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                    }

                    @Override
                    public void setDaysAfterInitiation(CloudFormationToken value) {
                        this.$daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                    }
                };
            }
        }
    }
}

