/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import software.amazon.awscdk.services.s3.StorageClass;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface NoncurrentVersionTransition
extends JsiiSerializable {
    public StorageClass getStorageClass();

    public Number getTransitionInDays();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StorageClass _storageClass;
        private Number _transitionInDays;

        public Builder withStorageClass(StorageClass value) {
            this._storageClass = Objects.requireNonNull(value, "storageClass is required");
            return this;
        }

        public Builder withTransitionInDays(Number value) {
            this._transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
            return this;
        }

        public NoncurrentVersionTransition build() {
            return new NoncurrentVersionTransition(){
                private final StorageClass $storageClass;
                private final Number $transitionInDays;
                {
                    this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                    this.$transitionInDays = Objects.requireNonNull(_transitionInDays, "transitionInDays is required");
                }

                @Override
                public StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public Number getTransitionInDays() {
                    return this.$transitionInDays;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("storageClass", om.valueToTree((Object)this.getStorageClass()));
                    obj.set("transitionInDays", om.valueToTree((Object)this.getTransitionInDays()));
                    return obj;
                }
            };
        }
    }
}

