/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.CfnBucketProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket
extends CfnResource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBucket.class, (String)"resourceTypeName", String.class);

    protected CfnBucket(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnBucket(Construct scope, String id, @Nullable CfnBucketProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(scope, "scope is required")), Stream.of(Objects.requireNonNull(id, "id is required"))), Stream.of(props)).toArray());
    }

    public CfnBucket(Construct scope, String id) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.of(Objects.requireNonNull(scope, "scope is required")), Stream.of(Objects.requireNonNull(id, "id is required"))).toArray());
    }

    protected Map<String, Object> renderProperties(Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, Stream.of(Objects.requireNonNull(properties, "properties is required")).toArray());
    }

    public String getBucketArn() {
        return (String)this.jsiiGet("bucketArn", String.class);
    }

    public String getBucketDomainName() {
        return (String)this.jsiiGet("bucketDomainName", String.class);
    }

    public String getBucketDualStackDomainName() {
        return (String)this.jsiiGet("bucketDualStackDomainName", String.class);
    }

    public String getBucketName() {
        return (String)this.jsiiGet("bucketName", String.class);
    }

    public String getBucketRegionalDomainName() {
        return (String)this.jsiiGet("bucketRegionalDomainName", String.class);
    }

    public String getBucketWebsiteUrl() {
        return (String)this.jsiiGet("bucketWebsiteUrl", String.class);
    }

    public CfnBucketProps getPropertyOverrides() {
        return (CfnBucketProps)this.jsiiGet("propertyOverrides", CfnBucketProps.class);
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public static interface WebsiteConfigurationProperty
    extends JsiiSerializable {
        public String getErrorDocument();

        public String getIndexDocument();

        public Object getRedirectAllRequestsTo();

        public Object getRoutingRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _errorDocument;
            @Nullable
            private String _indexDocument;
            @Nullable
            private Object _redirectAllRequestsTo;
            @Nullable
            private Object _routingRules;

            public Builder withErrorDocument(@Nullable String value) {
                this._errorDocument = value;
                return this;
            }

            public Builder withIndexDocument(@Nullable String value) {
                this._indexDocument = value;
                return this;
            }

            public Builder withRedirectAllRequestsTo(@Nullable Token value) {
                this._redirectAllRequestsTo = value;
                return this;
            }

            public Builder withRedirectAllRequestsTo(@Nullable RedirectAllRequestsToProperty value) {
                this._redirectAllRequestsTo = value;
                return this;
            }

            public Builder withRoutingRules(@Nullable Token value) {
                this._routingRules = value;
                return this;
            }

            public Builder withRoutingRules(@Nullable List<Object> value) {
                this._routingRules = value;
                return this;
            }

            public WebsiteConfigurationProperty build() {
                return new WebsiteConfigurationProperty(){
                    @Nullable
                    private final String $errorDocument;
                    @Nullable
                    private final String $indexDocument;
                    @Nullable
                    private final Object $redirectAllRequestsTo;
                    @Nullable
                    private final Object $routingRules;
                    {
                        this.$errorDocument = _errorDocument;
                        this.$indexDocument = _indexDocument;
                        this.$redirectAllRequestsTo = _redirectAllRequestsTo;
                        this.$routingRules = _routingRules;
                    }

                    @Override
                    public String getErrorDocument() {
                        return this.$errorDocument;
                    }

                    @Override
                    public String getIndexDocument() {
                        return this.$indexDocument;
                    }

                    @Override
                    public Object getRedirectAllRequestsTo() {
                        return this.$redirectAllRequestsTo;
                    }

                    @Override
                    public Object getRoutingRules() {
                        return this.$routingRules;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("errorDocument", om.valueToTree((Object)this.getErrorDocument()));
                        obj.set("indexDocument", om.valueToTree((Object)this.getIndexDocument()));
                        obj.set("redirectAllRequestsTo", om.valueToTree(this.getRedirectAllRequestsTo()));
                        obj.set("routingRules", om.valueToTree(this.getRoutingRules()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface VersioningConfigurationProperty
    extends JsiiSerializable {
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _status;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public VersioningConfigurationProperty build() {
                return new VersioningConfigurationProperty(){
                    private final String $status;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                    }

                    @Override
                    public String getStatus() {
                        return this.$status;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree((Object)this.getStatus()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface TransitionProperty
    extends JsiiSerializable {
        public String getStorageClass();

        public Object getTransitionDate();

        public Object getTransitionInDays();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _storageClass;
            @Nullable
            private Object _transitionDate;
            @Nullable
            private Object _transitionInDays;

            public Builder withStorageClass(String value) {
                this._storageClass = Objects.requireNonNull(value, "storageClass is required");
                return this;
            }

            public Builder withTransitionDate(@Nullable Token value) {
                this._transitionDate = value;
                return this;
            }

            public Builder withTransitionDate(@Nullable Instant value) {
                this._transitionDate = value;
                return this;
            }

            public Builder withTransitionInDays(@Nullable Number value) {
                this._transitionInDays = value;
                return this;
            }

            public Builder withTransitionInDays(@Nullable Token value) {
                this._transitionInDays = value;
                return this;
            }

            public TransitionProperty build() {
                return new TransitionProperty(){
                    private final String $storageClass;
                    @Nullable
                    private final Object $transitionDate;
                    @Nullable
                    private final Object $transitionInDays;
                    {
                        this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                        this.$transitionDate = _transitionDate;
                        this.$transitionInDays = _transitionInDays;
                    }

                    @Override
                    public String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public Object getTransitionDate() {
                        return this.$transitionDate;
                    }

                    @Override
                    public Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("storageClass", om.valueToTree((Object)this.getStorageClass()));
                        obj.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                        obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface TopicConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public String getTopic();

        public Object getFilter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _event;
            private String _topic;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withTopic(String value) {
                this._topic = Objects.requireNonNull(value, "topic is required");
                return this;
            }

            public Builder withFilter(@Nullable Token value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public TopicConfigurationProperty build() {
                return new TopicConfigurationProperty(){
                    private final String $event;
                    private final String $topic;
                    @Nullable
                    private final Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$topic = Objects.requireNonNull(_topic, "topic is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public String getTopic() {
                        return this.$topic;
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree((Object)this.getEvent()));
                        obj.set("topic", om.valueToTree((Object)this.getTopic()));
                        obj.set("filter", om.valueToTree(this.getFilter()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface TagFilterProperty
    extends JsiiSerializable {
        public String getKey();

        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _key;
            private String _value;

            public Builder withKey(String value) {
                this._key = Objects.requireNonNull(value, "key is required");
                return this;
            }

            public Builder withValue(String value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public TagFilterProperty build() {
                return new TagFilterProperty(){
                    private final String $key;
                    private final String $value;
                    {
                        this.$key = Objects.requireNonNull(_key, "key is required");
                        this.$value = Objects.requireNonNull(_value, "value is required");
                    }

                    @Override
                    public String getKey() {
                        return this.$key;
                    }

                    @Override
                    public String getValue() {
                        return this.$value;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree((Object)this.getKey()));
                        obj.set("value", om.valueToTree((Object)this.getValue()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface StorageClassAnalysisProperty
    extends JsiiSerializable {
        public Object getDataExport();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _dataExport;

            public Builder withDataExport(@Nullable Token value) {
                this._dataExport = value;
                return this;
            }

            public Builder withDataExport(@Nullable DataExportProperty value) {
                this._dataExport = value;
                return this;
            }

            public StorageClassAnalysisProperty build() {
                return new StorageClassAnalysisProperty(){
                    @Nullable
                    private final Object $dataExport;
                    {
                        this.$dataExport = _dataExport;
                    }

                    @Override
                    public Object getDataExport() {
                        return this.$dataExport;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("dataExport", om.valueToTree(this.getDataExport()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface SseKmsEncryptedObjectsProperty
    extends JsiiSerializable {
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _status;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public SseKmsEncryptedObjectsProperty build() {
                return new SseKmsEncryptedObjectsProperty(){
                    private final String $status;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                    }

                    @Override
                    public String getStatus() {
                        return this.$status;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree((Object)this.getStatus()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface SourceSelectionCriteriaProperty
    extends JsiiSerializable {
        public Object getSseKmsEncryptedObjects();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _sseKmsEncryptedObjects;

            public Builder withSseKmsEncryptedObjects(Token value) {
                this._sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            public Builder withSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty value) {
                this._sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            public SourceSelectionCriteriaProperty build() {
                return new SourceSelectionCriteriaProperty(){
                    private final Object $sseKmsEncryptedObjects;
                    {
                        this.$sseKmsEncryptedObjects = Objects.requireNonNull(_sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");
                    }

                    @Override
                    public Object getSseKmsEncryptedObjects() {
                        return this.$sseKmsEncryptedObjects;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("sseKmsEncryptedObjects", om.valueToTree(this.getSseKmsEncryptedObjects()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ServerSideEncryptionRuleProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionByDefault();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _serverSideEncryptionByDefault;

            public Builder withServerSideEncryptionByDefault(@Nullable Token value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            public Builder withServerSideEncryptionByDefault(@Nullable ServerSideEncryptionByDefaultProperty value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            public ServerSideEncryptionRuleProperty build() {
                return new ServerSideEncryptionRuleProperty(){
                    @Nullable
                    private final Object $serverSideEncryptionByDefault;
                    {
                        this.$serverSideEncryptionByDefault = _serverSideEncryptionByDefault;
                    }

                    @Override
                    public Object getServerSideEncryptionByDefault() {
                        return this.$serverSideEncryptionByDefault;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("serverSideEncryptionByDefault", om.valueToTree(this.getServerSideEncryptionByDefault()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ServerSideEncryptionByDefaultProperty
    extends JsiiSerializable {
        public String getSseAlgorithm();

        public String getKmsMasterKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _sseAlgorithm;
            @Nullable
            private String _kmsMasterKeyId;

            public Builder withSseAlgorithm(String value) {
                this._sseAlgorithm = Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }

            public Builder withKmsMasterKeyId(@Nullable String value) {
                this._kmsMasterKeyId = value;
                return this;
            }

            public ServerSideEncryptionByDefaultProperty build() {
                return new ServerSideEncryptionByDefaultProperty(){
                    private final String $sseAlgorithm;
                    @Nullable
                    private final String $kmsMasterKeyId;
                    {
                        this.$sseAlgorithm = Objects.requireNonNull(_sseAlgorithm, "sseAlgorithm is required");
                        this.$kmsMasterKeyId = _kmsMasterKeyId;
                    }

                    @Override
                    public String getSseAlgorithm() {
                        return this.$sseAlgorithm;
                    }

                    @Override
                    public String getKmsMasterKeyId() {
                        return this.$kmsMasterKeyId;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("sseAlgorithm", om.valueToTree((Object)this.getSseAlgorithm()));
                        obj.set("kmsMasterKeyId", om.valueToTree((Object)this.getKmsMasterKeyId()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _rules;

            public Builder withRules(Token value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public S3KeyFilterProperty build() {
                return new S3KeyFilterProperty(){
                    private final Object $rules;
                    {
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface RuleProperty
    extends JsiiSerializable {
        public String getStatus();

        public Object getAbortIncompleteMultipartUpload();

        public Object getExpirationDate();

        public Object getExpirationInDays();

        public String getId();

        public Object getNoncurrentVersionExpirationInDays();

        public Object getNoncurrentVersionTransition();

        public Object getNoncurrentVersionTransitions();

        public String getPrefix();

        public Object getTagFilters();

        public Object getTransition();

        public Object getTransitions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _status;
            @Nullable
            private Object _abortIncompleteMultipartUpload;
            @Nullable
            private Object _expirationDate;
            @Nullable
            private Object _expirationInDays;
            @Nullable
            private String _id;
            @Nullable
            private Object _noncurrentVersionExpirationInDays;
            @Nullable
            private Object _noncurrentVersionTransition;
            @Nullable
            private Object _noncurrentVersionTransitions;
            @Nullable
            private String _prefix;
            @Nullable
            private Object _tagFilters;
            @Nullable
            private Object _transition;
            @Nullable
            private Object _transitions;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withAbortIncompleteMultipartUpload(@Nullable Token value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }

            public Builder withAbortIncompleteMultipartUpload(@Nullable AbortIncompleteMultipartUploadProperty value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }

            public Builder withExpirationDate(@Nullable Token value) {
                this._expirationDate = value;
                return this;
            }

            public Builder withExpirationDate(@Nullable Instant value) {
                this._expirationDate = value;
                return this;
            }

            public Builder withExpirationInDays(@Nullable Number value) {
                this._expirationInDays = value;
                return this;
            }

            public Builder withExpirationInDays(@Nullable Token value) {
                this._expirationInDays = value;
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withNoncurrentVersionExpirationInDays(@Nullable Number value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }

            public Builder withNoncurrentVersionExpirationInDays(@Nullable Token value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }

            public Builder withNoncurrentVersionTransition(@Nullable Token value) {
                this._noncurrentVersionTransition = value;
                return this;
            }

            public Builder withNoncurrentVersionTransition(@Nullable NoncurrentVersionTransitionProperty value) {
                this._noncurrentVersionTransition = value;
                return this;
            }

            public Builder withNoncurrentVersionTransitions(@Nullable Token value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }

            public Builder withNoncurrentVersionTransitions(@Nullable List<Object> value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable Token value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTransition(@Nullable Token value) {
                this._transition = value;
                return this;
            }

            public Builder withTransition(@Nullable TransitionProperty value) {
                this._transition = value;
                return this;
            }

            public Builder withTransitions(@Nullable Token value) {
                this._transitions = value;
                return this;
            }

            public Builder withTransitions(@Nullable List<Object> value) {
                this._transitions = value;
                return this;
            }

            public RuleProperty build() {
                return new RuleProperty(){
                    private final String $status;
                    @Nullable
                    private final Object $abortIncompleteMultipartUpload;
                    @Nullable
                    private final Object $expirationDate;
                    @Nullable
                    private final Object $expirationInDays;
                    @Nullable
                    private final String $id;
                    @Nullable
                    private final Object $noncurrentVersionExpirationInDays;
                    @Nullable
                    private final Object $noncurrentVersionTransition;
                    @Nullable
                    private final Object $noncurrentVersionTransitions;
                    @Nullable
                    private final String $prefix;
                    @Nullable
                    private final Object $tagFilters;
                    @Nullable
                    private final Object $transition;
                    @Nullable
                    private final Object $transitions;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                        this.$abortIncompleteMultipartUpload = _abortIncompleteMultipartUpload;
                        this.$expirationDate = _expirationDate;
                        this.$expirationInDays = _expirationInDays;
                        this.$id = _id;
                        this.$noncurrentVersionExpirationInDays = _noncurrentVersionExpirationInDays;
                        this.$noncurrentVersionTransition = _noncurrentVersionTransition;
                        this.$noncurrentVersionTransitions = _noncurrentVersionTransitions;
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                        this.$transition = _transition;
                        this.$transitions = _transitions;
                    }

                    @Override
                    public String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public Object getAbortIncompleteMultipartUpload() {
                        return this.$abortIncompleteMultipartUpload;
                    }

                    @Override
                    public Object getExpirationDate() {
                        return this.$expirationDate;
                    }

                    @Override
                    public Object getExpirationInDays() {
                        return this.$expirationInDays;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public Object getNoncurrentVersionExpirationInDays() {
                        return this.$noncurrentVersionExpirationInDays;
                    }

                    @Override
                    public Object getNoncurrentVersionTransition() {
                        return this.$noncurrentVersionTransition;
                    }

                    @Override
                    public Object getNoncurrentVersionTransitions() {
                        return this.$noncurrentVersionTransitions;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public Object getTransition() {
                        return this.$transition;
                    }

                    @Override
                    public Object getTransitions() {
                        return this.$transitions;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree((Object)this.getStatus()));
                        obj.set("abortIncompleteMultipartUpload", om.valueToTree(this.getAbortIncompleteMultipartUpload()));
                        obj.set("expirationDate", om.valueToTree(this.getExpirationDate()));
                        obj.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                        obj.set("id", om.valueToTree((Object)this.getId()));
                        obj.set("noncurrentVersionExpirationInDays", om.valueToTree(this.getNoncurrentVersionExpirationInDays()));
                        obj.set("noncurrentVersionTransition", om.valueToTree(this.getNoncurrentVersionTransition()));
                        obj.set("noncurrentVersionTransitions", om.valueToTree(this.getNoncurrentVersionTransitions()));
                        obj.set("prefix", om.valueToTree((Object)this.getPrefix()));
                        obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        obj.set("transition", om.valueToTree(this.getTransition()));
                        obj.set("transitions", om.valueToTree(this.getTransitions()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface RoutingRuleProperty
    extends JsiiSerializable {
        public Object getRedirectRule();

        public Object getRoutingRuleCondition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _redirectRule;
            @Nullable
            private Object _routingRuleCondition;

            public Builder withRedirectRule(Token value) {
                this._redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }

            public Builder withRedirectRule(RedirectRuleProperty value) {
                this._redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }

            public Builder withRoutingRuleCondition(@Nullable Token value) {
                this._routingRuleCondition = value;
                return this;
            }

            public Builder withRoutingRuleCondition(@Nullable RoutingRuleConditionProperty value) {
                this._routingRuleCondition = value;
                return this;
            }

            public RoutingRuleProperty build() {
                return new RoutingRuleProperty(){
                    private final Object $redirectRule;
                    @Nullable
                    private final Object $routingRuleCondition;
                    {
                        this.$redirectRule = Objects.requireNonNull(_redirectRule, "redirectRule is required");
                        this.$routingRuleCondition = _routingRuleCondition;
                    }

                    @Override
                    public Object getRedirectRule() {
                        return this.$redirectRule;
                    }

                    @Override
                    public Object getRoutingRuleCondition() {
                        return this.$routingRuleCondition;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("redirectRule", om.valueToTree(this.getRedirectRule()));
                        obj.set("routingRuleCondition", om.valueToTree(this.getRoutingRuleCondition()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface RoutingRuleConditionProperty
    extends JsiiSerializable {
        public String getHttpErrorCodeReturnedEquals();

        public String getKeyPrefixEquals();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _httpErrorCodeReturnedEquals;
            @Nullable
            private String _keyPrefixEquals;

            public Builder withHttpErrorCodeReturnedEquals(@Nullable String value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }

            public Builder withKeyPrefixEquals(@Nullable String value) {
                this._keyPrefixEquals = value;
                return this;
            }

            public RoutingRuleConditionProperty build() {
                return new RoutingRuleConditionProperty(){
                    @Nullable
                    private final String $httpErrorCodeReturnedEquals;
                    @Nullable
                    private final String $keyPrefixEquals;
                    {
                        this.$httpErrorCodeReturnedEquals = _httpErrorCodeReturnedEquals;
                        this.$keyPrefixEquals = _keyPrefixEquals;
                    }

                    @Override
                    public String getHttpErrorCodeReturnedEquals() {
                        return this.$httpErrorCodeReturnedEquals;
                    }

                    @Override
                    public String getKeyPrefixEquals() {
                        return this.$keyPrefixEquals;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("httpErrorCodeReturnedEquals", om.valueToTree((Object)this.getHttpErrorCodeReturnedEquals()));
                        obj.set("keyPrefixEquals", om.valueToTree((Object)this.getKeyPrefixEquals()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ReplicationRuleProperty
    extends JsiiSerializable {
        public Object getDestination();

        public String getPrefix();

        public String getStatus();

        public String getId();

        public Object getSourceSelectionCriteria();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private String _prefix;
            private String _status;
            @Nullable
            private String _id;
            @Nullable
            private Object _sourceSelectionCriteria;

            public Builder withDestination(Token value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(ReplicationDestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withPrefix(String value) {
                this._prefix = Objects.requireNonNull(value, "prefix is required");
                return this;
            }

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withSourceSelectionCriteria(@Nullable Token value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            public Builder withSourceSelectionCriteria(@Nullable SourceSelectionCriteriaProperty value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            public ReplicationRuleProperty build() {
                return new ReplicationRuleProperty(){
                    private final Object $destination;
                    private final String $prefix;
                    private final String $status;
                    @Nullable
                    private final String $id;
                    @Nullable
                    private final Object $sourceSelectionCriteria;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$prefix = Objects.requireNonNull(_prefix, "prefix is required");
                        this.$status = Objects.requireNonNull(_status, "status is required");
                        this.$id = _id;
                        this.$sourceSelectionCriteria = _sourceSelectionCriteria;
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public Object getSourceSelectionCriteria() {
                        return this.$sourceSelectionCriteria;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("prefix", om.valueToTree((Object)this.getPrefix()));
                        obj.set("status", om.valueToTree((Object)this.getStatus()));
                        obj.set("id", om.valueToTree((Object)this.getId()));
                        obj.set("sourceSelectionCriteria", om.valueToTree(this.getSourceSelectionCriteria()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ReplicationDestinationProperty
    extends JsiiSerializable {
        public String getBucket();

        public Object getAccessControlTranslation();

        public String getAccount();

        public Object getEncryptionConfiguration();

        public String getStorageClass();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _bucket;
            @Nullable
            private Object _accessControlTranslation;
            @Nullable
            private String _account;
            @Nullable
            private Object _encryptionConfiguration;
            @Nullable
            private String _storageClass;

            public Builder withBucket(String value) {
                this._bucket = Objects.requireNonNull(value, "bucket is required");
                return this;
            }

            public Builder withAccessControlTranslation(@Nullable Token value) {
                this._accessControlTranslation = value;
                return this;
            }

            public Builder withAccessControlTranslation(@Nullable AccessControlTranslationProperty value) {
                this._accessControlTranslation = value;
                return this;
            }

            public Builder withAccount(@Nullable String value) {
                this._account = value;
                return this;
            }

            public Builder withEncryptionConfiguration(@Nullable Token value) {
                this._encryptionConfiguration = value;
                return this;
            }

            public Builder withEncryptionConfiguration(@Nullable EncryptionConfigurationProperty value) {
                this._encryptionConfiguration = value;
                return this;
            }

            public Builder withStorageClass(@Nullable String value) {
                this._storageClass = value;
                return this;
            }

            public ReplicationDestinationProperty build() {
                return new ReplicationDestinationProperty(){
                    private final String $bucket;
                    @Nullable
                    private final Object $accessControlTranslation;
                    @Nullable
                    private final String $account;
                    @Nullable
                    private final Object $encryptionConfiguration;
                    @Nullable
                    private final String $storageClass;
                    {
                        this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                        this.$accessControlTranslation = _accessControlTranslation;
                        this.$account = _account;
                        this.$encryptionConfiguration = _encryptionConfiguration;
                        this.$storageClass = _storageClass;
                    }

                    @Override
                    public String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public Object getAccessControlTranslation() {
                        return this.$accessControlTranslation;
                    }

                    @Override
                    public String getAccount() {
                        return this.$account;
                    }

                    @Override
                    public Object getEncryptionConfiguration() {
                        return this.$encryptionConfiguration;
                    }

                    @Override
                    public String getStorageClass() {
                        return this.$storageClass;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree((Object)this.getBucket()));
                        obj.set("accessControlTranslation", om.valueToTree(this.getAccessControlTranslation()));
                        obj.set("account", om.valueToTree((Object)this.getAccount()));
                        obj.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                        obj.set("storageClass", om.valueToTree((Object)this.getStorageClass()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ReplicationConfigurationProperty
    extends JsiiSerializable {
        public String getRole();

        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _role;
            private Object _rules;

            public Builder withRole(String value) {
                this._role = Objects.requireNonNull(value, "role is required");
                return this;
            }

            public Builder withRules(Token value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public ReplicationConfigurationProperty build() {
                return new ReplicationConfigurationProperty(){
                    private final String $role;
                    private final Object $rules;
                    {
                        this.$role = Objects.requireNonNull(_role, "role is required");
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public String getRole() {
                        return this.$role;
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface RedirectRuleProperty
    extends JsiiSerializable {
        public String getHostName();

        public String getHttpRedirectCode();

        public String getProtocol();

        public String getReplaceKeyPrefixWith();

        public String getReplaceKeyWith();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _hostName;
            @Nullable
            private String _httpRedirectCode;
            @Nullable
            private String _protocol;
            @Nullable
            private String _replaceKeyPrefixWith;
            @Nullable
            private String _replaceKeyWith;

            public Builder withHostName(@Nullable String value) {
                this._hostName = value;
                return this;
            }

            public Builder withHttpRedirectCode(@Nullable String value) {
                this._httpRedirectCode = value;
                return this;
            }

            public Builder withProtocol(@Nullable String value) {
                this._protocol = value;
                return this;
            }

            public Builder withReplaceKeyPrefixWith(@Nullable String value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }

            public Builder withReplaceKeyWith(@Nullable String value) {
                this._replaceKeyWith = value;
                return this;
            }

            public RedirectRuleProperty build() {
                return new RedirectRuleProperty(){
                    @Nullable
                    private final String $hostName;
                    @Nullable
                    private final String $httpRedirectCode;
                    @Nullable
                    private final String $protocol;
                    @Nullable
                    private final String $replaceKeyPrefixWith;
                    @Nullable
                    private final String $replaceKeyWith;
                    {
                        this.$hostName = _hostName;
                        this.$httpRedirectCode = _httpRedirectCode;
                        this.$protocol = _protocol;
                        this.$replaceKeyPrefixWith = _replaceKeyPrefixWith;
                        this.$replaceKeyWith = _replaceKeyWith;
                    }

                    @Override
                    public String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public String getHttpRedirectCode() {
                        return this.$httpRedirectCode;
                    }

                    @Override
                    public String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public String getReplaceKeyPrefixWith() {
                        return this.$replaceKeyPrefixWith;
                    }

                    @Override
                    public String getReplaceKeyWith() {
                        return this.$replaceKeyWith;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("hostName", om.valueToTree((Object)this.getHostName()));
                        obj.set("httpRedirectCode", om.valueToTree((Object)this.getHttpRedirectCode()));
                        obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                        obj.set("replaceKeyPrefixWith", om.valueToTree((Object)this.getReplaceKeyPrefixWith()));
                        obj.set("replaceKeyWith", om.valueToTree((Object)this.getReplaceKeyWith()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface RedirectAllRequestsToProperty
    extends JsiiSerializable {
        public String getHostName();

        public String getProtocol();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _hostName;
            @Nullable
            private String _protocol;

            public Builder withHostName(String value) {
                this._hostName = Objects.requireNonNull(value, "hostName is required");
                return this;
            }

            public Builder withProtocol(@Nullable String value) {
                this._protocol = value;
                return this;
            }

            public RedirectAllRequestsToProperty build() {
                return new RedirectAllRequestsToProperty(){
                    private final String $hostName;
                    @Nullable
                    private final String $protocol;
                    {
                        this.$hostName = Objects.requireNonNull(_hostName, "hostName is required");
                        this.$protocol = _protocol;
                    }

                    @Override
                    public String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public String getProtocol() {
                        return this.$protocol;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("hostName", om.valueToTree((Object)this.getHostName()));
                        obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface QueueConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public String getQueue();

        public Object getFilter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _event;
            private String _queue;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withQueue(String value) {
                this._queue = Objects.requireNonNull(value, "queue is required");
                return this;
            }

            public Builder withFilter(@Nullable Token value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public QueueConfigurationProperty build() {
                return new QueueConfigurationProperty(){
                    private final String $event;
                    private final String $queue;
                    @Nullable
                    private final Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$queue = Objects.requireNonNull(_queue, "queue is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public String getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree((Object)this.getEvent()));
                        obj.set("queue", om.valueToTree((Object)this.getQueue()));
                        obj.set("filter", om.valueToTree(this.getFilter()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface PublicAccessBlockConfigurationProperty
    extends JsiiSerializable {
        public Object getBlockPublicAcls();

        public Object getBlockPublicPolicy();

        public Object getIgnorePublicAcls();

        public Object getRestrictPublicBuckets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _blockPublicAcls;
            @Nullable
            private Object _blockPublicPolicy;
            @Nullable
            private Object _ignorePublicAcls;
            @Nullable
            private Object _restrictPublicBuckets;

            public Builder withBlockPublicAcls(@Nullable Boolean value) {
                this._blockPublicAcls = value;
                return this;
            }

            public Builder withBlockPublicAcls(@Nullable Token value) {
                this._blockPublicAcls = value;
                return this;
            }

            public Builder withBlockPublicPolicy(@Nullable Boolean value) {
                this._blockPublicPolicy = value;
                return this;
            }

            public Builder withBlockPublicPolicy(@Nullable Token value) {
                this._blockPublicPolicy = value;
                return this;
            }

            public Builder withIgnorePublicAcls(@Nullable Boolean value) {
                this._ignorePublicAcls = value;
                return this;
            }

            public Builder withIgnorePublicAcls(@Nullable Token value) {
                this._ignorePublicAcls = value;
                return this;
            }

            public Builder withRestrictPublicBuckets(@Nullable Boolean value) {
                this._restrictPublicBuckets = value;
                return this;
            }

            public Builder withRestrictPublicBuckets(@Nullable Token value) {
                this._restrictPublicBuckets = value;
                return this;
            }

            public PublicAccessBlockConfigurationProperty build() {
                return new PublicAccessBlockConfigurationProperty(){
                    @Nullable
                    private final Object $blockPublicAcls;
                    @Nullable
                    private final Object $blockPublicPolicy;
                    @Nullable
                    private final Object $ignorePublicAcls;
                    @Nullable
                    private final Object $restrictPublicBuckets;
                    {
                        this.$blockPublicAcls = _blockPublicAcls;
                        this.$blockPublicPolicy = _blockPublicPolicy;
                        this.$ignorePublicAcls = _ignorePublicAcls;
                        this.$restrictPublicBuckets = _restrictPublicBuckets;
                    }

                    @Override
                    public Object getBlockPublicAcls() {
                        return this.$blockPublicAcls;
                    }

                    @Override
                    public Object getBlockPublicPolicy() {
                        return this.$blockPublicPolicy;
                    }

                    @Override
                    public Object getIgnorePublicAcls() {
                        return this.$ignorePublicAcls;
                    }

                    @Override
                    public Object getRestrictPublicBuckets() {
                        return this.$restrictPublicBuckets;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                        obj.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                        obj.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                        obj.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface NotificationFilterProperty
    extends JsiiSerializable {
        public Object getS3Key();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _s3Key;

            public Builder withS3Key(Token value) {
                this._s3Key = Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            public Builder withS3Key(S3KeyFilterProperty value) {
                this._s3Key = Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            public NotificationFilterProperty build() {
                return new NotificationFilterProperty(){
                    private final Object $s3Key;
                    {
                        this.$s3Key = Objects.requireNonNull(_s3Key, "s3Key is required");
                    }

                    @Override
                    public Object getS3Key() {
                        return this.$s3Key;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("s3Key", om.valueToTree(this.getS3Key()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        public Object getLambdaConfigurations();

        public Object getQueueConfigurations();

        public Object getTopicConfigurations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _lambdaConfigurations;
            @Nullable
            private Object _queueConfigurations;
            @Nullable
            private Object _topicConfigurations;

            public Builder withLambdaConfigurations(@Nullable Token value) {
                this._lambdaConfigurations = value;
                return this;
            }

            public Builder withLambdaConfigurations(@Nullable List<Object> value) {
                this._lambdaConfigurations = value;
                return this;
            }

            public Builder withQueueConfigurations(@Nullable Token value) {
                this._queueConfigurations = value;
                return this;
            }

            public Builder withQueueConfigurations(@Nullable List<Object> value) {
                this._queueConfigurations = value;
                return this;
            }

            public Builder withTopicConfigurations(@Nullable Token value) {
                this._topicConfigurations = value;
                return this;
            }

            public Builder withTopicConfigurations(@Nullable List<Object> value) {
                this._topicConfigurations = value;
                return this;
            }

            public NotificationConfigurationProperty build() {
                return new NotificationConfigurationProperty(){
                    @Nullable
                    private final Object $lambdaConfigurations;
                    @Nullable
                    private final Object $queueConfigurations;
                    @Nullable
                    private final Object $topicConfigurations;
                    {
                        this.$lambdaConfigurations = _lambdaConfigurations;
                        this.$queueConfigurations = _queueConfigurations;
                        this.$topicConfigurations = _topicConfigurations;
                    }

                    @Override
                    public Object getLambdaConfigurations() {
                        return this.$lambdaConfigurations;
                    }

                    @Override
                    public Object getQueueConfigurations() {
                        return this.$queueConfigurations;
                    }

                    @Override
                    public Object getTopicConfigurations() {
                        return this.$topicConfigurations;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("lambdaConfigurations", om.valueToTree(this.getLambdaConfigurations()));
                        obj.set("queueConfigurations", om.valueToTree(this.getQueueConfigurations()));
                        obj.set("topicConfigurations", om.valueToTree(this.getTopicConfigurations()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface NoncurrentVersionTransitionProperty
    extends JsiiSerializable {
        public String getStorageClass();

        public Object getTransitionInDays();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _storageClass;
            private Object _transitionInDays;

            public Builder withStorageClass(String value) {
                this._storageClass = Objects.requireNonNull(value, "storageClass is required");
                return this;
            }

            public Builder withTransitionInDays(Number value) {
                this._transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            public Builder withTransitionInDays(Token value) {
                this._transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            public NoncurrentVersionTransitionProperty build() {
                return new NoncurrentVersionTransitionProperty(){
                    private final String $storageClass;
                    private final Object $transitionInDays;
                    {
                        this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                        this.$transitionInDays = Objects.requireNonNull(_transitionInDays, "transitionInDays is required");
                    }

                    @Override
                    public String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("storageClass", om.valueToTree((Object)this.getStorageClass()));
                        obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface MetricsConfigurationProperty
    extends JsiiSerializable {
        public String getId();

        public String getPrefix();

        public Object getTagFilters();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _id;
            @Nullable
            private String _prefix;
            @Nullable
            private Object _tagFilters;

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable Token value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public MetricsConfigurationProperty build() {
                return new MetricsConfigurationProperty(){
                    private final String $id;
                    @Nullable
                    private final String $prefix;
                    @Nullable
                    private final Object $tagFilters;
                    {
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("id", om.valueToTree((Object)this.getId()));
                        obj.set("prefix", om.valueToTree((Object)this.getPrefix()));
                        obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        public String getDestinationBucketName();

        public String getLogFilePrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _destinationBucketName;
            @Nullable
            private String _logFilePrefix;

            public Builder withDestinationBucketName(@Nullable String value) {
                this._destinationBucketName = value;
                return this;
            }

            public Builder withLogFilePrefix(@Nullable String value) {
                this._logFilePrefix = value;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new LoggingConfigurationProperty(){
                    @Nullable
                    private final String $destinationBucketName;
                    @Nullable
                    private final String $logFilePrefix;
                    {
                        this.$destinationBucketName = _destinationBucketName;
                        this.$logFilePrefix = _logFilePrefix;
                    }

                    @Override
                    public String getDestinationBucketName() {
                        return this.$destinationBucketName;
                    }

                    @Override
                    public String getLogFilePrefix() {
                        return this.$logFilePrefix;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("destinationBucketName", om.valueToTree((Object)this.getDestinationBucketName()));
                        obj.set("logFilePrefix", om.valueToTree((Object)this.getLogFilePrefix()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface LifecycleConfigurationProperty
    extends JsiiSerializable {
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _rules;

            public Builder withRules(Token value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public LifecycleConfigurationProperty build() {
                return new LifecycleConfigurationProperty(){
                    private final Object $rules;
                    {
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface LambdaConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public String getFunction();

        public Object getFilter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _event;
            private String _function;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withFunction(String value) {
                this._function = Objects.requireNonNull(value, "function is required");
                return this;
            }

            public Builder withFilter(@Nullable Token value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public LambdaConfigurationProperty build() {
                return new LambdaConfigurationProperty(){
                    private final String $event;
                    private final String $function;
                    @Nullable
                    private final Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$function = Objects.requireNonNull(_function, "function is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public String getFunction() {
                        return this.$function;
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree((Object)this.getEvent()));
                        obj.set("function", om.valueToTree((Object)this.getFunction()));
                        obj.set("filter", om.valueToTree(this.getFilter()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface InventoryConfigurationProperty
    extends JsiiSerializable {
        public Object getDestination();

        public Object getEnabled();

        public String getId();

        public String getIncludedObjectVersions();

        public String getScheduleFrequency();

        public List<String> getOptionalFields();

        public String getPrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private Object _enabled;
            private String _id;
            private String _includedObjectVersions;
            private String _scheduleFrequency;
            @Nullable
            private List<String> _optionalFields;
            @Nullable
            private String _prefix;

            public Builder withDestination(Token value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(DestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withEnabled(Boolean value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withEnabled(Token value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withIncludedObjectVersions(String value) {
                this._includedObjectVersions = Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }

            public Builder withScheduleFrequency(String value) {
                this._scheduleFrequency = Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }

            public Builder withOptionalFields(@Nullable List<String> value) {
                this._optionalFields = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public InventoryConfigurationProperty build() {
                return new InventoryConfigurationProperty(){
                    private final Object $destination;
                    private final Object $enabled;
                    private final String $id;
                    private final String $includedObjectVersions;
                    private final String $scheduleFrequency;
                    @Nullable
                    private final List<String> $optionalFields;
                    @Nullable
                    private final String $prefix;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$enabled = Objects.requireNonNull(_enabled, "enabled is required");
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$includedObjectVersions = Objects.requireNonNull(_includedObjectVersions, "includedObjectVersions is required");
                        this.$scheduleFrequency = Objects.requireNonNull(_scheduleFrequency, "scheduleFrequency is required");
                        this.$optionalFields = _optionalFields;
                        this.$prefix = _prefix;
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public String getIncludedObjectVersions() {
                        return this.$includedObjectVersions;
                    }

                    @Override
                    public String getScheduleFrequency() {
                        return this.$scheduleFrequency;
                    }

                    @Override
                    public List<String> getOptionalFields() {
                        return this.$optionalFields;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        obj.set("id", om.valueToTree((Object)this.getId()));
                        obj.set("includedObjectVersions", om.valueToTree((Object)this.getIncludedObjectVersions()));
                        obj.set("scheduleFrequency", om.valueToTree((Object)this.getScheduleFrequency()));
                        obj.set("optionalFields", om.valueToTree(this.getOptionalFields()));
                        obj.set("prefix", om.valueToTree((Object)this.getPrefix()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface FilterRuleProperty
    extends JsiiSerializable {
        public String getName();

        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _name;
            private String _value;

            public Builder withName(String value) {
                this._name = Objects.requireNonNull(value, "name is required");
                return this;
            }

            public Builder withValue(String value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public FilterRuleProperty build() {
                return new FilterRuleProperty(){
                    private final String $name;
                    private final String $value;
                    {
                        this.$name = Objects.requireNonNull(_name, "name is required");
                        this.$value = Objects.requireNonNull(_value, "value is required");
                    }

                    @Override
                    public String getName() {
                        return this.$name;
                    }

                    @Override
                    public String getValue() {
                        return this.$value;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree((Object)this.getName()));
                        obj.set("value", om.valueToTree((Object)this.getValue()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        public String getReplicaKmsKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _replicaKmsKeyId;

            public Builder withReplicaKmsKeyId(String value) {
                this._replicaKmsKeyId = Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new EncryptionConfigurationProperty(){
                    private final String $replicaKmsKeyId;
                    {
                        this.$replicaKmsKeyId = Objects.requireNonNull(_replicaKmsKeyId, "replicaKmsKeyId is required");
                    }

                    @Override
                    public String getReplicaKmsKeyId() {
                        return this.$replicaKmsKeyId;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("replicaKmsKeyId", om.valueToTree((Object)this.getReplicaKmsKeyId()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface DestinationProperty
    extends JsiiSerializable {
        public String getBucketArn();

        public String getFormat();

        public String getBucketAccountId();

        public String getPrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _bucketArn;
            private String _format;
            @Nullable
            private String _bucketAccountId;
            @Nullable
            private String _prefix;

            public Builder withBucketArn(String value) {
                this._bucketArn = Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }

            public Builder withFormat(String value) {
                this._format = Objects.requireNonNull(value, "format is required");
                return this;
            }

            public Builder withBucketAccountId(@Nullable String value) {
                this._bucketAccountId = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public DestinationProperty build() {
                return new DestinationProperty(){
                    private final String $bucketArn;
                    private final String $format;
                    @Nullable
                    private final String $bucketAccountId;
                    @Nullable
                    private final String $prefix;
                    {
                        this.$bucketArn = Objects.requireNonNull(_bucketArn, "bucketArn is required");
                        this.$format = Objects.requireNonNull(_format, "format is required");
                        this.$bucketAccountId = _bucketAccountId;
                        this.$prefix = _prefix;
                    }

                    @Override
                    public String getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public String getFormat() {
                        return this.$format;
                    }

                    @Override
                    public String getBucketAccountId() {
                        return this.$bucketAccountId;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("bucketArn", om.valueToTree((Object)this.getBucketArn()));
                        obj.set("format", om.valueToTree((Object)this.getFormat()));
                        obj.set("bucketAccountId", om.valueToTree((Object)this.getBucketAccountId()));
                        obj.set("prefix", om.valueToTree((Object)this.getPrefix()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface DataExportProperty
    extends JsiiSerializable {
        public Object getDestination();

        public String getOutputSchemaVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private String _outputSchemaVersion;

            public Builder withDestination(Token value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(DestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withOutputSchemaVersion(String value) {
                this._outputSchemaVersion = Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }

            public DataExportProperty build() {
                return new DataExportProperty(){
                    private final Object $destination;
                    private final String $outputSchemaVersion;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$outputSchemaVersion = Objects.requireNonNull(_outputSchemaVersion, "outputSchemaVersion is required");
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public String getOutputSchemaVersion() {
                        return this.$outputSchemaVersion;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("outputSchemaVersion", om.valueToTree((Object)this.getOutputSchemaVersion()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CorsRuleProperty
    extends JsiiSerializable {
        public List<String> getAllowedMethods();

        public List<String> getAllowedOrigins();

        public List<String> getAllowedHeaders();

        public List<String> getExposedHeaders();

        public String getId();

        public Object getMaxAge();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> _allowedMethods;
            private List<String> _allowedOrigins;
            @Nullable
            private List<String> _allowedHeaders;
            @Nullable
            private List<String> _exposedHeaders;
            @Nullable
            private String _id;
            @Nullable
            private Object _maxAge;

            public Builder withAllowedMethods(List<String> value) {
                this._allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }

            public Builder withAllowedOrigins(List<String> value) {
                this._allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }

            public Builder withAllowedHeaders(@Nullable List<String> value) {
                this._allowedHeaders = value;
                return this;
            }

            public Builder withExposedHeaders(@Nullable List<String> value) {
                this._exposedHeaders = value;
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withMaxAge(@Nullable Number value) {
                this._maxAge = value;
                return this;
            }

            public Builder withMaxAge(@Nullable Token value) {
                this._maxAge = value;
                return this;
            }

            public CorsRuleProperty build() {
                return new CorsRuleProperty(){
                    private final List<String> $allowedMethods;
                    private final List<String> $allowedOrigins;
                    @Nullable
                    private final List<String> $allowedHeaders;
                    @Nullable
                    private final List<String> $exposedHeaders;
                    @Nullable
                    private final String $id;
                    @Nullable
                    private final Object $maxAge;
                    {
                        this.$allowedMethods = Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                        this.$allowedOrigins = Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                        this.$allowedHeaders = _allowedHeaders;
                        this.$exposedHeaders = _exposedHeaders;
                        this.$id = _id;
                        this.$maxAge = _maxAge;
                    }

                    @Override
                    public List<String> getAllowedMethods() {
                        return this.$allowedMethods;
                    }

                    @Override
                    public List<String> getAllowedOrigins() {
                        return this.$allowedOrigins;
                    }

                    @Override
                    public List<String> getAllowedHeaders() {
                        return this.$allowedHeaders;
                    }

                    @Override
                    public List<String> getExposedHeaders() {
                        return this.$exposedHeaders;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public Object getMaxAge() {
                        return this.$maxAge;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                        obj.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                        obj.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                        obj.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
                        obj.set("id", om.valueToTree((Object)this.getId()));
                        obj.set("maxAge", om.valueToTree(this.getMaxAge()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        public Object getCorsRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _corsRules;

            public Builder withCorsRules(Token value) {
                this._corsRules = Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            public Builder withCorsRules(List<Object> value) {
                this._corsRules = Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            public CorsConfigurationProperty build() {
                return new CorsConfigurationProperty(){
                    private final Object $corsRules;
                    {
                        this.$corsRules = Objects.requireNonNull(_corsRules, "corsRules is required");
                    }

                    @Override
                    public Object getCorsRules() {
                        return this.$corsRules;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("corsRules", om.valueToTree(this.getCorsRules()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface BucketEncryptionProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _serverSideEncryptionConfiguration;

            public Builder withServerSideEncryptionConfiguration(Token value) {
                this._serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            public Builder withServerSideEncryptionConfiguration(List<Object> value) {
                this._serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            public BucketEncryptionProperty build() {
                return new BucketEncryptionProperty(){
                    private final Object $serverSideEncryptionConfiguration;
                    {
                        this.$serverSideEncryptionConfiguration = Objects.requireNonNull(_serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");
                    }

                    @Override
                    public Object getServerSideEncryptionConfiguration() {
                        return this.$serverSideEncryptionConfiguration;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface AnalyticsConfigurationProperty
    extends JsiiSerializable {
        public String getId();

        public Object getStorageClassAnalysis();

        public String getPrefix();

        public Object getTagFilters();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _id;
            private Object _storageClassAnalysis;
            @Nullable
            private String _prefix;
            @Nullable
            private Object _tagFilters;

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withStorageClassAnalysis(Token value) {
                this._storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }

            public Builder withStorageClassAnalysis(StorageClassAnalysisProperty value) {
                this._storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable Token value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public AnalyticsConfigurationProperty build() {
                return new AnalyticsConfigurationProperty(){
                    private final String $id;
                    private final Object $storageClassAnalysis;
                    @Nullable
                    private final String $prefix;
                    @Nullable
                    private final Object $tagFilters;
                    {
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$storageClassAnalysis = Objects.requireNonNull(_storageClassAnalysis, "storageClassAnalysis is required");
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public Object getStorageClassAnalysis() {
                        return this.$storageClassAnalysis;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("id", om.valueToTree((Object)this.getId()));
                        obj.set("storageClassAnalysis", om.valueToTree(this.getStorageClassAnalysis()));
                        obj.set("prefix", om.valueToTree((Object)this.getPrefix()));
                        obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface AccessControlTranslationProperty
    extends JsiiSerializable {
        public String getOwner();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _owner;

            public Builder withOwner(String value) {
                this._owner = Objects.requireNonNull(value, "owner is required");
                return this;
            }

            public AccessControlTranslationProperty build() {
                return new AccessControlTranslationProperty(){
                    private final String $owner;
                    {
                        this.$owner = Objects.requireNonNull(_owner, "owner is required");
                    }

                    @Override
                    public String getOwner() {
                        return this.$owner;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("owner", om.valueToTree((Object)this.getOwner()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface AccelerateConfigurationProperty
    extends JsiiSerializable {
        public String getAccelerationStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _accelerationStatus;

            public Builder withAccelerationStatus(String value) {
                this._accelerationStatus = Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }

            public AccelerateConfigurationProperty build() {
                return new AccelerateConfigurationProperty(){
                    private final String $accelerationStatus;
                    {
                        this.$accelerationStatus = Objects.requireNonNull(_accelerationStatus, "accelerationStatus is required");
                    }

                    @Override
                    public String getAccelerationStatus() {
                        return this.$accelerationStatus;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("accelerationStatus", om.valueToTree((Object)this.getAccelerationStatus()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface AbortIncompleteMultipartUploadProperty
    extends JsiiSerializable {
        public Object getDaysAfterInitiation();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _daysAfterInitiation;

            public Builder withDaysAfterInitiation(Number value) {
                this._daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            public Builder withDaysAfterInitiation(Token value) {
                this._daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            public AbortIncompleteMultipartUploadProperty build() {
                return new AbortIncompleteMultipartUploadProperty(){
                    private final Object $daysAfterInitiation;
                    {
                        this.$daysAfterInitiation = Objects.requireNonNull(_daysAfterInitiation, "daysAfterInitiation is required");
                    }

                    @Override
                    public Object getDaysAfterInitiation() {
                        return this.$daysAfterInitiation;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("daysAfterInitiation", om.valueToTree(this.getDaysAfterInitiation()));
                        return obj;
                    }
                };
            }
        }
    }
}

