/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codepipeline.api.Artifact;
import software.amazon.awscdk.services.codepipeline.api.CommonActionConstructProps;
import software.amazon.awscdk.services.codepipeline.api.IStage;
import software.amazon.awscdk.services.s3.CommonPipelineDeployActionProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineDeployActionProps
extends JsiiSerializable,
CommonPipelineDeployActionProps,
CommonActionConstructProps {
    public IBucket getBucket();

    public void setBucket(IBucket var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _bucket;
        @Nullable
        private Boolean _extract;
        @Nullable
        private Artifact _inputArtifact;
        @Nullable
        private String _objectKey;
        @Nullable
        private Number _runOrder;
        private IStage _stage;

        public Builder withBucket(IBucket value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withExtract(@Nullable Boolean value) {
            this._extract = value;
            return this;
        }

        public Builder withInputArtifact(@Nullable Artifact value) {
            this._inputArtifact = value;
            return this;
        }

        public Builder withObjectKey(@Nullable String value) {
            this._objectKey = value;
            return this;
        }

        public Builder withRunOrder(@Nullable Number value) {
            this._runOrder = value;
            return this;
        }

        public Builder withStage(IStage value) {
            this._stage = Objects.requireNonNull(value, "stage is required");
            return this;
        }

        public PipelineDeployActionProps build() {
            return new PipelineDeployActionProps(){
                private IBucket $bucket;
                @Nullable
                private Boolean $extract;
                @Nullable
                private Artifact $inputArtifact;
                @Nullable
                private String $objectKey;
                @Nullable
                private Number $runOrder;
                private IStage $stage;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$extract = _extract;
                    this.$inputArtifact = _inputArtifact;
                    this.$objectKey = _objectKey;
                    this.$runOrder = _runOrder;
                    this.$stage = Objects.requireNonNull(_stage, "stage is required");
                }

                @Override
                public IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(IBucket value) {
                    this.$bucket = Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public Boolean getExtract() {
                    return this.$extract;
                }

                @Override
                public void setExtract(@Nullable Boolean value) {
                    this.$extract = value;
                }

                @Override
                public Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(@Nullable Artifact value) {
                    this.$inputArtifact = value;
                }

                @Override
                public String getObjectKey() {
                    return this.$objectKey;
                }

                @Override
                public void setObjectKey(@Nullable String value) {
                    this.$objectKey = value;
                }

                public Number getRunOrder() {
                    return this.$runOrder;
                }

                public void setRunOrder(@Nullable Number value) {
                    this.$runOrder = value;
                }

                public IStage getStage() {
                    return this.$stage;
                }

                public void setStage(IStage value) {
                    this.$stage = Objects.requireNonNull(value, "stage is required");
                }
            };
        }
    }
}

