/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.deployment;

import java.util.List;
import software.amazon.awscdk.services.cloudfront.IDistribution;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps;
import software.amazon.awscdk.services.s3.deployment.ISource;
import software.amazon.jsii.JsiiSerializable;

public interface BucketDeploymentProps
extends JsiiSerializable {
    public IBucket getDestinationBucket();

    public List<ISource> getSources();

    public String getDestinationKeyPrefix();

    public IDistribution getDistribution();

    public List<String> getDistributionPaths();

    public Boolean getRetainOnDelete();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket destinationBucket;
        private List<ISource> sources;
        private String destinationKeyPrefix;
        private IDistribution distribution;
        private List<String> distributionPaths;
        private Boolean retainOnDelete;

        public Builder destinationBucket(IBucket destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        public Builder sources(List<ISource> sources) {
            this.sources = sources;
            return this;
        }

        public Builder destinationKeyPrefix(String destinationKeyPrefix) {
            this.destinationKeyPrefix = destinationKeyPrefix;
            return this;
        }

        public Builder distribution(IDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public Builder distributionPaths(List<String> distributionPaths) {
            this.distributionPaths = distributionPaths;
            return this;
        }

        public Builder retainOnDelete(Boolean retainOnDelete) {
            this.retainOnDelete = retainOnDelete;
            return this;
        }

        public BucketDeploymentProps build() {
            return new Jsii.Proxy(this.destinationBucket, this.sources, this.destinationKeyPrefix, this.distribution, this.distributionPaths, this.retainOnDelete, null);
        }
    }
}

