/**
 * <h2>AWS S3 Deployment Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development. They are subject to non-backward compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be announced in the release notes. This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER--><blockquote>
 * <p>
 * <strong>Status: Experimental</strong>
 * <p>
 * </blockquote>
 * <p>
 * This library allows populating an S3 bucket with the contents of .zip files
 * from other S3 buckets or from local disk.
 * <p>
 * The following example defines a publicly accessible S3 bucket with web hosting
 * enabled and populates it from a local directory on disk.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var websiteBucket = Bucket.Builder.create(this, "WebsiteBucket")
 *         .websiteIndexDocument("index.html")
 *         .publicReadAccess(true)
 *         .build();
 * 
 * BucketDeployment.Builder.create(this, "DeployWebsite")
 *         .sources(asList(s3deploy.Source.asset("./website-dist")))
 *         .destinationBucket(websiteBucket)
 *         .destinationKeyPrefix("web/static")
 *         .build();
 * </pre></blockquote>
 * <p>
 * This is what happens under the hood:
 * <p>
 * <ol>
 * <li>When this stack is deployed (either via <code>cdk deploy</code> or via CI/CD), the
 * contents of the local <code>website-dist</code> directory will be archived and uploaded
 * to an intermediary assets bucket. If there is more than one source, they will
 * be individually uploaded.</li>
 * <li>The <code>BucketDeployment</code> construct synthesizes a custom CloudFormation resource
 * of type <code>Custom::CDKBucketDeployment</code> into the template. The source bucket/key
 * is set to point to the assets bucket.</li>
 * <li>The custom resource downloads the .zip archive, extracts it and issues <code>aws s3 sync --delete</code> against the destination bucket (in this case
 * <code>websiteBucket</code>). If there is more than one source, the sources will be
 * downloaded and merged pre-deployment at this step.</li>
 * </ol>
 * <p>
 * <h2>Supported sources</h2>
 * <p>
 * The following source types are supported for bucket deployments:
 * <p>
 * <ul>
 * <li>Local .zip file: <code>s3deploy.Source.asset('/path/to/local/file.zip')</code></li>
 * <li>Local directory: <code>s3deploy.Source.asset('/path/to/local/directory')</code></li>
 * <li>Another bucket: <code>s3deploy.Source.bucket(bucket, zipObjectKey)</code></li>
 * </ul>
 * <p>
 * To create a source from a single file, you can pass <code>AssetOptions</code> to exclude
 * all but a single file:
 * <p>
 * <ul>
 * <li>Single file: <code>s3deploy.Source.asset('/path/to/local/directory', { exclude: ['**', '!onlyThisFile.txt'] })</code></li>
 * </ul>
 * <p>
 * <h2>Retain on Delete</h2>
 * <p>
 * By default, the contents of the destination bucket will <strong>not</strong> be deleted when the
 * <code>BucketDeployment</code> resource is removed from the stack or when the destination is
 * changed. You can use the option <code>retainOnDelete: false</code> to disable this behavior,
 * in which case the contents will be deleted.
 * <p>
 * <h2>Prune</h2>
 * <p>
 * By default, files in the destination bucket that don't exist in the source will be deleted
 * when the <code>BucketDeployment</code> resource is created or updated. You can use the option <code>prune: false</code> to disable
 * this behavior, in which case the files will not be deleted.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * BucketDeployment.Builder.create(this, "DeployMeWithoutDeletingFilesOnDestination")
 *         .sources(asList(s3deploy.Source.asset(path.join(__dirname, "my-website"))))
 *         .destinationBucket(destinationBucket)
 *         .prune(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * This option also enables you to specify multiple bucket deployments for the same destination bucket &amp; prefix,
 * each with its own characteristics. For example, you can set different cache-control headers
 * based on file extensions:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * BucketDeployment.Builder.create(this, "BucketDeployment")
 *         .sources(asList(Source.asset("./website", Map.of("exclude", asList("index.html")))))
 *         .destinationBucket(bucket)
 *         .cacheControl(asList(CacheControl.fromString("max-age=31536000,public,immutable")))
 *         .prune(false)
 *         .build();
 * 
 * BucketDeployment.Builder.create(this, "HTMLBucketDeployment")
 *         .sources(asList(Source.asset("./website", Map.of("exclude", asList("*", "!index.html")))))
 *         .destinationBucket(bucket)
 *         .cacheControl(asList(CacheControl.fromString("max-age=0,no-cache,no-store,must-revalidate")))
 *         .prune(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Objects metadata</h2>
 * <p>
 * You can specify metadata to be set on all the objects in your deployment.
 * There are 2 types of metadata in S3: system-defined metadata and user-defined metadata.
 * System-defined metadata have a special purpose, for example cache-control defines how long to keep an object cached.
 * User-defined metadata are not used by S3 and keys always begin with <code>x-amzn-meta-</code> (if this is not provided, it is added automatically).
 * <p>
 * System defined metadata keys include the following:
 * <p>
 * <ul>
 * <li>cache-control</li>
 * <li>content-disposition</li>
 * <li>content-encoding</li>
 * <li>content-language</li>
 * <li>content-type</li>
 * <li>expires</li>
 * <li>server-side-encryption</li>
 * <li>storage-class</li>
 * <li>website-redirect-location</li>
 * <li>ssekms-key-id</li>
 * <li>sse-customer-algorithm</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var websiteBucket = Bucket.Builder.create(this, "WebsiteBucket")
 *         .websiteIndexDocument("index.html")
 *         .publicReadAccess(true)
 *         .build();
 * 
 * BucketDeployment.Builder.create(this, "DeployWebsite")
 *         .sources(asList(s3deploy.Source.asset("./website-dist")))
 *         .destinationBucket(websiteBucket)
 *         .destinationKeyPrefix("web/static")// optional prefix in destination bucket
 *         .metadata(Map.of("A", "1", "b", "2"))// user-defined metadata
 * 
 *         // system-defined metadata
 *         .contentType("text/html")
 *         .contentLanguage("en")
 *         .storageClass(StorageClass.getINTELLIGENT_TIERING())
 *         .serverSideEncryption(ServerSideEncryption.getAES_256())
 *         .cacheControl(asList(CacheControl.setPublic(), CacheControl.maxAge(cdk.Duration.hours(1))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>CloudFront Invalidation</h2>
 * <p>
 * You can provide a CloudFront distribution and optional paths to invalidate after the bucket deployment finishes.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = new Bucket(this, "Destination");
 * 
 * var distribution = CloudFrontWebDistribution.Builder.create(this, "Distribution")
 *         .originConfigs(asList(Map.of(
 *                 "s3OriginSource", Map.of(
 *                         "s3BucketSource", bucket),
 *                 "behaviors", asList(Map.of("isDefaultBehavior", true)))))
 *         .build();
 * 
 * BucketDeployment.Builder.create(this, "DeployWithInvalidation")
 *         .sources(asList(s3deploy.Source.asset("./website-dist")))
 *         .destinationBucket(bucket)
 *         .distribution(distribution)
 *         .distributionPaths(asList("/images/*.png"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Memory Limit</h2>
 * <p>
 * The default memory limit for the deployment resource is 128MiB. If you need to
 * copy larger files, you can use the <code>memoryLimit</code> configuration to specify the
 * size of the AWS Lambda resource handler.
 * <p>
 * <blockquote>
 * <p>
 * NOTE: a new AWS Lambda handler will be created in your stack for each memory
 * limit configuration.
 * <p>
 * </blockquote>
 * <p>
 * <h2>Notes</h2>
 * <p>
 * <ul>
 * <li>This library uses an AWS CloudFormation custom resource which about 10MiB in
 * size. The code of this resource is bundled with this library.</li>
 * <li>AWS Lambda execution time is limited to 15min. This limits the amount of data which can
 * be deployed into the bucket by this timeout.</li>
 * <li>When the <code>BucketDeployment</code> is removed from the stack, the contents are retained
 * in the destination bucket (<a href="https://github.com/aws/aws-cdk/issues/952">#952</a>).</li>
 * <li>Bucket deployment <em>only happens</em> during stack create/update. This means that
 * if you wish to update the contents of the destination, you will need to
 * change the source s3 key (or bucket), so that the resource will be updated.
 * This is inline with best practices. If you use local disk assets, this will
 * happen automatically whenever you modify the asset, since the S3 key is based
 * on a hash of the asset contents.</li>
 * </ul>
 * <p>
 * <h2>Development</h2>
 * <p>
 * The custom resource is implemented in Python 3.6 in order to be able to leverage
 * the AWS CLI for "aws sync". The code is under <a href="./lambda/src"><code>lambda/src</code></a> and
 * unit tests are under <a href="./lambda/test"><code>lambda/test</code></a>.
 * <p>
 * This package requires Python 3.6 during build time in order to create the custom
 * resource Lambda bundle and test it. It also relies on a few bash scripts, so
 * might be tricky to build on Windows.
 * <p>
 * <h2>Roadmap</h2>
 * <p>
 * <ul>
 * <li>[ ] Support "progressive" mode (no <code>--delete</code>) (<a href="https://github.com/aws/aws-cdk/issues/953">#953</a>)</li>
 * <li>[ ] Support "blue/green" deployments (<a href="https://github.com/aws/aws-cdk/issues/954">#954</a>)</li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.s3.deployment;
