package software.amazon.awscdk.services.s3.deployment;

/**
 * Specifies bucket deployment source.
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 *  Source.bucket(bucket, key)
 *  Source.asset('/local/path/to/directory')
 *  Source.asset('/local/path/to/a/file.zip')
 * </pre></blockquote>
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.784Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.deployment.$Module.class, fqn = "@aws-cdk/aws-s3-deployment.Source")
public class Source extends software.amazon.jsii.JsiiObject {

    protected Source(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Source(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Uses a local asset as the deployment source.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param path The path to a local .zip file or a directory. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource asset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "asset", software.amazon.awscdk.services.s3.deployment.ISource.class, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Uses a local asset as the deployment source.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param path The path to a local .zip file or a directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource asset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "asset", software.amazon.awscdk.services.s3.deployment.ISource.class, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Uses a .zip file stored in an S3 bucket as the source for the destination bucket contents.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param bucket The S3 Bucket. This parameter is required.
     * @param zipObjectKey The S3 object key of the zip file with contents. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String zipObjectKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "bucket", software.amazon.awscdk.services.s3.deployment.ISource.class, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(zipObjectKey, "zipObjectKey is required") });
    }
}
