package software.amazon.awscdk.services.s3.deployment;

/**
 * Used for HTTP expires header, which influences downstream caches.
 * <p>
 * Does NOT influence deletion of the object.
 * <p>
 * EXPERIMENTAL
 * <p>
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.784Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.deployment.$Module.class, fqn = "@aws-cdk/aws-s3-deployment.Expires")
public class Expires extends software.amazon.jsii.JsiiObject {

    protected Expires(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Expires(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Expire once the specified duration has passed since deployment time.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param t the duration to wait before expiring. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.Expires after(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Expires.class, "after", software.amazon.awscdk.services.s3.deployment.Expires.class, new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * Expire at the specified date.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param d date to expire at. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.Expires atDate(final @org.jetbrains.annotations.NotNull java.time.Instant d) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Expires.class, "atDate", software.amazon.awscdk.services.s3.deployment.Expires.class, new Object[] { java.util.Objects.requireNonNull(d, "d is required") });
    }

    /**
     * Expire at the specified timestamp.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param t timestamp in unix milliseconds. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.Expires atTimestamp(final @org.jetbrains.annotations.NotNull java.lang.Number t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Expires.class, "atTimestamp", software.amazon.awscdk.services.s3.deployment.Expires.class, new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param s This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.Expires fromString(final @org.jetbrains.annotations.NotNull java.lang.String s) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Expires.class, "fromString", software.amazon.awscdk.services.s3.deployment.Expires.class, new Object[] { java.util.Objects.requireNonNull(s, "s is required") });
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object getValue() {
        return this.jsiiGet("value", java.lang.Object.class);
    }
}
