package software.amazon.awscdk.services.s3.deployment;

/**
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.773Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.deployment.$Module.class, fqn = "@aws-cdk/aws-s3-deployment.BucketDeploymentProps")
@software.amazon.jsii.Jsii.Proxy(BucketDeploymentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BucketDeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 bucket to sync the contents of the zip file to.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getDestinationBucket();

    /**
     * The sources from which to deploy the contents of this bucket.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> getSources();

    /**
     * System-defined cache-control metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> getCacheControl() {
        return null;
    }

    /**
     * System-defined cache-disposition metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentDisposition() {
        return null;
    }

    /**
     * System-defined content-encoding metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentEncoding() {
        return null;
    }

    /**
     * System-defined content-language metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentLanguage() {
        return null;
    }

    /**
     * System-defined content-type metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * Key prefix in the destination bucket.
     * <p>
     * Default: "/" (unzip to root of the destination bucket)
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationKeyPrefix() {
        return null;
    }

    /**
     * The CloudFront distribution using the destination bucket as an origin.
     * <p>
     * Files in the distribution's edge caches will be invalidated after
     * files are uploaded to the destination bucket.
     * <p>
     * Default: - No invalidation occurs
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IDistribution getDistribution() {
        return null;
    }

    /**
     * The file paths to invalidate in the CloudFront distribution.
     * <p>
     * Default: - All files under the destination bucket key prefix will be invalidated.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDistributionPaths() {
        return null;
    }

    /**
     * System-defined expires metadata to be set on all objects in the deployment.
     * <p>
     * Default: - The objects in the distribution will not expire.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.Expires getExpires() {
        return null;
    }

    /**
     * The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
     * <p>
     * If you are deploying large files, you will need to increase this number
     * accordingly.
     * <p>
     * Default: 128
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimit() {
        return null;
    }

    /**
     * User-defined object metadata to be set on all objects in the deployment.
     * <p>
     * Default: - No user metadata is set
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata getMetadata() {
        return null;
    }

    /**
     * If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrune() {
        return null;
    }

    /**
     * If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.
     * <p>
     * NOTICE: if this is set to "false" and destination bucket/prefix is updated,
     * all files in the previous destination will first be deleted and then
     * uploaded to the new destination location. This could have availablity
     * implications on your users.
     * <p>
     * Default: true - when resource is deleted/updated, files are retained
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRetainOnDelete() {
        return null;
    }

    /**
     * Execution role associated with this function.
     * <p>
     * Default: - A role is automatically created
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Server side encryption is not used.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.ServerSideEncryption getServerSideEncryption() {
        return null;
    }

    /**
     * System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionAwsKmsKeyId() {
        return null;
    }

    /**
     * System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.
     * <p>
     * Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080
     * <p>
     * Default: - Not set.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionCustomerAlgorithm() {
        return null;
    }

    /**
     * System-defined x-amz-storage-class metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Default storage-class for the bucket is used.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.StorageClass getStorageClass() {
        return null;
    }

    /**
     * System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.
     * <p>
     * Default: - No website redirection.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebsiteRedirectLocation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BucketDeploymentProps> {
        private software.amazon.awscdk.services.s3.IBucket destinationBucket;
        private java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> sources;
        private java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl;
        private java.lang.String contentDisposition;
        private java.lang.String contentEncoding;
        private java.lang.String contentLanguage;
        private java.lang.String contentType;
        private java.lang.String destinationKeyPrefix;
        private software.amazon.awscdk.services.cloudfront.IDistribution distribution;
        private java.util.List<java.lang.String> distributionPaths;
        private software.amazon.awscdk.services.s3.deployment.Expires expires;
        private java.lang.Number memoryLimit;
        private software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata metadata;
        private java.lang.Boolean prune;
        private java.lang.Boolean retainOnDelete;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption;
        private java.lang.String serverSideEncryptionAwsKmsKeyId;
        private java.lang.String serverSideEncryptionCustomerAlgorithm;
        private software.amazon.awscdk.services.s3.deployment.StorageClass storageClass;
        private java.lang.String websiteRedirectLocation;

        /**
         * Sets the value of {@link BucketDeploymentProps#getDestinationBucket}
         * @param destinationBucket The S3 bucket to sync the contents of the zip file to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder destinationBucket(software.amazon.awscdk.services.s3.IBucket destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getSources}
         * @param sources The sources from which to deploy the contents of this bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sources(java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getCacheControl}
         * @param cacheControl System-defined cache-control metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cacheControl(java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentDisposition}
         * @param contentDisposition System-defined cache-disposition metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentDisposition(java.lang.String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentEncoding}
         * @param contentEncoding System-defined content-encoding metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentEncoding(java.lang.String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentLanguage}
         * @param contentLanguage System-defined content-language metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentLanguage(java.lang.String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentType}
         * @param contentType System-defined content-type metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDestinationKeyPrefix}
         * @param destinationKeyPrefix Key prefix in the destination bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder destinationKeyPrefix(java.lang.String destinationKeyPrefix) {
            this.destinationKeyPrefix = destinationKeyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDistribution}
         * @param distribution The CloudFront distribution using the destination bucket as an origin.
         *                     Files in the distribution's edge caches will be invalidated after
         *                     files are uploaded to the destination bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder distribution(software.amazon.awscdk.services.cloudfront.IDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDistributionPaths}
         * @param distributionPaths The file paths to invalidate in the CloudFront distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder distributionPaths(java.util.List<java.lang.String> distributionPaths) {
            this.distributionPaths = distributionPaths;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getExpires}
         * @param expires System-defined expires metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expires(software.amazon.awscdk.services.s3.deployment.Expires expires) {
            this.expires = expires;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getMemoryLimit}
         * @param memoryLimit The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
         *                    If you are deploying large files, you will need to increase this number
         *                    accordingly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryLimit(java.lang.Number memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getMetadata}
         * @param metadata User-defined object metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metadata(software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getPrune}
         * @param prune If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getRetainOnDelete}
         * @param retainOnDelete If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.
         *                       NOTICE: if this is set to "false" and destination bucket/prefix is updated,
         *                       all files in the previous destination will first be deleted and then
         *                       uploaded to the new destination location. This could have availablity
         *                       implications on your users.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retainOnDelete(java.lang.Boolean retainOnDelete) {
            this.retainOnDelete = retainOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getRole}
         * @param role Execution role associated with this function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryption}
         * @param serverSideEncryption System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serverSideEncryption(software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryptionAwsKmsKeyId}
         * @param serverSideEncryptionAwsKmsKeyId System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serverSideEncryptionAwsKmsKeyId(java.lang.String serverSideEncryptionAwsKmsKeyId) {
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryptionCustomerAlgorithm}
         * @param serverSideEncryptionCustomerAlgorithm System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.
         *                                              Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serverSideEncryptionCustomerAlgorithm(java.lang.String serverSideEncryptionCustomerAlgorithm) {
            this.serverSideEncryptionCustomerAlgorithm = serverSideEncryptionCustomerAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getStorageClass}
         * @param storageClass System-defined x-amz-storage-class metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageClass(software.amazon.awscdk.services.s3.deployment.StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getWebsiteRedirectLocation}
         * @param websiteRedirectLocation System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder websiteRedirectLocation(java.lang.String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketDeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BucketDeploymentProps build() {
            return new Jsii$Proxy(destinationBucket, sources, cacheControl, contentDisposition, contentEncoding, contentLanguage, contentType, destinationKeyPrefix, distribution, distributionPaths, expires, memoryLimit, metadata, prune, retainOnDelete, role, serverSideEncryption, serverSideEncryptionAwsKmsKeyId, serverSideEncryptionCustomerAlgorithm, storageClass, websiteRedirectLocation);
        }
    }

    /**
     * An implementation for {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketDeploymentProps {
        private final software.amazon.awscdk.services.s3.IBucket destinationBucket;
        private final java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> sources;
        private final java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl;
        private final java.lang.String contentDisposition;
        private final java.lang.String contentEncoding;
        private final java.lang.String contentLanguage;
        private final java.lang.String contentType;
        private final java.lang.String destinationKeyPrefix;
        private final software.amazon.awscdk.services.cloudfront.IDistribution distribution;
        private final java.util.List<java.lang.String> distributionPaths;
        private final software.amazon.awscdk.services.s3.deployment.Expires expires;
        private final java.lang.Number memoryLimit;
        private final software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata metadata;
        private final java.lang.Boolean prune;
        private final java.lang.Boolean retainOnDelete;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption;
        private final java.lang.String serverSideEncryptionAwsKmsKeyId;
        private final java.lang.String serverSideEncryptionCustomerAlgorithm;
        private final software.amazon.awscdk.services.s3.deployment.StorageClass storageClass;
        private final java.lang.String websiteRedirectLocation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationBucket = this.jsiiGet("destinationBucket", software.amazon.awscdk.services.s3.IBucket.class);
            this.sources = this.jsiiGet("sources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class)));
            this.cacheControl = this.jsiiGet("cacheControl", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class)));
            this.contentDisposition = this.jsiiGet("contentDisposition", java.lang.String.class);
            this.contentEncoding = this.jsiiGet("contentEncoding", java.lang.String.class);
            this.contentLanguage = this.jsiiGet("contentLanguage", java.lang.String.class);
            this.contentType = this.jsiiGet("contentType", java.lang.String.class);
            this.destinationKeyPrefix = this.jsiiGet("destinationKeyPrefix", java.lang.String.class);
            this.distribution = this.jsiiGet("distribution", software.amazon.awscdk.services.cloudfront.IDistribution.class);
            this.distributionPaths = this.jsiiGet("distributionPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.expires = this.jsiiGet("expires", software.amazon.awscdk.services.s3.deployment.Expires.class);
            this.memoryLimit = this.jsiiGet("memoryLimit", java.lang.Number.class);
            this.metadata = this.jsiiGet("metadata", software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata.class);
            this.prune = this.jsiiGet("prune", java.lang.Boolean.class);
            this.retainOnDelete = this.jsiiGet("retainOnDelete", java.lang.Boolean.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.serverSideEncryption = this.jsiiGet("serverSideEncryption", software.amazon.awscdk.services.s3.deployment.ServerSideEncryption.class);
            this.serverSideEncryptionAwsKmsKeyId = this.jsiiGet("serverSideEncryptionAwsKmsKeyId", java.lang.String.class);
            this.serverSideEncryptionCustomerAlgorithm = this.jsiiGet("serverSideEncryptionCustomerAlgorithm", java.lang.String.class);
            this.storageClass = this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.deployment.StorageClass.class);
            this.websiteRedirectLocation = this.jsiiGet("websiteRedirectLocation", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.s3.IBucket destinationBucket, final java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> sources, final java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl, final java.lang.String contentDisposition, final java.lang.String contentEncoding, final java.lang.String contentLanguage, final java.lang.String contentType, final java.lang.String destinationKeyPrefix, final software.amazon.awscdk.services.cloudfront.IDistribution distribution, final java.util.List<java.lang.String> distributionPaths, final software.amazon.awscdk.services.s3.deployment.Expires expires, final java.lang.Number memoryLimit, final software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata metadata, final java.lang.Boolean prune, final java.lang.Boolean retainOnDelete, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption, final java.lang.String serverSideEncryptionAwsKmsKeyId, final java.lang.String serverSideEncryptionCustomerAlgorithm, final software.amazon.awscdk.services.s3.deployment.StorageClass storageClass, final java.lang.String websiteRedirectLocation) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationBucket = java.util.Objects.requireNonNull(destinationBucket, "destinationBucket is required");
            this.sources = java.util.Objects.requireNonNull(sources, "sources is required");
            this.cacheControl = cacheControl;
            this.contentDisposition = contentDisposition;
            this.contentEncoding = contentEncoding;
            this.contentLanguage = contentLanguage;
            this.contentType = contentType;
            this.destinationKeyPrefix = destinationKeyPrefix;
            this.distribution = distribution;
            this.distributionPaths = distributionPaths;
            this.expires = expires;
            this.memoryLimit = memoryLimit;
            this.metadata = metadata;
            this.prune = prune;
            this.retainOnDelete = retainOnDelete;
            this.role = role;
            this.serverSideEncryption = serverSideEncryption;
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            this.serverSideEncryptionCustomerAlgorithm = serverSideEncryptionCustomerAlgorithm;
            this.storageClass = storageClass;
            this.websiteRedirectLocation = websiteRedirectLocation;
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getDestinationBucket() {
            return this.destinationBucket;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> getSources() {
            return this.sources;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public java.lang.String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public java.lang.String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public java.lang.String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public java.lang.String getDestinationKeyPrefix() {
            return this.destinationKeyPrefix;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.IDistribution getDistribution() {
            return this.distribution;
        }

        @Override
        public java.util.List<java.lang.String> getDistributionPaths() {
            return this.distributionPaths;
        }

        @Override
        public software.amazon.awscdk.services.s3.deployment.Expires getExpires() {
            return this.expires;
        }

        @Override
        public java.lang.Number getMemoryLimit() {
            return this.memoryLimit;
        }

        @Override
        public software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public java.lang.Boolean getRetainOnDelete() {
            return this.retainOnDelete;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.services.s3.deployment.ServerSideEncryption getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public java.lang.String getServerSideEncryptionAwsKmsKeyId() {
            return this.serverSideEncryptionAwsKmsKeyId;
        }

        @Override
        public java.lang.String getServerSideEncryptionCustomerAlgorithm() {
            return this.serverSideEncryptionCustomerAlgorithm;
        }

        @Override
        public software.amazon.awscdk.services.s3.deployment.StorageClass getStorageClass() {
            return this.storageClass;
        }

        @Override
        public java.lang.String getWebsiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationBucket", om.valueToTree(this.getDestinationBucket()));
            data.set("sources", om.valueToTree(this.getSources()));
            if (this.getCacheControl() != null) {
                data.set("cacheControl", om.valueToTree(this.getCacheControl()));
            }
            if (this.getContentDisposition() != null) {
                data.set("contentDisposition", om.valueToTree(this.getContentDisposition()));
            }
            if (this.getContentEncoding() != null) {
                data.set("contentEncoding", om.valueToTree(this.getContentEncoding()));
            }
            if (this.getContentLanguage() != null) {
                data.set("contentLanguage", om.valueToTree(this.getContentLanguage()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getDestinationKeyPrefix() != null) {
                data.set("destinationKeyPrefix", om.valueToTree(this.getDestinationKeyPrefix()));
            }
            if (this.getDistribution() != null) {
                data.set("distribution", om.valueToTree(this.getDistribution()));
            }
            if (this.getDistributionPaths() != null) {
                data.set("distributionPaths", om.valueToTree(this.getDistributionPaths()));
            }
            if (this.getExpires() != null) {
                data.set("expires", om.valueToTree(this.getExpires()));
            }
            if (this.getMemoryLimit() != null) {
                data.set("memoryLimit", om.valueToTree(this.getMemoryLimit()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getRetainOnDelete() != null) {
                data.set("retainOnDelete", om.valueToTree(this.getRetainOnDelete()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getServerSideEncryption() != null) {
                data.set("serverSideEncryption", om.valueToTree(this.getServerSideEncryption()));
            }
            if (this.getServerSideEncryptionAwsKmsKeyId() != null) {
                data.set("serverSideEncryptionAwsKmsKeyId", om.valueToTree(this.getServerSideEncryptionAwsKmsKeyId()));
            }
            if (this.getServerSideEncryptionCustomerAlgorithm() != null) {
                data.set("serverSideEncryptionCustomerAlgorithm", om.valueToTree(this.getServerSideEncryptionCustomerAlgorithm()));
            }
            if (this.getStorageClass() != null) {
                data.set("storageClass", om.valueToTree(this.getStorageClass()));
            }
            if (this.getWebsiteRedirectLocation() != null) {
                data.set("websiteRedirectLocation", om.valueToTree(this.getWebsiteRedirectLocation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3-deployment.BucketDeploymentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketDeploymentProps.Jsii$Proxy that = (BucketDeploymentProps.Jsii$Proxy) o;

            if (!destinationBucket.equals(that.destinationBucket)) return false;
            if (!sources.equals(that.sources)) return false;
            if (this.cacheControl != null ? !this.cacheControl.equals(that.cacheControl) : that.cacheControl != null) return false;
            if (this.contentDisposition != null ? !this.contentDisposition.equals(that.contentDisposition) : that.contentDisposition != null) return false;
            if (this.contentEncoding != null ? !this.contentEncoding.equals(that.contentEncoding) : that.contentEncoding != null) return false;
            if (this.contentLanguage != null ? !this.contentLanguage.equals(that.contentLanguage) : that.contentLanguage != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.destinationKeyPrefix != null ? !this.destinationKeyPrefix.equals(that.destinationKeyPrefix) : that.destinationKeyPrefix != null) return false;
            if (this.distribution != null ? !this.distribution.equals(that.distribution) : that.distribution != null) return false;
            if (this.distributionPaths != null ? !this.distributionPaths.equals(that.distributionPaths) : that.distributionPaths != null) return false;
            if (this.expires != null ? !this.expires.equals(that.expires) : that.expires != null) return false;
            if (this.memoryLimit != null ? !this.memoryLimit.equals(that.memoryLimit) : that.memoryLimit != null) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            if (this.retainOnDelete != null ? !this.retainOnDelete.equals(that.retainOnDelete) : that.retainOnDelete != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.serverSideEncryption != null ? !this.serverSideEncryption.equals(that.serverSideEncryption) : that.serverSideEncryption != null) return false;
            if (this.serverSideEncryptionAwsKmsKeyId != null ? !this.serverSideEncryptionAwsKmsKeyId.equals(that.serverSideEncryptionAwsKmsKeyId) : that.serverSideEncryptionAwsKmsKeyId != null) return false;
            if (this.serverSideEncryptionCustomerAlgorithm != null ? !this.serverSideEncryptionCustomerAlgorithm.equals(that.serverSideEncryptionCustomerAlgorithm) : that.serverSideEncryptionCustomerAlgorithm != null) return false;
            if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) return false;
            return this.websiteRedirectLocation != null ? this.websiteRedirectLocation.equals(that.websiteRedirectLocation) : that.websiteRedirectLocation == null;
        }

        @Override
        public int hashCode() {
            int result = this.destinationBucket.hashCode();
            result = 31 * result + (this.sources.hashCode());
            result = 31 * result + (this.cacheControl != null ? this.cacheControl.hashCode() : 0);
            result = 31 * result + (this.contentDisposition != null ? this.contentDisposition.hashCode() : 0);
            result = 31 * result + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
            result = 31 * result + (this.contentLanguage != null ? this.contentLanguage.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.destinationKeyPrefix != null ? this.destinationKeyPrefix.hashCode() : 0);
            result = 31 * result + (this.distribution != null ? this.distribution.hashCode() : 0);
            result = 31 * result + (this.distributionPaths != null ? this.distributionPaths.hashCode() : 0);
            result = 31 * result + (this.expires != null ? this.expires.hashCode() : 0);
            result = 31 * result + (this.memoryLimit != null ? this.memoryLimit.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.retainOnDelete != null ? this.retainOnDelete.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryption != null ? this.serverSideEncryption.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionAwsKmsKeyId != null ? this.serverSideEncryptionAwsKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionCustomerAlgorithm != null ? this.serverSideEncryptionCustomerAlgorithm.hashCode() : 0);
            result = 31 * result + (this.storageClass != null ? this.storageClass.hashCode() : 0);
            result = 31 * result + (this.websiteRedirectLocation != null ? this.websiteRedirectLocation.hashCode() : 0);
            return result;
        }
    }
}
