/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.deployment;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.cloudfront.IDistribution;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.deployment.$Module;
import software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps;
import software.amazon.awscdk.services.s3.deployment.CacheControl;
import software.amazon.awscdk.services.s3.deployment.Expires;
import software.amazon.awscdk.services.s3.deployment.ISource;
import software.amazon.awscdk.services.s3.deployment.ServerSideEncryption;
import software.amazon.awscdk.services.s3.deployment.StorageClass;
import software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-s3-deployment.BucketDeploymentProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface BucketDeploymentProps
extends JsiiSerializable {
    @NotNull
    public IBucket getDestinationBucket();

    @NotNull
    public List<ISource> getSources();

    @Nullable
    default public List<CacheControl> getCacheControl() {
        return null;
    }

    @Nullable
    default public String getContentDisposition() {
        return null;
    }

    @Nullable
    default public String getContentEncoding() {
        return null;
    }

    @Nullable
    default public String getContentLanguage() {
        return null;
    }

    @Nullable
    default public String getContentType() {
        return null;
    }

    @Nullable
    default public String getDestinationKeyPrefix() {
        return null;
    }

    @Nullable
    default public IDistribution getDistribution() {
        return null;
    }

    @Nullable
    default public List<String> getDistributionPaths() {
        return null;
    }

    @Nullable
    default public Expires getExpires() {
        return null;
    }

    @Nullable
    default public Number getMemoryLimit() {
        return null;
    }

    @Nullable
    default public UserDefinedObjectMetadata getMetadata() {
        return null;
    }

    @Nullable
    default public Boolean getRetainOnDelete() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public ServerSideEncryption getServerSideEncryption() {
        return null;
    }

    @Nullable
    default public String getServerSideEncryptionAwsKmsKeyId() {
        return null;
    }

    @Nullable
    default public String getServerSideEncryptionCustomerAlgorithm() {
        return null;
    }

    @Nullable
    default public StorageClass getStorageClass() {
        return null;
    }

    @Nullable
    default public String getWebsiteRedirectLocation() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BucketDeploymentProps> {
        private IBucket destinationBucket;
        private List<ISource> sources;
        private List<CacheControl> cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String contentType;
        private String destinationKeyPrefix;
        private IDistribution distribution;
        private List<String> distributionPaths;
        private Expires expires;
        private Number memoryLimit;
        private UserDefinedObjectMetadata metadata;
        private Boolean retainOnDelete;
        private IRole role;
        private ServerSideEncryption serverSideEncryption;
        private String serverSideEncryptionAwsKmsKeyId;
        private String serverSideEncryptionCustomerAlgorithm;
        private StorageClass storageClass;
        private String websiteRedirectLocation;

        public Builder destinationBucket(IBucket destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        public Builder sources(List<ISource> sources) {
            this.sources = sources;
            return this;
        }

        public Builder cacheControl(List<CacheControl> cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder destinationKeyPrefix(String destinationKeyPrefix) {
            this.destinationKeyPrefix = destinationKeyPrefix;
            return this;
        }

        public Builder distribution(IDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public Builder distributionPaths(List<String> distributionPaths) {
            this.distributionPaths = distributionPaths;
            return this;
        }

        public Builder expires(Expires expires) {
            this.expires = expires;
            return this;
        }

        public Builder memoryLimit(Number memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Builder metadata(UserDefinedObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder retainOnDelete(Boolean retainOnDelete) {
            this.retainOnDelete = retainOnDelete;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder serverSideEncryptionAwsKmsKeyId(String serverSideEncryptionAwsKmsKeyId) {
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            return this;
        }

        public Builder serverSideEncryptionCustomerAlgorithm(String serverSideEncryptionCustomerAlgorithm) {
            this.serverSideEncryptionCustomerAlgorithm = serverSideEncryptionCustomerAlgorithm;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public BucketDeploymentProps build() {
            return new Jsii.Proxy(this.destinationBucket, this.sources, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType, this.destinationKeyPrefix, this.distribution, this.distributionPaths, this.expires, this.memoryLimit, this.metadata, this.retainOnDelete, this.role, this.serverSideEncryption, this.serverSideEncryptionAwsKmsKeyId, this.serverSideEncryptionCustomerAlgorithm, this.storageClass, this.websiteRedirectLocation, null);
        }
    }
}

