/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.deployment;

import java.util.List;
import software.amazon.awscdk.services.cloudfront.IDistribution;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps;
import software.amazon.awscdk.services.s3.deployment.CacheControl;
import software.amazon.awscdk.services.s3.deployment.Expires;
import software.amazon.awscdk.services.s3.deployment.ISource;
import software.amazon.awscdk.services.s3.deployment.ServerSideEncryption;
import software.amazon.awscdk.services.s3.deployment.StorageClass;
import software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata;
import software.amazon.jsii.JsiiSerializable;

public interface BucketDeploymentProps
extends JsiiSerializable {
    public IBucket getDestinationBucket();

    public List<ISource> getSources();

    public List<CacheControl> getCacheControl();

    public String getContentDisposition();

    public String getContentEncoding();

    public String getContentLanguage();

    public String getContentType();

    public String getDestinationKeyPrefix();

    public IDistribution getDistribution();

    public List<String> getDistributionPaths();

    public Expires getExpires();

    public Number getMemoryLimit();

    public UserDefinedObjectMetadata getMetadata();

    public Boolean getRetainOnDelete();

    public IRole getRole();

    public ServerSideEncryption getServerSideEncryption();

    public String getServerSideEncryptionAwsKmsKeyId();

    public String getServerSideEncryptionCustomerAlgorithm();

    public StorageClass getStorageClass();

    public String getWebsiteRedirectLocation();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket destinationBucket;
        private List<ISource> sources;
        private List<CacheControl> cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String contentType;
        private String destinationKeyPrefix;
        private IDistribution distribution;
        private List<String> distributionPaths;
        private Expires expires;
        private Number memoryLimit;
        private UserDefinedObjectMetadata metadata;
        private Boolean retainOnDelete;
        private IRole role;
        private ServerSideEncryption serverSideEncryption;
        private String serverSideEncryptionAwsKmsKeyId;
        private String serverSideEncryptionCustomerAlgorithm;
        private StorageClass storageClass;
        private String websiteRedirectLocation;

        public Builder destinationBucket(IBucket destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        public Builder sources(List<ISource> sources) {
            this.sources = sources;
            return this;
        }

        public Builder cacheControl(List<CacheControl> cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder destinationKeyPrefix(String destinationKeyPrefix) {
            this.destinationKeyPrefix = destinationKeyPrefix;
            return this;
        }

        public Builder distribution(IDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public Builder distributionPaths(List<String> distributionPaths) {
            this.distributionPaths = distributionPaths;
            return this;
        }

        public Builder expires(Expires expires) {
            this.expires = expires;
            return this;
        }

        public Builder memoryLimit(Number memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Builder metadata(UserDefinedObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder retainOnDelete(Boolean retainOnDelete) {
            this.retainOnDelete = retainOnDelete;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder serverSideEncryptionAwsKmsKeyId(String serverSideEncryptionAwsKmsKeyId) {
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            return this;
        }

        public Builder serverSideEncryptionCustomerAlgorithm(String serverSideEncryptionCustomerAlgorithm) {
            this.serverSideEncryptionCustomerAlgorithm = serverSideEncryptionCustomerAlgorithm;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public BucketDeploymentProps build() {
            return new Jsii.Proxy(this.destinationBucket, this.sources, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType, this.destinationKeyPrefix, this.distribution, this.distributionPaths, this.expires, this.memoryLimit, this.metadata, this.retainOnDelete, this.role, this.serverSideEncryption, this.serverSideEncryptionAwsKmsKeyId, this.serverSideEncryptionCustomerAlgorithm, this.storageClass, this.websiteRedirectLocation, null);
        }
    }
}

