/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.deployment;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SourceConfig
extends JsiiSerializable {
    public IBucket getBucket();

    public String getZipObjectKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _bucket;
        private String _zipObjectKey;

        public Builder withBucket(IBucket value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withZipObjectKey(String value) {
            this._zipObjectKey = Objects.requireNonNull(value, "zipObjectKey is required");
            return this;
        }

        public SourceConfig build() {
            return new SourceConfig(){
                private final IBucket $bucket;
                private final String $zipObjectKey;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$zipObjectKey = Objects.requireNonNull(_zipObjectKey, "zipObjectKey is required");
                }

                @Override
                public IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public String getZipObjectKey() {
                    return this.$zipObjectKey;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("bucket", om.valueToTree((Object)this.getBucket()));
                    obj.set("zipObjectKey", om.valueToTree((Object)this.getZipObjectKey()));
                    return obj;
                }
            };
        }
    }
}

