/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.assets;

import java.util.List;
import software.amazon.awscdk.assets.CopyOptions;
import software.amazon.awscdk.assets.FollowMode;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.s3.assets.AssetOptions;
import software.amazon.jsii.JsiiSerializable;

public interface AssetOptions
extends JsiiSerializable,
CopyOptions {
    public List<IGrantable> getReaders();

    public String getSourceHash();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IGrantable> readers;
        private String sourceHash;
        private List<String> exclude;
        private FollowMode follow;

        public Builder readers(List<IGrantable> readers) {
            this.readers = readers;
            return this;
        }

        public Builder sourceHash(String sourceHash) {
            this.sourceHash = sourceHash;
            return this;
        }

        public Builder exclude(List<String> exclude) {
            this.exclude = exclude;
            return this;
        }

        public Builder follow(FollowMode follow) {
            this.follow = follow;
            return this;
        }

        public AssetOptions build() {
            return new Jsii.Proxy(this.readers, this.sourceHash, this.exclude, this.follow, null);
        }
    }
}

