/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53resolver;

import java.util.List;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.route53resolver.CfnResolverRuleProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnResolverRuleProps
extends JsiiSerializable {
    public String getDomainName();

    public String getRuleType();

    public String getName();

    public String getResolverEndpointId();

    public List<CfnTag> getTags();

    public Object getTargetIps();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String domainName;
        private String ruleType;
        private String name;
        private String resolverEndpointId;
        private List<CfnTag> tags;
        private Object targetIps;

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder targetIps(IResolvable targetIps) {
            this.targetIps = targetIps;
            return this;
        }

        public Builder targetIps(List<Object> targetIps) {
            this.targetIps = targetIps;
            return this;
        }

        public CfnResolverRuleProps build() {
            return new Jsii.Proxy(this.domainName, this.ruleType, this.name, this.resolverEndpointId, this.tags, this.targetIps, null);
        }
    }
}

