/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53resolver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IResolvable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnResolverEndpointProps
extends JsiiSerializable {
    public String getDirection();

    public Object getIpAddresses();

    public List<String> getSecurityGroupIds();

    public String getName();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _direction;
        private Object _ipAddresses;
        private List<String> _securityGroupIds;
        @Nullable
        private String _name;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withDirection(String value) {
            this._direction = Objects.requireNonNull(value, "direction is required");
            return this;
        }

        public Builder withIpAddresses(IResolvable value) {
            this._ipAddresses = Objects.requireNonNull(value, "ipAddresses is required");
            return this;
        }

        public Builder withIpAddresses(List<Object> value) {
            this._ipAddresses = Objects.requireNonNull(value, "ipAddresses is required");
            return this;
        }

        public Builder withSecurityGroupIds(List<String> value) {
            this._securityGroupIds = Objects.requireNonNull(value, "securityGroupIds is required");
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnResolverEndpointProps build() {
            return new CfnResolverEndpointProps(){
                private final String $direction;
                private final Object $ipAddresses;
                private final List<String> $securityGroupIds;
                @Nullable
                private final String $name;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$direction = Objects.requireNonNull(_direction, "direction is required");
                    this.$ipAddresses = Objects.requireNonNull(_ipAddresses, "ipAddresses is required");
                    this.$securityGroupIds = Objects.requireNonNull(_securityGroupIds, "securityGroupIds is required");
                    this.$name = _name;
                    this.$tags = _tags;
                }

                @Override
                public String getDirection() {
                    return this.$direction;
                }

                @Override
                public Object getIpAddresses() {
                    return this.$ipAddresses;
                }

                @Override
                public List<String> getSecurityGroupIds() {
                    return this.$securityGroupIds;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("direction", om.valueToTree((Object)this.getDirection()));
                    obj.set("ipAddresses", om.valueToTree(this.getIpAddresses()));
                    obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

