/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53resolver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnResolverRuleProps
extends JsiiSerializable {
    public String getDomainName();

    public String getRuleType();

    public String getName();

    public String getResolverEndpointId();

    public List<CfnTag> getTags();

    public Object getTargetIps();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _domainName;
        private String _ruleType;
        @Nullable
        private String _name;
        @Nullable
        private String _resolverEndpointId;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private Object _targetIps;

        public Builder withDomainName(String value) {
            this._domainName = Objects.requireNonNull(value, "domainName is required");
            return this;
        }

        public Builder withRuleType(String value) {
            this._ruleType = Objects.requireNonNull(value, "ruleType is required");
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withResolverEndpointId(@Nullable String value) {
            this._resolverEndpointId = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withTargetIps(@Nullable Token value) {
            this._targetIps = value;
            return this;
        }

        public Builder withTargetIps(@Nullable List<Object> value) {
            this._targetIps = value;
            return this;
        }

        public CfnResolverRuleProps build() {
            return new CfnResolverRuleProps(){
                private final String $domainName;
                private final String $ruleType;
                @Nullable
                private final String $name;
                @Nullable
                private final String $resolverEndpointId;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final Object $targetIps;
                {
                    this.$domainName = Objects.requireNonNull(_domainName, "domainName is required");
                    this.$ruleType = Objects.requireNonNull(_ruleType, "ruleType is required");
                    this.$name = _name;
                    this.$resolverEndpointId = _resolverEndpointId;
                    this.$tags = _tags;
                    this.$targetIps = _targetIps;
                }

                @Override
                public String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public String getRuleType() {
                    return this.$ruleType;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getResolverEndpointId() {
                    return this.$resolverEndpointId;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public Object getTargetIps() {
                    return this.$targetIps;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("domainName", om.valueToTree((Object)this.getDomainName()));
                    obj.set("ruleType", om.valueToTree((Object)this.getRuleType()));
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    if (this.getResolverEndpointId() != null) {
                        obj.set("resolverEndpointId", om.valueToTree((Object)this.getResolverEndpointId()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getTargetIps() != null) {
                        obj.set("targetIps", om.valueToTree(this.getTargetIps()));
                    }
                    return obj;
                }
            };
        }
    }
}

