/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import java.util.List;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.route53.CfnRecordSet;
import software.amazon.awscdk.services.route53.CfnRecordSetProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnRecordSetProps
extends JsiiSerializable {
    public String getName();

    public String getType();

    public Object getAliasTarget();

    public String getComment();

    public String getFailover();

    public Object getGeoLocation();

    public String getHealthCheckId();

    public String getHostedZoneId();

    public String getHostedZoneName();

    public Object getMultiValueAnswer();

    public String getRegion();

    public List<String> getResourceRecords();

    public String getSetIdentifier();

    public String getTtl();

    public Number getWeight();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String type;
        private Object aliasTarget;
        private String comment;
        private String failover;
        private Object geoLocation;
        private String healthCheckId;
        private String hostedZoneId;
        private String hostedZoneName;
        private Object multiValueAnswer;
        private String region;
        private List<String> resourceRecords;
        private String setIdentifier;
        private String ttl;
        private Number weight;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder aliasTarget(IResolvable aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        public Builder aliasTarget(CfnRecordSet.AliasTargetProperty aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder failover(String failover) {
            this.failover = failover;
            return this;
        }

        public Builder geoLocation(IResolvable geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public Builder geoLocation(CfnRecordSet.GeoLocationProperty geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public Builder hostedZoneName(String hostedZoneName) {
            this.hostedZoneName = hostedZoneName;
            return this;
        }

        public Builder multiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        public Builder multiValueAnswer(IResolvable multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder resourceRecords(List<String> resourceRecords) {
            this.resourceRecords = resourceRecords;
            return this;
        }

        public Builder setIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        public Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder weight(Number weight) {
            this.weight = weight;
            return this;
        }

        public CfnRecordSetProps build() {
            return new Jsii.Proxy(this.name, this.type, this.aliasTarget, this.comment, this.failover, this.geoLocation, this.healthCheckId, this.hostedZoneId, this.hostedZoneName, this.multiValueAnswer, this.region, this.resourceRecords, this.setIdentifier, this.ttl, this.weight, null);
        }
    }
}

