/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.route53.CommonHostedZoneProps;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface HostedZoneProps
extends JsiiSerializable,
CommonHostedZoneProps {
    public List<IVpc> getVpcs();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private List<IVpc> _vpcs;
        private String _zoneName;
        @Nullable
        private String _comment;
        @Nullable
        private String _queryLogsLogGroupArn;

        public Builder withVpcs(@Nullable List<IVpc> value) {
            this._vpcs = value;
            return this;
        }

        public Builder withZoneName(String value) {
            this._zoneName = Objects.requireNonNull(value, "zoneName is required");
            return this;
        }

        public Builder withComment(@Nullable String value) {
            this._comment = value;
            return this;
        }

        public Builder withQueryLogsLogGroupArn(@Nullable String value) {
            this._queryLogsLogGroupArn = value;
            return this;
        }

        public HostedZoneProps build() {
            return new HostedZoneProps(){
                @Nullable
                private final List<IVpc> $vpcs;
                private final String $zoneName;
                @Nullable
                private final String $comment;
                @Nullable
                private final String $queryLogsLogGroupArn;
                {
                    this.$vpcs = _vpcs;
                    this.$zoneName = Objects.requireNonNull(_zoneName, "zoneName is required");
                    this.$comment = _comment;
                    this.$queryLogsLogGroupArn = _queryLogsLogGroupArn;
                }

                @Override
                public List<IVpc> getVpcs() {
                    return this.$vpcs;
                }

                @Override
                public String getZoneName() {
                    return this.$zoneName;
                }

                @Override
                public String getComment() {
                    return this.$comment;
                }

                @Override
                public String getQueryLogsLogGroupArn() {
                    return this.$queryLogsLogGroupArn;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("vpcs", om.valueToTree(this.getVpcs()));
                    obj.set("zoneName", om.valueToTree((Object)this.getZoneName()));
                    obj.set("comment", om.valueToTree((Object)this.getComment()));
                    obj.set("queryLogsLogGroupArn", om.valueToTree((Object)this.getQueryLogsLogGroupArn()));
                    return obj;
                }
            };
        }
    }
}

