/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CnameRecordProps
extends JsiiSerializable {
    public String getRecordName();

    public String getRecordValue();

    public IHostedZone getZone();

    public Number getTtl();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _recordName;
        private String _recordValue;
        private IHostedZone _zone;
        @Nullable
        private Number _ttl;

        public Builder withRecordName(String value) {
            this._recordName = Objects.requireNonNull(value, "recordName is required");
            return this;
        }

        public Builder withRecordValue(String value) {
            this._recordValue = Objects.requireNonNull(value, "recordValue is required");
            return this;
        }

        public Builder withZone(IHostedZone value) {
            this._zone = Objects.requireNonNull(value, "zone is required");
            return this;
        }

        public Builder withTtl(@Nullable Number value) {
            this._ttl = value;
            return this;
        }

        public CnameRecordProps build() {
            return new CnameRecordProps(){
                private final String $recordName;
                private final String $recordValue;
                private final IHostedZone $zone;
                @Nullable
                private final Number $ttl;
                {
                    this.$recordName = Objects.requireNonNull(_recordName, "recordName is required");
                    this.$recordValue = Objects.requireNonNull(_recordValue, "recordValue is required");
                    this.$zone = Objects.requireNonNull(_zone, "zone is required");
                    this.$ttl = _ttl;
                }

                @Override
                public String getRecordName() {
                    return this.$recordName;
                }

                @Override
                public String getRecordValue() {
                    return this.$recordValue;
                }

                @Override
                public IHostedZone getZone() {
                    return this.$zone;
                }

                @Override
                public Number getTtl() {
                    return this.$ttl;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("recordName", om.valueToTree((Object)this.getRecordName()));
                    obj.set("recordValue", om.valueToTree((Object)this.getRecordValue()));
                    obj.set("zone", om.valueToTree((Object)this.getZone()));
                    obj.set("ttl", om.valueToTree((Object)this.getTtl()));
                    return obj;
                }
            };
        }
    }
}

