/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.robomaker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.robomaker.CfnSimulationApplication;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnSimulationApplicationProps
extends JsiiSerializable {
    public Object getRenderingEngine();

    public Object getRobotSoftwareSuite();

    public Object getSimulationSoftwareSuite();

    public Object getSources();

    public String getCurrentRevisionId();

    public String getName();

    public ObjectNode getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _renderingEngine;
        private Object _robotSoftwareSuite;
        private Object _simulationSoftwareSuite;
        private Object _sources;
        @Nullable
        private String _currentRevisionId;
        @Nullable
        private String _name;
        @Nullable
        private ObjectNode _tags;

        public Builder withRenderingEngine(Token value) {
            this._renderingEngine = Objects.requireNonNull(value, "renderingEngine is required");
            return this;
        }

        public Builder withRenderingEngine(CfnSimulationApplication.RenderingEngineProperty value) {
            this._renderingEngine = Objects.requireNonNull(value, "renderingEngine is required");
            return this;
        }

        public Builder withRobotSoftwareSuite(Token value) {
            this._robotSoftwareSuite = Objects.requireNonNull(value, "robotSoftwareSuite is required");
            return this;
        }

        public Builder withRobotSoftwareSuite(CfnSimulationApplication.RobotSoftwareSuiteProperty value) {
            this._robotSoftwareSuite = Objects.requireNonNull(value, "robotSoftwareSuite is required");
            return this;
        }

        public Builder withSimulationSoftwareSuite(Token value) {
            this._simulationSoftwareSuite = Objects.requireNonNull(value, "simulationSoftwareSuite is required");
            return this;
        }

        public Builder withSimulationSoftwareSuite(CfnSimulationApplication.SimulationSoftwareSuiteProperty value) {
            this._simulationSoftwareSuite = Objects.requireNonNull(value, "simulationSoftwareSuite is required");
            return this;
        }

        public Builder withSources(Token value) {
            this._sources = Objects.requireNonNull(value, "sources is required");
            return this;
        }

        public Builder withSources(List<Object> value) {
            this._sources = Objects.requireNonNull(value, "sources is required");
            return this;
        }

        public Builder withCurrentRevisionId(@Nullable String value) {
            this._currentRevisionId = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withTags(@Nullable ObjectNode value) {
            this._tags = value;
            return this;
        }

        public CfnSimulationApplicationProps build() {
            return new CfnSimulationApplicationProps(){
                private final Object $renderingEngine;
                private final Object $robotSoftwareSuite;
                private final Object $simulationSoftwareSuite;
                private final Object $sources;
                @Nullable
                private final String $currentRevisionId;
                @Nullable
                private final String $name;
                @Nullable
                private final ObjectNode $tags;
                {
                    this.$renderingEngine = Objects.requireNonNull(_renderingEngine, "renderingEngine is required");
                    this.$robotSoftwareSuite = Objects.requireNonNull(_robotSoftwareSuite, "robotSoftwareSuite is required");
                    this.$simulationSoftwareSuite = Objects.requireNonNull(_simulationSoftwareSuite, "simulationSoftwareSuite is required");
                    this.$sources = Objects.requireNonNull(_sources, "sources is required");
                    this.$currentRevisionId = _currentRevisionId;
                    this.$name = _name;
                    this.$tags = _tags;
                }

                @Override
                public Object getRenderingEngine() {
                    return this.$renderingEngine;
                }

                @Override
                public Object getRobotSoftwareSuite() {
                    return this.$robotSoftwareSuite;
                }

                @Override
                public Object getSimulationSoftwareSuite() {
                    return this.$simulationSoftwareSuite;
                }

                @Override
                public Object getSources() {
                    return this.$sources;
                }

                @Override
                public String getCurrentRevisionId() {
                    return this.$currentRevisionId;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public ObjectNode getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("renderingEngine", om.valueToTree(this.getRenderingEngine()));
                    obj.set("robotSoftwareSuite", om.valueToTree(this.getRobotSoftwareSuite()));
                    obj.set("simulationSoftwareSuite", om.valueToTree(this.getSimulationSoftwareSuite()));
                    obj.set("sources", om.valueToTree(this.getSources()));
                    if (this.getCurrentRevisionId() != null) {
                        obj.set("currentRevisionId", om.valueToTree((Object)this.getCurrentRevisionId()));
                    }
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree((Object)this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

