package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a `CfnFunction`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnFunctionProps cfnFunctionProps = CfnFunctionProps.builder()
 *         .code(CodeProperty.builder()
 *                 .imageUri("imageUri")
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .zipFile("zipFile")
 *                 .build())
 *         .role("role")
 *         // the properties below are optional
 *         .architectures(List.of("architectures"))
 *         .codeSigningConfigArn("codeSigningConfigArn")
 *         .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                 .targetArn("targetArn")
 *                 .build())
 *         .description("description")
 *         .environment(EnvironmentProperty.builder()
 *                 .variables(Map.of(
 *                         "variablesKey", "variables"))
 *                 .build())
 *         .ephemeralStorage(EphemeralStorageProperty.builder()
 *                 .size(123)
 *                 .build())
 *         .fileSystemConfigs(List.of(FileSystemConfigProperty.builder()
 *                 .arn("arn")
 *                 .localMountPath("localMountPath")
 *                 .build()))
 *         .functionName("functionName")
 *         .handler("handler")
 *         .imageConfig(ImageConfigProperty.builder()
 *                 .command(List.of("command"))
 *                 .entryPoint(List.of("entryPoint"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .kmsKeyArn("kmsKeyArn")
 *         .layers(List.of("layers"))
 *         .memorySize(123)
 *         .packageType("packageType")
 *         .reservedConcurrentExecutions(123)
 *         .runtime("runtime")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeout(123)
 *         .tracingConfig(TracingConfigProperty.builder()
 *                 .mode("mode")
 *                 .build())
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:30.072Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnFunctionProps")
@software.amazon.jsii.Jsii.Proxy(CfnFunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFunctionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The code for the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCode();

    /**
     * The Amazon Resource Name (ARN) of the function's execution role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRole();

    /**
     * The instruction set architecture that the function supports.
     * <p>
     * Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArchitectures() {
        return null;
    }

    /**
     * To enable code signing for this function, specify the ARN of a code-signing configuration.
     * <p>
     * A code-signing configuration
     * includes a set of signing profiles, which define the trusted publishers for this function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCodeSigningConfigArn() {
        return null;
    }

    /**
     * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeadLetterConfig() {
        return null;
    }

    /**
     * A description of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Environment variables that are accessible from function code during execution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
        return null;
    }

    /**
     * The size of the function’s /tmp directory in MB.
     * <p>
     * The default value is 512, but can be any whole number between 512 and 10240 MB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
        return null;
    }

    /**
     * Connection settings for an Amazon EFS file system.
     * <p>
     * To connect a function to a file system, a mount target must be available in every Availability Zone that your function connects to. If your template contains an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html">AWS::EFS::MountTarget</a> resource, you must also specify a <code>DependsOn</code> attribute to ensure that the mount target is created or updated before the function.
     * <p>
     * For more information about using the <code>DependsOn</code> attribute, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemConfigs() {
        return null;
    }

    /**
     * The name of the Lambda function, up to 64 characters in length.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates one.
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionName() {
        return null;
    }

    /**
     * The name of the method within your code that Lambda calls to execute your function.
     * <p>
     * Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHandler() {
        return null;
    }

    /**
     * Configuration values that override the container image Dockerfile settings.
     * <p>
     * See <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms">Container settings</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getImageConfig() {
        return null;
    }

    /**
     * The ARN of the AWS Key Management Service ( AWS KMS ) key that's used to encrypt your function's environment variables.
     * <p>
     * If it's not provided, AWS Lambda uses a default service key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLayers() {
        return null;
    }

    /**
     * The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySize() {
        return null;
    }

    /**
     * The type of deployment package.
     * <p>
     * Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPackageType() {
        return null;
    }

    /**
     * The number of simultaneous executions to reserve for the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReservedConcurrentExecutions() {
        return null;
    }

    /**
     * The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) . Runtime is required if the deployment package is a .zip file archive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuntime() {
        return null;
    }

    /**
     * A list of [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to apply to the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The amount of time (in seconds) that Lambda allows a function to run before stopping it.
     * <p>
     * The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return null;
    }

    /**
     * Set `Mode` to `Active` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTracingConfig() {
        return null;
    }

    /**
     * For network connectivity to AWS resources in a [VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-network.html) , specify a list of security groups and subnets in the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFunctionProps> {
        java.lang.Object code;
        java.lang.String role;
        java.util.List<java.lang.String> architectures;
        java.lang.String codeSigningConfigArn;
        java.lang.Object deadLetterConfig;
        java.lang.String description;
        java.lang.Object environment;
        java.lang.Object ephemeralStorage;
        java.lang.Object fileSystemConfigs;
        java.lang.String functionName;
        java.lang.String handler;
        java.lang.Object imageConfig;
        java.lang.String kmsKeyArn;
        java.util.List<java.lang.String> layers;
        java.lang.Number memorySize;
        java.lang.String packageType;
        java.lang.Number reservedConcurrentExecutions;
        java.lang.String runtime;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Number timeout;
        java.lang.Object tracingConfig;
        java.lang.Object vpcConfig;

        /**
         * Sets the value of {@link CfnFunctionProps#getCode}
         * @param code The code for the function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.core.IResolvable code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getCode}
         * @param code The code for the function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.lambda.CfnFunction.CodeProperty code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getRole}
         * @param role The Amazon Resource Name (ARN) of the function's execution role. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getArchitectures}
         * @param architectures The instruction set architecture that the function supports.
         *                      Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architectures(java.util.List<java.lang.String> architectures) {
            this.architectures = architectures;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getCodeSigningConfigArn}
         * @param codeSigningConfigArn To enable code signing for this function, specify the ARN of a code-signing configuration.
         *                             A code-signing configuration
         *                             includes a set of signing profiles, which define the trusted publishers for this function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningConfigArn(java.lang.String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getDeadLetterConfig}
         * @param deadLetterConfig A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
         *                         For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterConfig(software.amazon.awscdk.core.IResolvable deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getDeadLetterConfig}
         * @param deadLetterConfig A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
         *                         For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterConfig(software.amazon.awscdk.services.lambda.CfnFunction.DeadLetterConfigProperty deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getDescription}
         * @param description A description of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getEnvironment}
         * @param environment Environment variables that are accessible from function code during execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(software.amazon.awscdk.core.IResolvable environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getEnvironment}
         * @param environment Environment variables that are accessible from function code during execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(software.amazon.awscdk.services.lambda.CfnFunction.EnvironmentProperty environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getEphemeralStorage}
         * @param ephemeralStorage The size of the function’s /tmp directory in MB.
         *                         The default value is 512, but can be any whole number between 512 and 10240 MB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(software.amazon.awscdk.core.IResolvable ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getEphemeralStorage}
         * @param ephemeralStorage The size of the function’s /tmp directory in MB.
         *                         The default value is 512, but can be any whole number between 512 and 10240 MB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(software.amazon.awscdk.services.lambda.CfnFunction.EphemeralStorageProperty ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getFileSystemConfigs}
         * @param fileSystemConfigs Connection settings for an Amazon EFS file system.
         *                          To connect a function to a file system, a mount target must be available in every Availability Zone that your function connects to. If your template contains an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html">AWS::EFS::MountTarget</a> resource, you must also specify a <code>DependsOn</code> attribute to ensure that the mount target is created or updated before the function.
         *                          <p>
         *                          For more information about using the <code>DependsOn</code> attribute, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemConfigs(software.amazon.awscdk.core.IResolvable fileSystemConfigs) {
            this.fileSystemConfigs = fileSystemConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getFileSystemConfigs}
         * @param fileSystemConfigs Connection settings for an Amazon EFS file system.
         *                          To connect a function to a file system, a mount target must be available in every Availability Zone that your function connects to. If your template contains an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html">AWS::EFS::MountTarget</a> resource, you must also specify a <code>DependsOn</code> attribute to ensure that the mount target is created or updated before the function.
         *                          <p>
         *                          For more information about using the <code>DependsOn</code> attribute, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemConfigs(java.util.List<? extends java.lang.Object> fileSystemConfigs) {
            this.fileSystemConfigs = fileSystemConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getFunctionName}
         * @param functionName The name of the Lambda function, up to 64 characters in length.
         *                     If you don't specify a name, AWS CloudFormation generates one.
         *                     <p>
         *                     If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getHandler}
         * @param handler The name of the method within your code that Lambda calls to execute your function.
         *                Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(java.lang.String handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getImageConfig}
         * @param imageConfig Configuration values that override the container image Dockerfile settings.
         *                    See <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms">Container settings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfig(software.amazon.awscdk.core.IResolvable imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getImageConfig}
         * @param imageConfig Configuration values that override the container image Dockerfile settings.
         *                    See <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms">Container settings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfig(software.amazon.awscdk.services.lambda.CfnFunction.ImageConfigProperty imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getKmsKeyArn}
         * @param kmsKeyArn The ARN of the AWS Key Management Service ( AWS KMS ) key that's used to encrypt your function's environment variables.
         *                  If it's not provided, AWS Lambda uses a default service key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getLayers}
         * @param layers A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(java.util.List<java.lang.String> layers) {
            this.layers = layers;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getMemorySize}
         * @param memorySize The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(java.lang.Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getPackageType}
         * @param packageType The type of deployment package.
         *                    Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageType(java.lang.String packageType) {
            this.packageType = packageType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getReservedConcurrentExecutions}
         * @param reservedConcurrentExecutions The number of simultaneous executions to reserve for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(java.lang.Number reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getRuntime}
         * @param runtime The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) . Runtime is required if the deployment package is a .zip file archive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(java.lang.String runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getTags}
         * @param tags A list of [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to apply to the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getTimeout}
         * @param timeout The amount of time (in seconds) that Lambda allows a function to run before stopping it.
         *                The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(java.lang.Number timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getTracingConfig}
         * @param tracingConfig Set `Mode` to `Active` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfig(software.amazon.awscdk.core.IResolvable tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getTracingConfig}
         * @param tracingConfig Set `Mode` to `Active` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfig(software.amazon.awscdk.services.lambda.CfnFunction.TracingConfigProperty tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getVpcConfig}
         * @param vpcConfig For network connectivity to AWS resources in a [VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-network.html) , specify a list of security groups and subnets in the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.core.IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionProps#getVpcConfig}
         * @param vpcConfig For network connectivity to AWS resources in a [VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-network.html) , specify a list of security groups and subnets in the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.services.lambda.CfnFunction.VpcConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFunctionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFunctionProps {
        private final java.lang.Object code;
        private final java.lang.String role;
        private final java.util.List<java.lang.String> architectures;
        private final java.lang.String codeSigningConfigArn;
        private final java.lang.Object deadLetterConfig;
        private final java.lang.String description;
        private final java.lang.Object environment;
        private final java.lang.Object ephemeralStorage;
        private final java.lang.Object fileSystemConfigs;
        private final java.lang.String functionName;
        private final java.lang.String handler;
        private final java.lang.Object imageConfig;
        private final java.lang.String kmsKeyArn;
        private final java.util.List<java.lang.String> layers;
        private final java.lang.Number memorySize;
        private final java.lang.String packageType;
        private final java.lang.Number reservedConcurrentExecutions;
        private final java.lang.String runtime;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Number timeout;
        private final java.lang.Object tracingConfig;
        private final java.lang.Object vpcConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.architectures = software.amazon.jsii.Kernel.get(this, "architectures", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.codeSigningConfigArn = software.amazon.jsii.Kernel.get(this, "codeSigningConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deadLetterConfig = software.amazon.jsii.Kernel.get(this, "deadLetterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ephemeralStorage = software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fileSystemConfigs = software.amazon.jsii.Kernel.get(this, "fileSystemConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.handler = software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageConfig = software.amazon.jsii.Kernel.get(this, "imageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.layers = software.amazon.jsii.Kernel.get(this, "layers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.memorySize = software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.packageType = software.amazon.jsii.Kernel.get(this, "packageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.reservedConcurrentExecutions = software.amazon.jsii.Kernel.get(this, "reservedConcurrentExecutions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tracingConfig = software.amazon.jsii.Kernel.get(this, "tracingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.code = java.util.Objects.requireNonNull(builder.code, "code is required");
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.architectures = builder.architectures;
            this.codeSigningConfigArn = builder.codeSigningConfigArn;
            this.deadLetterConfig = builder.deadLetterConfig;
            this.description = builder.description;
            this.environment = builder.environment;
            this.ephemeralStorage = builder.ephemeralStorage;
            this.fileSystemConfigs = builder.fileSystemConfigs;
            this.functionName = builder.functionName;
            this.handler = builder.handler;
            this.imageConfig = builder.imageConfig;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.layers = builder.layers;
            this.memorySize = builder.memorySize;
            this.packageType = builder.packageType;
            this.reservedConcurrentExecutions = builder.reservedConcurrentExecutions;
            this.runtime = builder.runtime;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.timeout = builder.timeout;
            this.tracingConfig = builder.tracingConfig;
            this.vpcConfig = builder.vpcConfig;
        }

        @Override
        public final java.lang.Object getCode() {
            return this.code;
        }

        @Override
        public final java.lang.String getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<java.lang.String> getArchitectures() {
            return this.architectures;
        }

        @Override
        public final java.lang.String getCodeSigningConfigArn() {
            return this.codeSigningConfigArn;
        }

        @Override
        public final java.lang.Object getDeadLetterConfig() {
            return this.deadLetterConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.Object getEphemeralStorage() {
            return this.ephemeralStorage;
        }

        @Override
        public final java.lang.Object getFileSystemConfigs() {
            return this.fileSystemConfigs;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.String getHandler() {
            return this.handler;
        }

        @Override
        public final java.lang.Object getImageConfig() {
            return this.imageConfig;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.util.List<java.lang.String> getLayers() {
            return this.layers;
        }

        @Override
        public final java.lang.Number getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final java.lang.String getPackageType() {
            return this.packageType;
        }

        @Override
        public final java.lang.Number getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        @Override
        public final java.lang.String getRuntime() {
            return this.runtime;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Object getTracingConfig() {
            return this.tracingConfig;
        }

        @Override
        public final java.lang.Object getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("code", om.valueToTree(this.getCode()));
            data.set("role", om.valueToTree(this.getRole()));
            if (this.getArchitectures() != null) {
                data.set("architectures", om.valueToTree(this.getArchitectures()));
            }
            if (this.getCodeSigningConfigArn() != null) {
                data.set("codeSigningConfigArn", om.valueToTree(this.getCodeSigningConfigArn()));
            }
            if (this.getDeadLetterConfig() != null) {
                data.set("deadLetterConfig", om.valueToTree(this.getDeadLetterConfig()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEphemeralStorage() != null) {
                data.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
            }
            if (this.getFileSystemConfigs() != null) {
                data.set("fileSystemConfigs", om.valueToTree(this.getFileSystemConfigs()));
            }
            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getHandler() != null) {
                data.set("handler", om.valueToTree(this.getHandler()));
            }
            if (this.getImageConfig() != null) {
                data.set("imageConfig", om.valueToTree(this.getImageConfig()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getLayers() != null) {
                data.set("layers", om.valueToTree(this.getLayers()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getPackageType() != null) {
                data.set("packageType", om.valueToTree(this.getPackageType()));
            }
            if (this.getReservedConcurrentExecutions() != null) {
                data.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTracingConfig() != null) {
                data.set("tracingConfig", om.valueToTree(this.getTracingConfig()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnFunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFunctionProps.Jsii$Proxy that = (CfnFunctionProps.Jsii$Proxy) o;

            if (!code.equals(that.code)) return false;
            if (!role.equals(that.role)) return false;
            if (this.architectures != null ? !this.architectures.equals(that.architectures) : that.architectures != null) return false;
            if (this.codeSigningConfigArn != null ? !this.codeSigningConfigArn.equals(that.codeSigningConfigArn) : that.codeSigningConfigArn != null) return false;
            if (this.deadLetterConfig != null ? !this.deadLetterConfig.equals(that.deadLetterConfig) : that.deadLetterConfig != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.ephemeralStorage != null ? !this.ephemeralStorage.equals(that.ephemeralStorage) : that.ephemeralStorage != null) return false;
            if (this.fileSystemConfigs != null ? !this.fileSystemConfigs.equals(that.fileSystemConfigs) : that.fileSystemConfigs != null) return false;
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.handler != null ? !this.handler.equals(that.handler) : that.handler != null) return false;
            if (this.imageConfig != null ? !this.imageConfig.equals(that.imageConfig) : that.imageConfig != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.layers != null ? !this.layers.equals(that.layers) : that.layers != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.packageType != null ? !this.packageType.equals(that.packageType) : that.packageType != null) return false;
            if (this.reservedConcurrentExecutions != null ? !this.reservedConcurrentExecutions.equals(that.reservedConcurrentExecutions) : that.reservedConcurrentExecutions != null) return false;
            if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.tracingConfig != null ? !this.tracingConfig.equals(that.tracingConfig) : that.tracingConfig != null) return false;
            return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.code.hashCode();
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.architectures != null ? this.architectures.hashCode() : 0);
            result = 31 * result + (this.codeSigningConfigArn != null ? this.codeSigningConfigArn.hashCode() : 0);
            result = 31 * result + (this.deadLetterConfig != null ? this.deadLetterConfig.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.ephemeralStorage != null ? this.ephemeralStorage.hashCode() : 0);
            result = 31 * result + (this.fileSystemConfigs != null ? this.fileSystemConfigs.hashCode() : 0);
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
            result = 31 * result + (this.imageConfig != null ? this.imageConfig.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.layers != null ? this.layers.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.packageType != null ? this.packageType.hashCode() : 0);
            result = 31 * result + (this.reservedConcurrentExecutions != null ? this.reservedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.tracingConfig != null ? this.tracingConfig.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            return result;
        }
    }
}
