/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cognito;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.cognito.$Module;
import software.amazon.awscdk.services.cognito.CfnIdentityPool;
import software.amazon.awscdk.services.cognito.CfnIdentityPoolProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-cognito.CfnIdentityPool")
public class CfnIdentityPool
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnIdentityPool.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnIdentityPool(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentityPool(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnIdentityPool(@NotNull Construct scope, @NotNull String id, @NotNull CfnIdentityPoolProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrName() {
        return (String)this.jsiiGet("attrName", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getAllowUnauthenticatedIdentities() {
        return this.jsiiGet("allowUnauthenticatedIdentities", Object.class);
    }

    public void setAllowUnauthenticatedIdentities(@NotNull Boolean value) {
        this.jsiiSet("allowUnauthenticatedIdentities", Objects.requireNonNull(value, "allowUnauthenticatedIdentities is required"));
    }

    public void setAllowUnauthenticatedIdentities(@NotNull IResolvable value) {
        this.jsiiSet("allowUnauthenticatedIdentities", Objects.requireNonNull(value, "allowUnauthenticatedIdentities is required"));
    }

    @NotNull
    public Object getCognitoEvents() {
        return this.jsiiGet("cognitoEvents", Object.class);
    }

    public void setCognitoEvents(@NotNull Object value) {
        this.jsiiSet("cognitoEvents", Objects.requireNonNull(value, "cognitoEvents is required"));
    }

    @NotNull
    public Object getSupportedLoginProviders() {
        return this.jsiiGet("supportedLoginProviders", Object.class);
    }

    public void setSupportedLoginProviders(@NotNull Object value) {
        this.jsiiSet("supportedLoginProviders", Objects.requireNonNull(value, "supportedLoginProviders is required"));
    }

    @Nullable
    public Object getAllowClassicFlow() {
        return this.jsiiGet("allowClassicFlow", Object.class);
    }

    public void setAllowClassicFlow(@Nullable Boolean value) {
        this.jsiiSet("allowClassicFlow", value);
    }

    public void setAllowClassicFlow(@Nullable IResolvable value) {
        this.jsiiSet("allowClassicFlow", value);
    }

    @Nullable
    public Object getCognitoIdentityProviders() {
        return this.jsiiGet("cognitoIdentityProviders", Object.class);
    }

    public void setCognitoIdentityProviders(@Nullable IResolvable value) {
        this.jsiiSet("cognitoIdentityProviders", value);
    }

    public void setCognitoIdentityProviders(@Nullable List<Object> value) {
        this.jsiiSet("cognitoIdentityProviders", value);
    }

    @Nullable
    public Object getCognitoStreams() {
        return this.jsiiGet("cognitoStreams", Object.class);
    }

    public void setCognitoStreams(@Nullable IResolvable value) {
        this.jsiiSet("cognitoStreams", value);
    }

    public void setCognitoStreams(@Nullable CognitoStreamsProperty value) {
        this.jsiiSet("cognitoStreams", value);
    }

    @Nullable
    public String getDeveloperProviderName() {
        return (String)this.jsiiGet("developerProviderName", String.class);
    }

    public void setDeveloperProviderName(@Nullable String value) {
        this.jsiiSet("developerProviderName", value);
    }

    @Nullable
    public String getIdentityPoolName() {
        return (String)this.jsiiGet("identityPoolName", String.class);
    }

    public void setIdentityPoolName(@Nullable String value) {
        this.jsiiSet("identityPoolName", value);
    }

    @Nullable
    public List<String> getOpenIdConnectProviderArns() {
        return Optional.ofNullable((List)this.jsiiGet("openIdConnectProviderArns", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setOpenIdConnectProviderArns(@Nullable List<String> value) {
        this.jsiiSet("openIdConnectProviderArns", value);
    }

    @Nullable
    public Object getPushSync() {
        return this.jsiiGet("pushSync", Object.class);
    }

    public void setPushSync(@Nullable IResolvable value) {
        this.jsiiSet("pushSync", value);
    }

    public void setPushSync(@Nullable PushSyncProperty value) {
        this.jsiiSet("pushSync", value);
    }

    @Nullable
    public List<String> getSamlProviderArns() {
        return Optional.ofNullable((List)this.jsiiGet("samlProviderArns", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSamlProviderArns(@Nullable List<String> value) {
        this.jsiiSet("samlProviderArns", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnIdentityPool> {
        private final Construct scope;
        private final String id;
        private final CfnIdentityPoolProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnIdentityPoolProps.Builder();
        }

        public Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.props.allowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
            return this;
        }

        public Builder allowUnauthenticatedIdentities(IResolvable allowUnauthenticatedIdentities) {
            this.props.allowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
            return this;
        }

        public Builder allowClassicFlow(Boolean allowClassicFlow) {
            this.props.allowClassicFlow(allowClassicFlow);
            return this;
        }

        public Builder allowClassicFlow(IResolvable allowClassicFlow) {
            this.props.allowClassicFlow(allowClassicFlow);
            return this;
        }

        public Builder cognitoEvents(Object cognitoEvents) {
            this.props.cognitoEvents(cognitoEvents);
            return this;
        }

        public Builder cognitoIdentityProviders(IResolvable cognitoIdentityProviders) {
            this.props.cognitoIdentityProviders(cognitoIdentityProviders);
            return this;
        }

        public Builder cognitoIdentityProviders(List<Object> cognitoIdentityProviders) {
            this.props.cognitoIdentityProviders(cognitoIdentityProviders);
            return this;
        }

        public Builder cognitoStreams(IResolvable cognitoStreams) {
            this.props.cognitoStreams(cognitoStreams);
            return this;
        }

        public Builder cognitoStreams(CognitoStreamsProperty cognitoStreams) {
            this.props.cognitoStreams(cognitoStreams);
            return this;
        }

        public Builder developerProviderName(String developerProviderName) {
            this.props.developerProviderName(developerProviderName);
            return this;
        }

        public Builder identityPoolName(String identityPoolName) {
            this.props.identityPoolName(identityPoolName);
            return this;
        }

        public Builder openIdConnectProviderArns(List<String> openIdConnectProviderArns) {
            this.props.openIdConnectProviderArns(openIdConnectProviderArns);
            return this;
        }

        public Builder pushSync(IResolvable pushSync) {
            this.props.pushSync(pushSync);
            return this;
        }

        public Builder pushSync(PushSyncProperty pushSync) {
            this.props.pushSync(pushSync);
            return this;
        }

        public Builder samlProviderArns(List<String> samlProviderArns) {
            this.props.samlProviderArns(samlProviderArns);
            return this;
        }

        public Builder supportedLoginProviders(Object supportedLoginProviders) {
            this.props.supportedLoginProviders(supportedLoginProviders);
            return this;
        }

        public CfnIdentityPool build() {
            return new CfnIdentityPool(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cognito.CfnIdentityPool.PushSyncProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PushSyncProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getApplicationArns() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PushSyncProperty> {
            private List<String> applicationArns;
            private String roleArn;

            public Builder applicationArns(List<String> applicationArns) {
                this.applicationArns = applicationArns;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public PushSyncProperty build() {
                return new Jsii.Proxy(this.applicationArns, this.roleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cognito.CfnIdentityPool.CognitoStreamsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CognitoStreamsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getRoleArn() {
            return null;
        }

        @Nullable
        default public String getStreamingStatus() {
            return null;
        }

        @Nullable
        default public String getStreamName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CognitoStreamsProperty> {
            private String roleArn;
            private String streamingStatus;
            private String streamName;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder streamingStatus(String streamingStatus) {
                this.streamingStatus = streamingStatus;
                return this;
            }

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public CognitoStreamsProperty build() {
                return new Jsii.Proxy(this.roleArn, this.streamingStatus, this.streamName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cognito.CfnIdentityPool.CognitoIdentityProviderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CognitoIdentityProviderProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClientId() {
            return null;
        }

        @Nullable
        default public String getProviderName() {
            return null;
        }

        @Nullable
        default public Object getServerSideTokenCheck() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CognitoIdentityProviderProperty> {
            private String clientId;
            private String providerName;
            private Object serverSideTokenCheck;

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder providerName(String providerName) {
                this.providerName = providerName;
                return this;
            }

            public Builder serverSideTokenCheck(Boolean serverSideTokenCheck) {
                this.serverSideTokenCheck = serverSideTokenCheck;
                return this;
            }

            public Builder serverSideTokenCheck(IResolvable serverSideTokenCheck) {
                this.serverSideTokenCheck = serverSideTokenCheck;
                return this;
            }

            public CognitoIdentityProviderProperty build() {
                return new Jsii.Proxy(this.clientId, this.providerName, this.serverSideTokenCheck, null);
            }
        }
    }
}

