package software.amazon.awscdk.services.codepipeline;

/**
 * An interface representing resources generated in order to support the cross-region capabilities of CodePipeline.
 * <p>
 * You get instances of this interface from the {&#64;link Pipeline#crossRegionSupport} property.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.402Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.CrossRegionSupport")
@software.amazon.jsii.Jsii.Proxy(CrossRegionSupport.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CrossRegionSupport extends software.amazon.jsii.JsiiSerializable {

    /**
     * The replication Bucket used by CodePipeline to operate in this region.
     * <p>
     * Belongs to {&#64;link stack}.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getReplicationBucket();

    /**
     * The Stack that has been created to house the replication Bucket required for this  region.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack();

    /**
     * @return a {@link Builder} of {@link CrossRegionSupport}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CrossRegionSupport}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CrossRegionSupport> {
        private software.amazon.awscdk.services.s3.IBucket replicationBucket;
        private software.amazon.awscdk.core.Stack stack;

        /**
         * Sets the value of {@link CrossRegionSupport#getReplicationBucket}
         * @param replicationBucket The replication Bucket used by CodePipeline to operate in this region. This parameter is required.
         *                          Belongs to {&#64;link stack}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replicationBucket(software.amazon.awscdk.services.s3.IBucket replicationBucket) {
            this.replicationBucket = replicationBucket;
            return this;
        }

        /**
         * Sets the value of {@link CrossRegionSupport#getStack}
         * @param stack The Stack that has been created to house the replication Bucket required for this  region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stack(software.amazon.awscdk.core.Stack stack) {
            this.stack = stack;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CrossRegionSupport}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CrossRegionSupport build() {
            return new Jsii$Proxy(replicationBucket, stack);
        }
    }

    /**
     * An implementation for {@link CrossRegionSupport}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionSupport {
        private final software.amazon.awscdk.services.s3.IBucket replicationBucket;
        private final software.amazon.awscdk.core.Stack stack;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.replicationBucket = this.jsiiGet("replicationBucket", software.amazon.awscdk.services.s3.IBucket.class);
            this.stack = this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.s3.IBucket replicationBucket, final software.amazon.awscdk.core.Stack stack) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.replicationBucket = java.util.Objects.requireNonNull(replicationBucket, "replicationBucket is required");
            this.stack = java.util.Objects.requireNonNull(stack, "stack is required");
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getReplicationBucket() {
            return this.replicationBucket;
        }

        @Override
        public software.amazon.awscdk.core.Stack getStack() {
            return this.stack;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("replicationBucket", om.valueToTree(this.getReplicationBucket()));
            data.set("stack", om.valueToTree(this.getStack()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline.CrossRegionSupport"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CrossRegionSupport.Jsii$Proxy that = (CrossRegionSupport.Jsii$Proxy) o;

            if (!replicationBucket.equals(that.replicationBucket)) return false;
            return this.stack.equals(that.stack);
        }

        @Override
        public int hashCode() {
            int result = this.replicationBucket.hashCode();
            result = 31 * result + (this.stack.hashCode());
            return result;
        }
    }
}
