package software.amazon.awscdk.services.codepipeline;

/**
 * An output artifact of an action.
 * <p>
 * Artifacts can be used as input by some actions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.386Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.Artifact")
public class Artifact extends software.amazon.jsii.JsiiObject {

    protected Artifact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Artifact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param artifactName
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Artifact(final @org.jetbrains.annotations.Nullable java.lang.String artifactName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { artifactName });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Artifact() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A static factory method used to create instances of the Artifact class.
     * <p>
     * Mainly meant to be used from <code>decdk</code>.
     * <p>
     * @param name the (required) name of the Artifact. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact artifact(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.Artifact.class, "artifact", software.amazon.awscdk.services.codepipeline.Artifact.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Returns an ArtifactPath for a file within this artifact.
     * <p>
     * CfnOutput is in the form "<artifact-name>::<file-name>"
     * <p>
     * @param fileName The name of the file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ArtifactPath atPath(final @org.jetbrains.annotations.NotNull java.lang.String fileName) {
        return this.jsiiCall("atPath", software.amazon.awscdk.services.codepipeline.ArtifactPath.class, new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required") });
    }

    /**
     * Retrieve the metadata stored in this artifact under the given key.
     * <p>
     * If there is no metadata stored under the given key,
     * null will be returned.
     * <p>
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMetadata(final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return this.jsiiCall("getMetadata", java.lang.Object.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Returns a token for a value inside a JSON file within this artifact.
     * <p>
     * @param jsonFile The JSON file name. This parameter is required.
     * @param keyName The hash key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParam(final @org.jetbrains.annotations.NotNull java.lang.String jsonFile, final @org.jetbrains.annotations.NotNull java.lang.String keyName) {
        return this.jsiiCall("getParam", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(jsonFile, "jsonFile is required"), java.util.Objects.requireNonNull(keyName, "keyName is required") });
    }

    /**
     * Add arbitrary extra payload to the artifact under a given key.
     * <p>
     * This can be used by CodePipeline actions to communicate data between themselves.
     * If metadata was already present under the given key,
     * it will be overwritten with the new value.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetadata(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiCall("setMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * The artifact attribute for the name of the S3 bucket where the artifact is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * The artifact attribute for The name of the .zip file that contains the artifact that is generated by AWS CodePipeline, such as 1ABCyZZ.zip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getObjectKey() {
        return this.jsiiGet("objectKey", java.lang.String.class);
    }

    /**
     * Returns the location of the .zip file in S3 that this Artifact represents. Used by Lambda's `CfnParametersCode` when being deployed in a CodePipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.Location getS3Location() {
        return this.jsiiGet("s3Location", software.amazon.awscdk.services.s3.Location.class);
    }

    /**
     * The artifact attribute of the Amazon Simple Storage Service (Amazon S3) URL of the artifact, such as https://s3-us-west-2.amazonaws.com/artifactstorebucket-yivczw8jma0c/test/TemplateSo/1ABCyZZ.zip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUrl() {
        return this.jsiiGet("url", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getArtifactName() {
        return this.jsiiGet("artifactName", java.lang.String.class);
    }
}
