/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.assets.docker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.assets.CopyOptions;
import software.amazon.awscdk.assets.FollowMode;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface DockerImageAssetProps
extends JsiiSerializable,
CopyOptions {
    public String getDirectory();

    public Map<String, String> getBuildArgs();

    public String getRepositoryName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _directory;
        @Nullable
        private Map<String, String> _buildArgs;
        @Nullable
        private String _repositoryName;
        @Nullable
        private List<String> _exclude;
        @Nullable
        private FollowMode _follow;

        public Builder withDirectory(String value) {
            this._directory = Objects.requireNonNull(value, "directory is required");
            return this;
        }

        public Builder withBuildArgs(@Nullable Map<String, String> value) {
            this._buildArgs = value;
            return this;
        }

        public Builder withRepositoryName(@Nullable String value) {
            this._repositoryName = value;
            return this;
        }

        public Builder withExclude(@Nullable List<String> value) {
            this._exclude = value;
            return this;
        }

        public Builder withFollow(@Nullable FollowMode value) {
            this._follow = value;
            return this;
        }

        public DockerImageAssetProps build() {
            return new DockerImageAssetProps(){
                private final String $directory;
                @Nullable
                private final Map<String, String> $buildArgs;
                @Nullable
                private final String $repositoryName;
                @Nullable
                private final List<String> $exclude;
                @Nullable
                private final FollowMode $follow;
                {
                    this.$directory = Objects.requireNonNull(_directory, "directory is required");
                    this.$buildArgs = _buildArgs;
                    this.$repositoryName = _repositoryName;
                    this.$exclude = _exclude;
                    this.$follow = _follow;
                }

                @Override
                public String getDirectory() {
                    return this.$directory;
                }

                @Override
                public Map<String, String> getBuildArgs() {
                    return this.$buildArgs;
                }

                @Override
                public String getRepositoryName() {
                    return this.$repositoryName;
                }

                public List<String> getExclude() {
                    return this.$exclude;
                }

                public FollowMode getFollow() {
                    return this.$follow;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("directory", om.valueToTree((Object)this.getDirectory()));
                    obj.set("buildArgs", om.valueToTree(this.getBuildArgs()));
                    obj.set("repositoryName", om.valueToTree((Object)this.getRepositoryName()));
                    obj.set("exclude", om.valueToTree(this.getExclude()));
                    obj.set("follow", om.valueToTree((Object)this.getFollow()));
                    return obj;
                }
            };
        }
    }
}

