/**
 * <h1>Asset with AWS CLI v1</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module bundles the AWS CLI v1 as a local asset. It exposes
 * constants <code>ASSET_FILE</code> and <code>LAYER_SOURCE_DIR</code> that can be consumed
 * via the CDK <code>Asset</code> construct.
 * <p>
 * Any Lambda Function that uses uses this asset must use a Python 3.x
 * runtime.
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // AwsCliLayer bundles the AWS CLI in a lambda layer
 * import { ASSET_FILE, LAYER_SOURCE_DIR } from '&#64;aws-cdk/asset-awscli-v1';
 * import * as lambda from 'aws-cdk-lib/aws-lambda';
 * import * as s3_assets from 'aws-cdk-lib/aws-s3-assets';
 * import { FileSystem } from 'aws-cdk-lib';
 * 
 * declare const fn: lambda.Function;
 * const asset = new s3_assets.Asset(this, 'layer-asset', {
 *   path: ASSET_FILE,
 *   assetHash: FileSystem.fingerprint(LAYER_SOURCE_DIR),
 * });
 * fn.addLayers(new lambda.LayerVersion(this, 'AwsCliLayer', {
 *   code: lambda.Code.fromBucket(asset.bucket, asset.s3ObjectKey),
 * }));
 * </pre></blockquote>
 * <p>
 * The CLI will be installed under <code>/opt/awscli/aws</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.cdk.asset.awscli.v1;
