package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a Fail state.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Fail fail = Fail.Builder.create(this, "Fail")
 *         .errorPath(JsonPath.format("error: {}.", JsonPath.stringAt("$.someError")))
 *         .causePath("States.Format('cause: {}.', $.someCause)")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:21.312Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.FailProps")
@software.amazon.jsii.Jsii.Proxy(FailProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FailProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.StateBaseProps {

    /**
     * A description for the cause of the failure.
     * <p>
     * Default: - No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCause() {
        return null;
    }

    /**
     * JsonPath expression to select part of the state to be the cause to this state.
     * <p>
     * You can also use an intrinsic function that returns a string to specify this property.
     * The allowed functions include States.Format, States.JsonToString, States.ArrayGetItem, States.Base64Encode, States.Base64Decode, States.Hash, and States.UUID.
     * <p>
     * Default: - No cause path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCausePath() {
        return null;
    }

    /**
     * Error code used to represent this failure.
     * <p>
     * Default: - No error code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getError() {
        return null;
    }

    /**
     * JsonPath expression to select part of the state to be the error to this state.
     * <p>
     * You can also use an intrinsic function that returns a string to specify this property.
     * The allowed functions include States.Format, States.JsonToString, States.ArrayGetItem, States.Base64Encode, States.Base64Decode, States.Hash, and States.UUID.
     * <p>
     * Default: - No error path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getErrorPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FailProps> {
        java.lang.String cause;
        java.lang.String causePath;
        java.lang.String error;
        java.lang.String errorPath;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;

        /**
         * Sets the value of {@link FailProps#getCause}
         * @param cause A description for the cause of the failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cause(java.lang.String cause) {
            this.cause = cause;
            return this;
        }

        /**
         * Sets the value of {@link FailProps#getCausePath}
         * @param causePath JsonPath expression to select part of the state to be the cause to this state.
         *                  You can also use an intrinsic function that returns a string to specify this property.
         *                  The allowed functions include States.Format, States.JsonToString, States.ArrayGetItem, States.Base64Encode, States.Base64Decode, States.Hash, and States.UUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder causePath(java.lang.String causePath) {
            this.causePath = causePath;
            return this;
        }

        /**
         * Sets the value of {@link FailProps#getError}
         * @param error Error code used to represent this failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder error(java.lang.String error) {
            this.error = error;
            return this;
        }

        /**
         * Sets the value of {@link FailProps#getErrorPath}
         * @param errorPath JsonPath expression to select part of the state to be the error to this state.
         *                  You can also use an intrinsic function that returns a string to specify this property.
         *                  The allowed functions include States.Format, States.JsonToString, States.ArrayGetItem, States.Base64Encode, States.Base64Decode, States.Hash, and States.UUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorPath(java.lang.String errorPath) {
            this.errorPath = errorPath;
            return this;
        }

        /**
         * Sets the value of {@link FailProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link FailProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link FailProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FailProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FailProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailProps {
        private final java.lang.String cause;
        private final java.lang.String causePath;
        private final java.lang.String error;
        private final java.lang.String errorPath;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cause = software.amazon.jsii.Kernel.get(this, "cause", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.causePath = software.amazon.jsii.Kernel.get(this, "causePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.error = software.amazon.jsii.Kernel.get(this, "error", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.errorPath = software.amazon.jsii.Kernel.get(this, "errorPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cause = builder.cause;
            this.causePath = builder.causePath;
            this.error = builder.error;
            this.errorPath = builder.errorPath;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
        }

        @Override
        public final java.lang.String getCause() {
            return this.cause;
        }

        @Override
        public final java.lang.String getCausePath() {
            return this.causePath;
        }

        @Override
        public final java.lang.String getError() {
            return this.error;
        }

        @Override
        public final java.lang.String getErrorPath() {
            return this.errorPath;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCause() != null) {
                data.set("cause", om.valueToTree(this.getCause()));
            }
            if (this.getCausePath() != null) {
                data.set("causePath", om.valueToTree(this.getCausePath()));
            }
            if (this.getError() != null) {
                data.set("error", om.valueToTree(this.getError()));
            }
            if (this.getErrorPath() != null) {
                data.set("errorPath", om.valueToTree(this.getErrorPath()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.FailProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FailProps.Jsii$Proxy that = (FailProps.Jsii$Proxy) o;

            if (this.cause != null ? !this.cause.equals(that.cause) : that.cause != null) return false;
            if (this.causePath != null ? !this.causePath.equals(that.causePath) : that.causePath != null) return false;
            if (this.error != null ? !this.error.equals(that.error) : that.error != null) return false;
            if (this.errorPath != null ? !this.errorPath.equals(that.errorPath) : that.errorPath != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            return this.stateName != null ? this.stateName.equals(that.stateName) : that.stateName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cause != null ? this.cause.hashCode() : 0;
            result = 31 * result + (this.causePath != null ? this.causePath.hashCode() : 0);
            result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
            result = 31 * result + (this.errorPath != null ? this.errorPath.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            return result;
        }
    }
}
