package software.amazon.awscdk.services.route53.targets;

/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain name will be defined through <code>RestApiProps.domainName</code>.
 * <p>
 * You can direct the alias to any <code>apigateway.DomainName</code> resource through the
 * <code>ApiGatewayDomain</code> class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.route53.*;
 * import software.amazon.awscdk.services.route53.targets.*;
 * RestApi api;
 * Object hostedZoneForExampleCom;
 * ARecord.Builder.create(this, "CustomDomainAliasRecord")
 *         .zone(hostedZoneForExampleCom)
 *         .target(RecordTarget.fromAlias(new ApiGateway(api)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:19.739Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53_targets.ApiGateway")
public class ApiGateway extends software.amazon.awscdk.services.route53.targets.ApiGatewayDomain {

    protected ApiGateway(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiGateway(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param api This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApiGateway(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApiBase api) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(api, "api is required") });
    }
}
