package software.amazon.awscdk.services.rds;

/**
 * The scalability mode of the Aurora DB cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * DatabaseCluster.Builder.create(this, "LimitlessDatabaseCluster")
 *         .engine(DatabaseClusterEngine.auroraPostgres(AuroraPostgresClusterEngineProps.builder()
 *                 .version(AuroraPostgresEngineVersion.VER_16_4_LIMITLESS)
 *                 .build()))
 *         .vpc(vpc)
 *         .clusterScalabilityType(ClusterScalabilityType.LIMITLESS)
 *         // Requires enabling Performance Insights
 *         .enablePerformanceInsights(true)
 *         .performanceInsightRetention(PerformanceInsightRetention.MONTHS_1)
 *         // Requires enabling Enhanced Monitoring at the cluster level
 *         .monitoringInterval(Duration.minutes(1))
 *         .enableClusterLevelEnhancedMonitoring(true)
 *         // Requires I/O optimized storage type
 *         .storageType(DBClusterStorageType.AURORA_IOPT1)
 *         // Requires exporting the PostgreSQL log to Amazon CloudWatch Logs.
 *         .cloudwatchLogsExports(List.of("postgresql"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:19.277Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ClusterScalabilityType")
public enum ClusterScalabilityType {
    /**
     * The cluster uses normal DB instance creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * The cluster operates as an Aurora Limitless Database, allowing you to create a DB shard group for horizontal scaling (sharding) capabilities.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/limitless.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/limitless.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LIMITLESS,
}
