package software.amazon.awscdk.services.rds;

/**
 * Options for binding the instance to the cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.rds.*;
 * Role role;
 * SubnetGroup subnetGroup;
 * ClusterInstanceBindOptions clusterInstanceBindOptions = ClusterInstanceBindOptions.builder()
 *         .monitoringInterval(Duration.minutes(30))
 *         .monitoringRole(role)
 *         .promotionTier(123)
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .subnetGroup(subnetGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:19.273Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ClusterInstanceBindOptions")
@software.amazon.jsii.Jsii.Proxy(ClusterInstanceBindOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClusterInstanceBindOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instances.
     * <p>
     * Default: no enhanced monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMonitoringInterval() {
        return null;
    }

    /**
     * Role that will be used to manage DB instances monitoring.
     * <p>
     * Default: - A role is automatically created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
        return null;
    }

    /**
     * The promotion tier of the cluster instance.
     * <p>
     * This matters more for serverlessV2 instances. If a serverless
     * instance is in tier 0-1 then it will scale with the writer.
     * <p>
     * For provisioned instances this just determines the failover priority.
     * If multiple instances have the same priority then one will be picked at random
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPromotionTier() {
        return null;
    }

    /**
     * The removal policy on the cluster.
     * <p>
     * Default: - RemovalPolicy.DESTROY (cluster snapshot can restore)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Existing subnet group for the cluster.
     * <p>
     * This is only needed when using the isFromLegacyInstanceProps
     * <p>
     * Default: - cluster subnet group is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterInstanceBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterInstanceBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterInstanceBindOptions> {
        software.amazon.awscdk.Duration monitoringInterval;
        software.amazon.awscdk.services.iam.IRole monitoringRole;
        java.lang.Number promotionTier;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;

        /**
         * Sets the value of {@link ClusterInstanceBindOptions#getMonitoringInterval}
         * @param monitoringInterval The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(software.amazon.awscdk.Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        /**
         * Sets the value of {@link ClusterInstanceBindOptions#getMonitoringRole}
         * @param monitoringRole Role that will be used to manage DB instances monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRole(software.amazon.awscdk.services.iam.IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        /**
         * Sets the value of {@link ClusterInstanceBindOptions#getPromotionTier}
         * @param promotionTier The promotion tier of the cluster instance.
         *                      This matters more for serverlessV2 instances. If a serverless
         *                      instance is in tier 0-1 then it will scale with the writer.
         *                      <p>
         *                      For provisioned instances this just determines the failover priority.
         *                      If multiple instances have the same priority then one will be picked at random
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promotionTier(java.lang.Number promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        /**
         * Sets the value of {@link ClusterInstanceBindOptions#getRemovalPolicy}
         * @param removalPolicy The removal policy on the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ClusterInstanceBindOptions#getSubnetGroup}
         * @param subnetGroup Existing subnet group for the cluster.
         *                    This is only needed when using the isFromLegacyInstanceProps
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroup(software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterInstanceBindOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClusterInstanceBindOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterInstanceBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterInstanceBindOptions {
        private final software.amazon.awscdk.Duration monitoringInterval;
        private final software.amazon.awscdk.services.iam.IRole monitoringRole;
        private final java.lang.Number promotionTier;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.monitoringInterval = software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.monitoringRole = software.amazon.jsii.Kernel.get(this, "monitoringRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.promotionTier = software.amazon.jsii.Kernel.get(this, "promotionTier", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.subnetGroup = software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ISubnetGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.monitoringInterval = builder.monitoringInterval;
            this.monitoringRole = builder.monitoringRole;
            this.promotionTier = builder.promotionTier;
            this.removalPolicy = builder.removalPolicy;
            this.subnetGroup = builder.subnetGroup;
        }

        @Override
        public final software.amazon.awscdk.Duration getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
            return this.monitoringRole;
        }

        @Override
        public final java.lang.Number getPromotionTier() {
            return this.promotionTier;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMonitoringInterval() != null) {
                data.set("monitoringInterval", om.valueToTree(this.getMonitoringInterval()));
            }
            if (this.getMonitoringRole() != null) {
                data.set("monitoringRole", om.valueToTree(this.getMonitoringRole()));
            }
            if (this.getPromotionTier() != null) {
                data.set("promotionTier", om.valueToTree(this.getPromotionTier()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSubnetGroup() != null) {
                data.set("subnetGroup", om.valueToTree(this.getSubnetGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ClusterInstanceBindOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterInstanceBindOptions.Jsii$Proxy that = (ClusterInstanceBindOptions.Jsii$Proxy) o;

            if (this.monitoringInterval != null ? !this.monitoringInterval.equals(that.monitoringInterval) : that.monitoringInterval != null) return false;
            if (this.monitoringRole != null ? !this.monitoringRole.equals(that.monitoringRole) : that.monitoringRole != null) return false;
            if (this.promotionTier != null ? !this.promotionTier.equals(that.promotionTier) : that.promotionTier != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.subnetGroup != null ? this.subnetGroup.equals(that.subnetGroup) : that.subnetGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.monitoringInterval != null ? this.monitoringInterval.hashCode() : 0;
            result = 31 * result + (this.monitoringRole != null ? this.monitoringRole.hashCode() : 0);
            result = 31 * result + (this.promotionTier != null ? this.promotionTier.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.subnetGroup != null ? this.subnetGroup.hashCode() : 0);
            return result;
        }
    }
}
