package software.amazon.awscdk.services.rds;

/**
 * Creates a new DB shard group for Aurora Limitless Database.
 * <p>
 * You must enable Aurora Limitless Database to create a DB shard group.
 * <p>
 * Valid for: Aurora DB clusters only
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBShardGroup cfnDBShardGroup = CfnDBShardGroup.Builder.create(this, "MyCfnDBShardGroup")
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .maxAcu(123)
 *         // the properties below are optional
 *         .computeRedundancy(123)
 *         .dbShardGroupIdentifier("dbShardGroupIdentifier")
 *         .minAcu(123)
 *         .publiclyAccessible(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:19.248Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBShardGroup")
public class CfnDBShardGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDBShardGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBShardGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBShardGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBShardGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBShardGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The AWS Region -unique, immutable identifier for the DB shard group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbShardGroupResourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrDbShardGroupResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This data type represents the information you need to connect to an Amazon RDS DB instance.
     * <p>
     * This data type is used as a response element in the following actions:
     * <p>
     * <ul>
     * <li><code>CreateDBInstance</code></li>
     * <li><code>DescribeDBInstances</code></li>
     * <li><code>DeleteDBInstance</code></li>
     * </ul>
     * <p>
     * For the data structure that represents Amazon Aurora DB cluster endpoints, see <code>DBClusterEndpoint</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the primary DB cluster for the DB shard group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the primary DB cluster for the DB shard group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifier", java.util.Objects.requireNonNull(value, "dbClusterIdentifier is required"));
    }

    /**
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxAcu() {
        return software.amazon.jsii.Kernel.get(this, "maxAcu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxAcu(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxAcu", java.util.Objects.requireNonNull(value, "maxAcu is required"));
    }

    /**
     * Specifies whether to create standby DB shard groups for the DB shard group.
     * <p>
     * Valid values are the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getComputeRedundancy() {
        return software.amazon.jsii.Kernel.get(this, "computeRedundancy", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies whether to create standby DB shard groups for the DB shard group.
     * <p>
     * Valid values are the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeRedundancy(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "computeRedundancy", value);
    }

    /**
     * The name of the DB shard group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbShardGroupIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbShardGroupIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the DB shard group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbShardGroupIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbShardGroupIdentifier", value);
    }

    /**
     * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinAcu() {
        return software.amazon.jsii.Kernel.get(this, "minAcu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinAcu(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minAcu", value);
    }

    /**
     * Specifies whether the DB shard group is publicly accessible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the DB shard group is publicly accessible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * Specifies whether the DB shard group is publicly accessible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBShardGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBShardGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnDBShardGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnDBShardGroupProps.Builder();
        }

        /**
         * The name of the primary DB cluster for the DB shard group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-dbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-dbclusteridentifier</a>
         * @param dbClusterIdentifier The name of the primary DB cluster for the DB shard group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(final java.lang.String dbClusterIdentifier) {
            this.props.dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        /**
         * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-maxacu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-maxacu</a>
         * @param maxAcu The maximum capacity of the DB shard group in Aurora capacity units (ACUs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAcu(final java.lang.Number maxAcu) {
            this.props.maxAcu(maxAcu);
            return this;
        }

        /**
         * Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:.
         * <p>
         * <ul>
         * <li>0 - Creates a DB shard group without a standby DB shard group. This is the default value.</li>
         * <li>1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).</li>
         * <li>2 - Creates a DB shard group with two standby DB shard groups in two different AZs.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-computeredundancy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-computeredundancy</a>
         * @param computeRedundancy Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeRedundancy(final java.lang.Number computeRedundancy) {
            this.props.computeRedundancy(computeRedundancy);
            return this;
        }

        /**
         * The name of the DB shard group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-dbshardgroupidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-dbshardgroupidentifier</a>
         * @param dbShardGroupIdentifier The name of the DB shard group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbShardGroupIdentifier(final java.lang.String dbShardGroupIdentifier) {
            this.props.dbShardGroupIdentifier(dbShardGroupIdentifier);
            return this;
        }

        /**
         * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-minacu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-minacu</a>
         * @param minAcu The minimum capacity of the DB shard group in Aurora capacity units (ACUs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAcu(final java.lang.Number minAcu) {
            this.props.minAcu(minAcu);
            return this;
        }

        /**
         * Specifies whether the DB shard group is publicly accessible.
         * <p>
         * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
         * <p>
         * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         * <p>
         * <ul>
         * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
         * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.</li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         * <p>
         * <ul>
         * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
         * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-publiclyaccessible</a>
         * @param publiclyAccessible Specifies whether the DB shard group is publicly accessible. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * Specifies whether the DB shard group is publicly accessible.
         * <p>
         * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
         * <p>
         * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         * <p>
         * <ul>
         * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
         * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.</li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         * <p>
         * <ul>
         * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
         * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-publiclyaccessible</a>
         * @param publiclyAccessible Specifies whether the DB shard group is publicly accessible. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-tags</a>
         * @param tags An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBShardGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBShardGroup build() {
            return new software.amazon.awscdk.services.rds.CfnDBShardGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
